﻿using System;
using System.Runtime.Serialization;
using HIPS.CommonSchemas;

namespace HIPS.ConsentSchemas
{
    /// <summary>
    /// This class is the response from HIPS for a request to get the PCEHR
    /// participation status, either for a single patient or for all patients
    /// with recent changes to their records.
    /// </summary>
    [KnownType(typeof(PatientParticipationResponse))]
    [Serializable]
    [DataContract]
    public class PatientParticipationResponse
    {
        private PatientParticipationStatus[] patientParticipationField;
        private HipsResponse responseField;

        /// <summary>
        /// The information required for the calling system to identify one or
        /// more patient records and their current PCEHR participation status.
        /// </summary>
        [DataMember]
        public PatientParticipationStatus[] PatientParticipationList
        {
            get
            {
                return patientParticipationField;
            }
            set
            {
                patientParticipationField = value;
            }
        }

        /// <summary>
        /// Gets or sets an indicator of success or failure and in case of failure,
        /// the reason for the failure.
        /// </summary>
        [DataMember]
        public HipsResponse Response
        {
            get
            {
                return responseField;
            }
            set
            {
                responseField = value;
            }
        }
    }
}