﻿using HIPS.HibIntegration.HL7.Segment;
using HIPS.HibIntegration.HL7.SegmentGroup;

namespace HIPS.HibIntegration.HL7.Message
{
    /// <summary>
    /// This class represents a generic HL7 message from a Laboratory Information System.
    /// This covers all pathology test result messages.
    /// Note that the first segment MSH is declared in the superclass HL7Message.
    /// </summary>
    public class HL7GenericPathMessage : HL7Message
    {
        public EVN Event;
        public PID PatientIdentification;
        public ORC CommonOrder;
        public NTE[] Note;
        public ObservationGroup[] Observation;
    }
}