﻿using System.Data.SqlClient;
using HIPS.Common.PcehrDataStore.DataAccess;
using HIPS.CommonSchemas;
using HIPS.PcehrDataStore.Schemas;

namespace HIPS.PcehrDataStore.DataAccess
{
    /// <summary>
    /// This class allows access to the DisclosureAudit table.
    /// </summary>
    public class DisclosureAuditDl : BaseDl
    {
        #region Constructors

        public DisclosureAuditDl(UserDetails user)
            : base(user)
        {
        }

        #endregion Constructors

        #region Methods

        /// <summary>
        /// Inserts the specified disclosure audit record.
        /// </summary>
        /// <param name="DisclosureAudit">The disclosure audit record.</param>
        /// <returns>Whether the disclosure audit record was inserted.</returns>
        public bool Insert(DisclosureAudit DisclosureAudit)
        {
            using (SqlCommand command = GetSqlCommand("hips.DisclosureAuditInsert"))
            {
                return base.Insert<DisclosureAudit>(DisclosureAudit, command);
            }
        }

        #endregion Methods
    }
}