﻿using System.Data.SqlClient;
using HIPS.Common.PcehrDataStore.DataAccess;
using HIPS.PcehrDataStore.Schemas;

namespace HIPS.PcehrDataStore.DataAccess
{
    /// <summary>
    /// This class performs all data access on the Patient Master Override Table
    /// </summary>
    public class PatientMasterOverrideDl : BaseDl
    {
        #region Methods

        /// <summary>
        /// Deletes the specified item.
        /// </summary>
        /// <param name="item">The item.</param>
        /// <returns></returns>
        public bool Delete(PatientMasterOverride item)
        {
            using (SqlCommand command = GetSqlCommand("puma.PatientMasterOverrideDelete"))
            {
                return base.Delete<PatientMasterOverride>(item, command);
            }
        }

        /// <summary>
        /// Updates the specified item.
        /// </summary>
        /// <param name="item">The item.</param>
        /// <returns></returns>
        public bool Save(PatientMasterOverride item)
        {
            using (SqlCommand command = GetSqlCommand("puma.PatientMasterOverrideSave"))
            {
                return base.Update<PatientMasterOverride>(item, command);
            }
        }

        #endregion Methods
    }
}