﻿using System;
using System.Runtime.Serialization;
using HIPS.Base.Schemas;
using BaseEnumerators = HIPS.Base.Schemas.Enumerators;

namespace HIPS.PcehrDataStore.Schemas
{
    /// <summary>
    /// This class represents an episode that the patient had within the hospital system
    /// </summary>
    [KnownType(typeof(Episode))]
    [Serializable]
    [DataContract]
    public class Episode : BaseInformationSchema
    {
        #region Private Members

        private int patientId;
        private string sourceSystemEpisodeId;
        private DateTime admissionDate;
        private string admissionReason;
        private DateTime? dischargeDate;
        private int responsibleProviderId;
        private HealthProviderIndividual responsibleProvider;
        private int episodeTypeId;
        private string episodeTypeDescription;
        private int episodeLifecycleId;
        private string episodeLifecycleDescription;
        private string ward;
        private string room;
        private string bed;
        private bool consentWithdrawn;

        #endregion Private Members

        /// <summary>
        /// Gets or sets the episode id.
        /// </summary>
        /// <value>
        /// The episode id.
        /// </value>
        [DataMember]
        [DataBaseInfoAttributes(BaseEnumerators.DatabaseColumnType.AutoGeneratedKey)]
        public int? EpisodeId
        {
            get
            {
                return base.Id;
            }
            set
            {
                base.Id = value;
            }
        }

        /// <summary>
        /// Gets or sets the patient id.
        /// </summary>
        /// <value>
        /// The patient id.
        /// </value>
        [DataMember]
        [DataBaseInfoAttributes(HIPS.Base.Schemas.Enumerators.DatabaseColumnType.Data)]
        public int PatientId
        {
            get
            {
                return patientId;
            }
            set
            {
                patientId = value;
            }
        }

        /// <summary>
        /// Gets or sets the source system episode id.
        /// </summary>
        /// <value>
        /// The source system episode id.
        /// </value>
        [DataMember]
        [DataBaseInfoAttributes(HIPS.Base.Schemas.Enumerators.DatabaseColumnType.Data)]
        public string SourceSystemEpisodeId
        {
            get
            {
                return sourceSystemEpisodeId;
            }
            set
            {
                sourceSystemEpisodeId = value;
            }
        }

        /// <summary>
        /// Gets or sets the admission date.
        /// </summary>
        /// <value>
        /// The admission date.
        /// </value>
        [DataMember]
        [DataBaseInfoAttributes(BaseEnumerators.DatabaseColumnType.Data)]
        public DateTime AdmissionDate
        {
            get
            {
                return admissionDate;
            }
            set
            {
                admissionDate = value;
            }
        }

        /// <summary>
        /// Gets or sets the admission reason.
        /// </summary>
        /// <value>
        /// The admission reason.
        /// </value>
        [DataMember]
        [DataBaseInfoAttributes(BaseEnumerators.DatabaseColumnType.Data)]
        public string AdmissionReason
        {
            get
            {
                return admissionReason;
            }
            set
            {
                admissionReason = value;

#if PUMA_CLIENT
                RaisePropertyChanged(() => AdmissionReason);
#endif
            }
        }

        /// <summary>
        /// Gets or sets the discharge date.
        /// </summary>
        /// <value>
        /// The discharge date.
        /// </value>
        [DataMember]
        [DataBaseInfoAttributes(BaseEnumerators.DatabaseColumnType.Data)]
        public DateTime? DischargeDate
        {
            get
            {
                return dischargeDate;
            }
            set
            {
                dischargeDate = value;
#if PUMA_CLIENT
                RaisePropertyChanged(() => DischargeDate);
#endif
            }
        }

        /// <summary>
        /// Gets or sets the responsible provider id.
        /// </summary>
        /// <value>
        /// The responsible provider id.
        /// </value>
        [DataMember]
        [DataBaseInfoAttributes(BaseEnumerators.DatabaseColumnType.Data)]
        public int ResponsibleProviderId
        {
            get
            {
                return responsibleProviderId;
            }
            set
            {
                responsibleProviderId = value;

#if PUMA_CLIENT
                RaisePropertyChanged(() => ResponsibleProviderId);
#endif
            }
        }

        /// <summary>
        /// Gets or sets the responsible provider.
        /// </summary>
        /// <value>
        /// The responsible provider.
        /// </value>
        [DataMember]
        public HealthProviderIndividual ResponsibleProvider
        {
            get
            {
                return responsibleProvider;
            }
            set
            {
                responsibleProvider = value;
            }
        }

        /// <summary>
        /// Gets or sets the episode type id.
        /// </summary>
        /// <value>
        /// The episode type id.
        /// </value>
        [DataMember]
        [DataBaseInfoAttributes(BaseEnumerators.DatabaseColumnType.Data)]
        public int EpisodeTypeId
        {
            get
            {
                return episodeTypeId;
            }
            set
            {
                episodeTypeId = value;

#if PUMA_CLIENT
                RaisePropertyChanged(() => EpisodeTypeId);
#endif
            }
        }

        /// <summary>
        /// Gets or sets the episode type description.
        /// </summary>
        /// <value>
        /// The episode type description.
        /// </value>
        [DataMember]
        [DataBaseInfoAttributes(BaseEnumerators.DatabaseColumnType.ReadOnlyData)]
        public string EpisodeType
        {
            get
            {
                return episodeTypeDescription;
            }
            set
            {
                episodeTypeDescription = value;

#if PUMA_CLIENT
                RaisePropertyChanged(() => EpisodeType);
#endif
            }
        }

        /// <summary>
        /// Gets or sets the episode lifecycle id.
        /// </summary>
        /// <value>
        /// The episode lifecycle id.
        /// </value>
        [DataMember]
        [DataBaseInfoAttributes(BaseEnumerators.DatabaseColumnType.Data)]
        public int EpisodeLifecycleId
        {
            get
            {
                return episodeLifecycleId;
            }
            set
            {
                episodeLifecycleId = value;
#if PUMA_CLIENT
                RaisePropertyChanged(() => EpisodeLifecycleId);
#endif
            }
        }

        /// <summary>
        /// Gets or sets the episode lifecycle description.
        /// </summary>
        /// <value>
        /// The episode lifecycle description.
        /// </value>
        [DataMember]
        [DataBaseInfoAttributes(BaseEnumerators.DatabaseColumnType.ReadOnlyData)]
        public string EpisodeLifecycle
        {
            get
            {
                return episodeLifecycleDescription;
            }
            set
            {
                episodeLifecycleDescription = value;
#if PUMA_CLIENT
                RaisePropertyChanged(() => EpisodeLifecycle);
#endif
            }
        }

        /// <summary>
        /// Gets or sets the ward component of the patient location.
        /// </summary>
        /// <value>
        /// The ward component of the patient location.
        /// </value>
        [DataMember]
        [DataBaseInfoAttributes(BaseEnumerators.DatabaseColumnType.Data)]
        public string Ward
        {
            get
            {
                return ward;
            }
            set
            {
                ward = value;
#if PUMA_CLIENT
                RaisePropertyChanged(() => Ward);
#endif
            }
        }

        /// <summary>
        /// Gets or sets the room component of the patient location.
        /// </summary>
        /// <value>
        /// The room component of the patient location.
        /// </value>
        [DataMember]
        [DataBaseInfoAttributes(BaseEnumerators.DatabaseColumnType.Data)]
        public string Room
        {
            get
            {
                return room;
            }
            set
            {
                room = value;
#if PUMA_CLIENT
                RaisePropertyChanged(() => Room);
#endif
            }
        }

        /// <summary>
        /// Gets or sets the bed component of the patient location.
        /// </summary>
        /// <value>
        /// The bed component of the patient location.
        /// </value>
        [DataMember]
        [DataBaseInfoAttributes(BaseEnumerators.DatabaseColumnType.Data)]
        public string Bed
        {
            get
            {
                return bed;
            }
            set
            {
                bed = value;
#if PUMA_CLIENT
                RaisePropertyChanged(() => Bed);
#endif
            }
        }

        /// <summary>
        /// Gets or sets whether the patient has withdrawn consent to upload documents relating to this episode.
        /// </summary>
        /// <value>
        /// If true, consent has been withdrawn. If false, consent has not been withdrawn.
        /// </value>
        [DataMember]
        [DataBaseInfoAttributes(BaseEnumerators.DatabaseColumnType.Data)]
        public bool ConsentWithdrawn
        {
            get
            {
                return consentWithdrawn;
            }
            set
            {
                consentWithdrawn = value;
#if PUMA_CLIENT
                RaisePropertyChanged(() => ConsentWithdrawn);
#endif
            }
        }
    }
}