﻿using System;
using System.Collections.Generic;
using HIPS.Base.Schemas;
using HIPS.Base.Schemas.Enumerators;

namespace HIPS.PcehrDataStore.Schemas
{
    /// <summary>
    /// Represents the data returned from the database for an episode for a patient in hospital.
    /// </summary>
    public class PatientInHospitalEpisode
    {
        /// <summary>
        /// Initializes a new instance of the <see cref="PatientInHospitalEpisode"/> class.
        /// </summary>
        public PatientInHospitalEpisode()
        {
            this.LocalClinicalDocumentMetaData = new List<LocalClinicalDocumentMetaData>();
        }

        /// <summary>
        /// The admission date of the patient.
        /// </summary>
        [DataBaseInfoAttributes(DatabaseColumnType.ReadOnlyData)]
        public DateTime AdmissionDate { get; set; }

        /// <summary>
        /// The admission reason of the patient.
        /// </summary>
        [DataBaseInfoAttributes(DatabaseColumnType.ReadOnlyData)]
        public string AdmissionReason { get; set; }

        /// <summary>
        /// Whether the patient has withdrawn consent for the most recent matching episode.
        /// </summary>
        [DataBaseInfoAttributes(DatabaseColumnType.ReadOnlyData)]
        public bool? ConsentWithdrawn { get; set; }

        /// <summary>
        /// The discharge date of the patient.
        /// </summary>
        [DataBaseInfoAttributes(DatabaseColumnType.ReadOnlyData)]
        public DateTime? DischargeDate { get; set; }

        /// <summary>
        /// The episode identifier.
        /// </summary>
        public int EpisodeId { get; set; }

        /// <summary>
        /// Gets or sets the local clinical document meta data.
        /// </summary>
        /// <value>
        /// The local clinical document meta data.
        /// </value>
        [DataBaseInfoAttributes(DatabaseColumnType.ReadOnlyData)]
        public List<LocalClinicalDocumentMetaData> LocalClinicalDocumentMetaData { get; set; }

        /// <summary>
        /// The patient's MRN at the hospital where the patient was admitted.
        /// </summary>
        [DataBaseInfoAttributes(DatabaseColumnType.ReadOnlyData)]
        public string Mrn { get; set; }

        /// <summary>
        /// The family name of the patient's responsible provider.
        /// </summary>
        [DataBaseInfoAttributes(DatabaseColumnType.ReadOnlyData)]
        public string ResponsibleProviderFamilyName { get; set; }

        /// <summary>
        /// The given names of the patient's responsible provider.
        /// </summary>
        [DataBaseInfoAttributes(DatabaseColumnType.ReadOnlyData)]
        public string ResponsibleProviderGivenNames { get; set; }

        /// <summary>
        /// The suffix of the patient's responsible provider (such as 'Jr' or 'Sr')
        /// </summary>
        [DataBaseInfoAttributes(DatabaseColumnType.ReadOnlyData)]
        public string ResponsibleProviderSuffix { get; set; }

        /// <summary>
        /// The title of the patient's responsible provider (such as 'Dr', 'Ms' or 'Mr').
        /// </summary>
        [DataBaseInfoAttributes(DatabaseColumnType.ReadOnlyData)]
        public string ResponsibleProviderTitle { get; set; }

        /// <summary>
        /// The source system episode id (visit number) for the patient
        /// </summary>
        [DataBaseInfoAttributes(DatabaseColumnType.ReadOnlyData)]
        public string SourceSystemEpisodeId { get; set; }
    }
}