﻿using HIPS.Base.Schemas;
using BaseEnumerators = HIPS.Base.Schemas.Enumerators;

namespace HIPS.PcehrDataStore.Schemas
{
    /// <summary>
    /// This class represents a pending IHI and PCEHR lookup for a patient at a partcular health provider organisation.
    /// </summary>
    public class PendingIhiPcehrLookup : BaseSchema
    {
        /// <summary>
        /// Gets or sets the health provider organisation ID.
        /// </summary>
        [DataBaseInfoAttributes(BaseEnumerators.DatabaseColumnType.ApplicationGeneratedKey)]
        public int? HealthProviderOrganisationId { get; set; }

        /// <summary>
        /// Gets or sets the patient master ID.
        /// </summary>
        [DataBaseInfoAttributes(BaseEnumerators.DatabaseColumnType.ApplicationGeneratedKey)]
        public int? PatientMasterId { get; set; }
    }
}