﻿using System;
using System.Runtime.Serialization;

namespace HIPS.PcehrSchemas
{
    /// <summary>
    /// This object is used to pass the request to download the document from the PCEHR repository
    /// </summary>
    [KnownType(typeof(DocumentRequest))]
    [Serializable]
    [DataContract]
    public class DocumentRequest
    {
        #region Private Members

        private string documentUniqueId;
        private string repositoryUniqueId;
        private bool saveDocument;

        #endregion Private Members

        #region Properties

        /// <summary>
        /// Gets or sets the DocumentUniqueID
        /// </summary>
        /// <value>
        /// The documentUniqueID
        /// </value>
        [DataMember]
        public string DocumentUniqueId
        {
            get { return documentUniqueId; }
            set { documentUniqueId = value; }
        }

        /// <summary>
        /// Gets or sets the RepositoryUniqueId
        /// </summary>
        /// <value>
        /// The repositoryUniqueId
        /// </value>
        [DataMember]
        public string RepositoryUniqueId
        {
            get { return repositoryUniqueId; }
            set { repositoryUniqueId = value; }
        }

        /// <summary>
        /// Gets or sets whether to save the document in the PCEHR Data Store.
        /// </summary>
        /// <value>
        /// Whether to save the document in the PCEHR Data Store.
        /// </value>
        [DataMember]
        public bool SaveDocument
        {
            get { return saveDocument; }
            set { saveDocument = value; }
        }

        #endregion Properties
    }
}