﻿using System;
using System.Runtime.Serialization;
using HIPS.CommonSchemas;
using HIPS.CommonSchemas.PatientIdentifier;
using HIPS.PcehrDataStore.Schemas;
using Nehta.VendorLibrary.PCEHR.RemoveDocument;

namespace HIPS.PcehrSchemas
{
    /// <summary>
    /// This class represents a queued operation to remove a document from a PCEHR.
    /// </summary>
    [KnownType(typeof(QueuedRemoveOperation))]
    [Serializable]
    [DataContract]
    public class QueuedRemoveOperation
    {
        #region Private members

        private byte[] auditInformation;
        private DocumentType documentType;
        private Episode episode;
        private Hospital hospital;
        private HospitalPatient hospitalPatient;
        private PatientIdentifierBase patientIdentifier;
        private PatientMaster patientMaster;
        private PcehrMessageQueue pendingItem;
        private removeDocumentReasonForRemoval removalReason;
        private string sourceSystemSetId;
        private UserDetails user;

        #endregion Private members

        #region properties

        /// <summary>
        /// The user-supplied additional auditing information for the removal action.
        /// </summary>
        [DataMember]
        public byte[] AuditInformation
        {
            get
            {
                return this.auditInformation;
            }
            set
            {
                this.auditInformation = value;
            }
        }

        /// <summary>
        /// The document type.
        /// </summary>
        [DataMember]
        public DocumentType DocumentType
        {
            get
            {
                return this.documentType;
            }
            set
            {
                this.documentType = value;
            }
        }

        /// <summary>
        /// The episode.
        /// </summary>
        [DataMember]
        public Episode Episode
        {
            get
            {
                return this.episode;
            }
            set
            {
                this.episode = value;
            }
        }

        /// <summary>
        /// The hospital.
        /// </summary>
        [DataMember]
        public Hospital Hospital
        {
            get
            {
                return this.hospital;
            }
            set
            {
                this.hospital = value;
            }
        }

        /// <summary>
        /// The hospital patient.
        /// </summary>
        [DataMember]
        public HospitalPatient HospitalPatient
        {
            get
            {
                return this.hospitalPatient;
            }
            set
            {
                this.hospitalPatient = value;
            }
        }

        /// <summary>
        /// The patient identifier.
        /// </summary>
        [DataMember]
        public PatientIdentifierBase PatientIdentifier
        {
            get
            {
                return this.patientIdentifier;
            }
            set
            {
                this.patientIdentifier = value;
            }
        }

        /// <summary>
        /// The patient master.
        /// </summary>
        [DataMember]
        public PatientMaster PatientMaster
        {
            get
            {
                return this.patientMaster;
            }
            set
            {
                this.patientMaster = value;
            }
        }

        /// <summary>
        /// The pending PCEHR Message Queue item.
        /// </summary>
        [DataMember]
        public PcehrMessageQueue PendingItem
        {
            get
            {
                return this.pendingItem;
            }
            set
            {
                this.pendingItem = value;
            }
        }

        /// <summary>
        /// The reason for removal of the document (such as Withdrawn or IncorrectIdentity).
        /// </summary>
        [DataMember]
        public removeDocumentReasonForRemoval RemovalReason
        {
            get
            {
                return this.removalReason;
            }
            set
            {
                this.removalReason = value;
            }
        }

        /// <summary>
        /// The set ID of the document to be removed.
        /// </summary>
        [DataMember]
        public string SourceSystemSetId
        {
            get
            {
                return this.sourceSystemSetId;
            }
            set
            {
                this.sourceSystemSetId = value;
            }
        }

        /// <summary>
        /// The user.
        /// </summary>
        [DataMember]
        public UserDetails User
        {
            get
            {
                return this.user;
            }
            set
            {
                this.user = value;
            }
        }

        #endregion properties

        #region constructor

        /// <summary>
        /// Initializes a new instance of the <see cref="QueuedUploadOperation" /> class.
        /// </summary>
        /// <param name="user">The user.</param>
        public QueuedRemoveOperation(UserDetails user)
        {
            this.user = user;
        }

        #endregion constructor
    }
}