﻿using System.Runtime.Serialization;

using EntLibVal = Microsoft.Practices.EnterpriseLibrary.Validation;

namespace HIPS.ServiceContracts.Common.DTO.PatientIdentifier
{
    /// <summary>
    /// Enterprise ID assigned by the state or territory jurisdiction.
    /// </summary>
    [KnownType(typeof(PatientIdentifierBase))]
    [DataContract(Namespace = HIPS.ServiceContracts.Common.Constants.ServiceNamespace.COMMON_V1)]
    public class StatePatientId : PatientIdentifierBase
    {
        #region Properties

        /// <summary>
        /// Gets or sets the value of the enterprise ID.
        /// </summary>
        [DataMember(IsRequired = true)]
        [EntLibVal.Validators.StringLengthValidator(1, 20)]
        public string Value { get; set; }

        #endregion Properties
    }
}