﻿using System.Runtime.Serialization;

using EntLibVal = Microsoft.Practices.EnterpriseLibrary.Validation;

namespace HIPS.ServiceContracts.Common.DTO.UserIdentity
{
    /// <summary>
    /// Represents an end-user who has been assigned an HPI-I within the national Healthcare Identifier service.
    /// </summary>
    [DataContract(Namespace = HIPS.ServiceContracts.Common.Constants.ServiceNamespace.COMMON_V1)]
    public class ProviderUser : UserBase
    {
        #region Properties

        /// <summary>
        /// Gets or sets the family name of the user.
        /// </summary>
        [DataMember(IsRequired = true)]
        [EntLibVal.Validators.StringLengthValidator(1, 80)]
        public virtual string FamilyName { get; set; }

        /// <summary>
        /// Gets or sets the given name(s) of the user.
        /// </summary>
        [DataMember(IsRequired = false)]
        [EntLibVal.Validators.StringLengthValidator(1, 80)]
        public virtual string GivenNames { get; set; }

        /// <summary>
        /// Gets or sets the health provider identifier - individual identifying the provider user.
        /// </summary>
        [DataMember(IsRequired = true)]
        [EntLibVal.Validators.StringLengthValidator(16, 16)]
        public virtual string HpiI { get; set; }

        #endregion Properties
    }
}