﻿using System.Collections.Generic;
using System.Runtime.Serialization;
using HIPS.ServiceContracts.Common;
using HIPS.ServiceContracts.Common.DTO;
using EntLibVal = Microsoft.Practices.EnterpriseLibrary.Validation;

namespace HIPS.ServiceContracts.Hpii.DTO
{
    /// <summary>
    /// HPI-I Batch Retrieve Result DTO. This object represents a list of search results from a batch.
    /// </summary>
    [DataContract(Namespace = HIPS.ServiceContracts.Common.Constants.ServiceNamespace.HPII_V2)]
    public class BatchRetrieveResult
    {
        #region Properties

        /// <summary>
        /// Gets or sets the batch identifier.
        /// </summary>
        [DataMember(IsRequired = false)]
        [EntLibVal.Validators.StringLengthValidator(1, 36)]
        public string BatchIdentifier { get; set; }

        /// <summary>
        /// Gets or sets the list of batch search results.
        /// </summary>
        [DataMember(IsRequired = true)]
        [EntLibVal.Validators.ObjectCollectionValidator]
        public List<BatchSearchResult> Results { get; set; }

        #endregion Properties
    }
}