﻿using System.ServiceModel;

using HIPS.ServiceContracts.Common.Fault;
using HIPS.ServiceContracts.Patient.Message;

namespace HIPS.ServiceContracts.Patient
{
    /// <summary>
    /// This interface defines the contract for web service operations upon patients in the HIPS database.
    /// </summary>
    [ServiceContract(Namespace = HIPS.ServiceContracts.Common.Constants.ServiceNamespace.PATIENT_V2)]
    public interface IPatientServiceV2
    {
        /// <summary>
        /// Lists the episodes for a specific patient in a defined hospital
        /// </summary>
        /// <param name="request">Request containing a patient identifier for retrieving patient episodes.</param>
        /// <returns>Response containing the a list of the admitted or discharged episodes for the patient with in the specified number of days</returns>
        [OperationContract]
        [FaultContract(typeof(InvalidRequestFault))]
        [FaultContract(typeof(ServiceOperationFault))]
        ListPatientEpisodesInHospitalResponse ListPatientEpisodesInHospital(ListPatientEpisodesInHospitalRequest request);
    }
}