﻿using System.ServiceModel;
using HIPS.CommonSchemas;

namespace HIPS.ServiceContracts.ServiceInterfaces
{
    /// <summary>
    /// Web service interface for the Database Loader service.
    /// </summary>
    [WCFExtras.Wsdl.Documentation.XmlComments]
    [ServiceContract(Namespace = "http://schemas.HIPS/Services/2012/01", Name = "DatabaseLoaderService")]
    public interface IDatabaseLoaderService
    {
        /// <summary>
        /// Notifies HIPS of an event in the Patient Administration System.
        /// </summary>
        /// <param name="messageForm">An HL7 message.</param>
        /// <param name="user">Details of the responsible user.</param>
        /// <returns>An HL7 acknowledgement message.</returns>
        [OperationContract]
        string NotifyPasEvent(string messageForm, UserDetails user);

        /// <summary>
        /// Notifies HIPS of a pathology result.
        /// </summary>
        /// <param name="messageForm">An HL7 message.</param>
        /// <param name="user">Details of the responsible user.</param>
        /// <returns>An HL7 acknowledgement message.</returns>
        [OperationContract]
        string NotifyPathEvent(string messageForm, UserDetails user);
    }
}