﻿using HIPS.CommonSchemas;
using HIPS.HpiiSchemas;
using Microsoft.VisualStudio.TestTools.UnitTesting;
using nehta.mcaR50.ProviderSearchForProviderIndividual;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using Test.Helpers;
using Test.CommonCcaNoc.Helpers;

namespace Test.HiCcaNoc.CCA.UC_131
{
    /// <summary>
    /// The software shall create an error log for all error messages received
    /// from the HI Service including those that are resolved automatically.  
    /// The log shall include the error date/time, in hours and minutes unless,
    /// the system is capable of more precision the error number, the error 
    /// message and message ID reported by the HI Service.
    /// </summary>
    [TestClass]
    public class HI_CCA_131_005873 : CcaTest
    {
        /// <summary>
        /// Perform each operation below and verify log entries in the local software for:
        /// a. Verify that the software creates log entries for all error messages received from the HI Service including those that are resolved automatically.
        /// b. Verify that log entries include the error date/time, in hours and minutes unless the system is capable of more precision.
        /// c. Verify that log entries include the error number correctly as reported by the HI Service.
        /// d. Verify that log entries include the error message correctly as reported by the HI Service.
        /// e. Verify that log entries include the message identifier correctly as reported by the HI Service.
        /// 
        /// Operations:
        /// Perform an operation to retrieve/validate the details of a Healthcare Provider which includes errors being returned from the HI Service
        /// 
        /// Assess for applicable errors stipulated in:
        /// TECH.SIS.HI15, TECH.SIS.HI31, TECH.SIS.HI33
        /// 
        /// Suggestions - do one or more of the following:
        /// Attempt to retrieve/verify a provider that is not listed in the HI Test data
        /// </summary>
        [TestMethod]
        [TestCategory("HI_CCA_131")]
        public void HI_CCA_131_005873_1()
        {
            UserDetails user = new ProviderTestHelpersBase().GetTestUser();
            provider = CcaProviders.GetProvider("NOC ID 4");
            
            HpiiIdentifierQuery query = new HpiiIdentifierQuery();
            query.HpioNumber = provider.TestProviderHpioNumber;
            query.HpiiNumber = provider.TestProviderHpiiNumber;
            query.FamilyName = provider.TestProviderFamilyName;
            query.Sex = (SexType?)provider.TestProviderSex;

            HpiiQueryResponse hpiiResponse = ProxyHelper.HpiiProxy.HpiiValidation(query, user);
            LogAssert.ExpectResponse(HipsResponseIndicator.OK, hpiiResponse.HipsResponse, DialogueResource.HipsServiceHpiiValidation);

            var audit = provider.GetLastHpiiLookupAudit();
            LogAssert.IsNotBlank(audit.Message, "Message");
            LogAssert.IsNotNull(audit.DateCreated, "DateCreated");
        }
    }
}
