﻿using System;
using Microsoft.VisualStudio.TestTools.UnitTesting;
using Test.CommonCcaNoc.Helpers;
using HIPS.CommonSchemas;
using HIPS.HpiiSchemas;
using nehta.mcaR50.ProviderSearchForProviderIndividual;
using Test.Helpers;

namespace Test.MedicareCCA.CCA.UC_131
{
    [TestClass]
    public class HI_CCA_131_010041 : CcaTest
    {
        [TestMethod]
        [TestCategory("HI_CCA_131")]
        public void HI_CCA_131_010041_1()
        {
            UserDetails user = new ProviderTestHelpersBase().GetTestUser();

            provider = CcaProviders.GetProvider("NOC ID 1");

            HpiiIdentifierQuery query = new HpiiIdentifierQuery();
            query.HpioNumber = provider.TestProviderHpioNumber;
            query.HpiiNumber = provider.TestProviderHpiiNumber;
            query.FamilyName = provider.TestProviderFamilyName;
            query.Sex = (SexType?)provider.TestProviderSex;

            HpiiQueryResponse hpiiResponse = ProxyHelper.HpiiProxy.HpiiValidation(query, user);

            LogAssert.ExpectResponse(HipsResponseIndicator.OK, hpiiResponse.HipsResponse, DialogueResource.HipsServiceHpiiValidation);
            LogAssert.AreEqual(provider.TestProviderHpiiNumber, hpiiResponse.HpiiNumber, DialogueResource.HpiiNumber);
        }
    }
}
