﻿using HIPS.CommonSchemas;
using HIPS.P2P.Service.Contract.Common;
using HIPS.P2P.Service.Contract.Common.DTO;
using HIPS.P2P.Service.Contract.Common.DTO.UserIdentity;
using HIPS.P2P.Service.Contract.Directory.ProviderOrganisation.Message;
using Microsoft.VisualStudio.TestTools.UnitTesting;
using Test.CommonCcaNoc.Helpers;
using Test.Helpers;

namespace Test.HiCcaNoc.CCA.UC_330
{
    /// <summary>
    /// The software shall be capable of validating HPI-Os via the web services described in the HI Service system interface specification, TECH.SIS.HI. 16 or 18.
    /// </summary>
    [TestClass]
    public class HI_CCA_330_010042 : CcaTest
    {
        /// <summary>
        /// When searching for an organisation healthcare provider directory
        /// entry the software is capable of validating the HPI-Os.
        /// 
        /// a. Verify that the software is capable of validating HPI-Os via the
        /// Search for Organisation Provider Directory Entry web service described
        /// in the HI Service system interface specification TECH.SIS.HI.18. 
        /// </summary>
        [TestMethod]
        [TestCategory("HI_CCA_330")]
        public void HI_CCA_330_010042_1()
        {
            UserDetails user = new ProviderTestHelpersBase().GetTestUser();
            // TODO: Make the GetProvider store the organisation and individual into the P2P database?
            provider = CcaProviders.GetProvider("NOC ID 1");

            GetValidatedHpioRequest query = new GetValidatedHpioRequest
            {
                Identifier = new ProviderOrganisationIdentifier
                {
                    Value = provider.TestProviderHpioNumber,
                    Type = new ProviderIdentifierType
                    {
                        Code = "HPIO"
                    }
                },
                User = new LocalUser
                {
                    Login = "Test.User",
                    Domain = "Test.Domain",
                    AccessingHpio = provider.TestProviderHpioNumber,
                    FamilyName = provider.TestProviderFamilyName,
                    GivenNames = provider.TestProviderFirstGivenName,
                }
            };

            GetValidatedHpioResponse hpioResponse = ProxyHelper.ProviderOrganisationDirectoryProxy.GetValidatedHpio(query);

            LogAssert.AreEqual(ResponseStatus.OK, hpioResponse.Status, DialogueResource.HipsServiceGetValidatedHpio);

//            var audit = provider.GetLastHpioLookupAudit();
//            LogAssert.IsTrue(string.IsNullOrEmpty(audit.Message), "Message is empty.", "Message is not empty.");
        }    
    }
}
