﻿using HIPS.CommonSchemas;
using HIPS.PcehrDataStore.Schemas;
using HIPS.PcehrSchemas;
using Microsoft.VisualStudio.TestTools.UnitTesting;
using Test.CommonCcaNoc.Helpers;

namespace Test.PcehrCcaNoc.ClinicalInformationSystem.UC_CIS_002_1
{
    /// <summary>
    /// Conformance Test Specification: Clinical Information Systems Connecting to the PCEHR System
    ///                                 Version 1.6 — 27 September 2012
    /// Use Case #:	    UC.CIS.002.1
    /// Use Case Name:	Gain access to PCEHR (with Access Code)
    /// Test Case ID:   PCEHR_CIS_019378
    /// Objective:
    /// To check there is a capability to create audit logs for interactions with the PCEHR System.
    /// </summary>
    [TestClass]
    public class PCEHR_CIS_019378 : CcaTest
    {
        /// <summary>
        /// Perform an operation to invoke gainPCEHRAccess service on the PCEHR system
        /// a. Demonstrate that an audit capability exists.
        /// </summary>
        [TestMethod]
        [TestCategory("CIS_CCA_002_1")]
        public void CIS_0021_019378_A()
        {
            patient = CcaPatient.GetPatient(ihiValid: true, validatedWithinPeriod: true, hasUnresolvedAlerts: false);
            GainPcehrAccessResponse response = ProxyHelper.PcehrProxy.GainAccessWithCode(patient.TargetPatientIdentifier, patient.TestPatientLimitedDocumentAccessCode, patient.GetTestUser());
            LogAssert.ExpectResponse(HipsResponseIndicator.OK, response.HipsResponse, DialogueResource.HipsServiceGainAccessWithCode);

            // Check that the PCEHR service invocation was audited
            PcehrAudit audit = patient.GetLastPcehrAudit();
            LogAssert.AreEqual(patient.TargetPatientMasterId, audit.PatientMasterId, DialogueResource.PcehrAuditPatientMasterId);
            LogAssert.AreEqual(AuditOperationNames.GainAccessWithCode, audit.ServiceName, DialogueResource.PcehrAuditServiceName);

            // PCEHR_CIS_017836 states the Conformance Requirement:
            // After gaining access to a PCEHR by using a PACC or a PACCX, the
            // Clinical Information System shall not cache or store the healthcare
            // recipient’s access consent code (PACC or PACCX) except for auditing
            // purposes. If the codes are stored for auditing purposes, it shall
            // be encrypted or masked.

            // There is no CCA test case for requirement 017836 but we will make
            // sure that the code is masked in the audit table here.
            LogAssert.IsFalse(audit.Request.Contains(patient.TestPatientLimitedDocumentAccessCode),
                DialogueResource.AuditRecordDoesNotContainTheLDAC,
                DialogueResource.AuditRecordContainsTheLDAC);
        }
    }
}