﻿using System;
using HIPS.CommonSchemas;
using HIPS.PcehrDataStore.Schemas;
using HIPS.PcehrSchemas;
using Microsoft.VisualStudio.TestTools.UnitTesting;
using Test.CommonCcaNoc.Helpers;

namespace Test.PcehrCcaNoc.ClinicalInformationSystem.UC_CIS_301
{
    /// <summary>
    /// Conformance Test Specification: Clinical Information Systems Connecting to the PCEHR System
    ///                                 Version 1.6 — 27 September 2012
    /// Use Case #:	    UC.CIS.301
    /// Use Case Name:	Access a View Service
    /// Test Case ID:   PCEHR_CIS_019378
    /// Objective:
    /// To check there is a capability to create audit logs for interactions with the PCEHR System.
    /// </summary>
    [TestClass]
    public class PCEHR_CIS_019378 : CcaTest
    {
        /// <summary>
        /// Perform an operation to invoke one of the services to access a View
        /// on the PCEHR System (e.g. getConsolidatedView.  Refer to PCEHR View
        /// Service: Technical Service Specification [NEHTA2012c] for the full
        /// list of B2B View services).
        /// a. Demonstrate that an audit capability exists.
        /// </summary>
        [TestMethod]
        [TestCategory("CIS_CCA_301")]
        public void CIS_301_019378_A()
        {
            // We need to download the document from the appropriate IHI
            patient = CcaPatient.GetPatient(ihiValid: true, validatedWithinPeriod: true, hasUnresolvedAlerts: false, testDataId: "CCA ID IHI_50");

            GainPcehrAccessResponse accessResponse = ProxyHelper.PcehrProxy.GainAccessEmergency(patient.TargetPatientIdentifier, patient.GetTestUser());
            LogAssert.ExpectResponse(HipsResponseIndicator.OK, accessResponse.HipsResponse, DialogueResource.HipsServiceGainAccessEmergency);

            PrescriptionAndDispenseViewRequest padvRequest = new PrescriptionAndDispenseViewRequest { FromDate = DateTime.Now.AddMonths(-6), ToDate = DateTime.Now };
            ViewResponse viewResponse = ProxyHelper.PcehrProxy.GetView(patient.TargetPatientIdentifier, patient.GetTestUser(), padvRequest);
            LogAssert.ExpectResponse(HipsResponseIndicator.OK, viewResponse.HipsResponse, DialogueResource.HipsServiceGetView);

            // Check that the PCEHR retrieve document service invocation was audited
            PcehrAudit audit = patient.GetLastPcehrAudit();
            LogAssert.AreEqual(patient.TargetPatientMasterId, audit.PatientMasterId, DialogueResource.PcehrAuditPatientMasterId);
            LogAssert.AreEqual(AuditOperationNames.GetView, audit.ServiceName, DialogueResource.PcehrAuditServiceName);
        }
    }
}