SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[hips].[AccessCodeRequired]') AND type in (N'U'))
BEGIN
CREATE TABLE [hips].[AccessCodeRequired](
	[AccessCodeRequiredId] [int] IDENTITY(1,1) NOT NULL,
	[Description] [varchar](20) NOT NULL,
	[DateCreated] [datetime] NOT NULL,
	[UserCreated] [varchar](256) NOT NULL,
	[DateModified] [datetime] NOT NULL,
	[UserModified] [varchar](256) NOT NULL,
 CONSTRAINT [PK_AccessCodeRequired] PRIMARY KEY CLUSTERED 
(
	[AccessCodeRequiredId] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
END
GO
SET ANSI_PADDING OFF
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'AccessCodeRequired', N'COLUMN',N'AccessCodeRequiredId'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Identifies whether a code is required to gain access to a PCEHR' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'AccessCodeRequired', @level2type=N'COLUMN',@level2name=N'AccessCodeRequiredId'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'AccessCodeRequired', N'COLUMN',N'Description'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Description (e.g. "Gained Access", "Without Code", "With Code")' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'AccessCodeRequired', @level2type=N'COLUMN',@level2name=N'Description'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'AccessCodeRequired', N'COLUMN',N'DateCreated'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Date that this record was inserted into the table' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'AccessCodeRequired', @level2type=N'COLUMN',@level2name=N'DateCreated'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'AccessCodeRequired', N'COLUMN',N'UserCreated'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'User account that inserted the record' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'AccessCodeRequired', @level2type=N'COLUMN',@level2name=N'UserCreated'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'AccessCodeRequired', N'COLUMN',N'DateModified'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Date and time that this record was last modified (or as inserted)' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'AccessCodeRequired', @level2type=N'COLUMN',@level2name=N'DateModified'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'AccessCodeRequired', N'COLUMN',N'UserModified'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The account of the user that last modified (or inserted) this record' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'AccessCodeRequired', @level2type=N'COLUMN',@level2name=N'UserModified'
GO

SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[hips].[Address]') AND type in (N'U'))
BEGIN
CREATE TABLE [hips].[Address](
	[AddressId] [int] IDENTITY(1,1) NOT NULL,
	[AddressLine1] [varchar](100) NOT NULL,
	[AddressLine2] [varchar](100) NULL,
	[PlaceName] [varchar](100) NULL,
	[AustralianStateId] [int] NOT NULL,
	[InternationalStateCode] [varchar](10) NULL,
	[Postcode] [varchar](10) NULL,
	[CountryId] [int] NOT NULL,
	[AddressTypeId] [int] NOT NULL,
	[DateCreated] [datetime] NOT NULL,
	[UserCreated] [varchar](256) NOT NULL,
	[DateModified] [datetime] NOT NULL,
	[UserModified] [varchar](256) NOT NULL,
 CONSTRAINT [PK_Address] PRIMARY KEY CLUSTERED 
(
	[AddressId] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
END
GO
SET ANSI_PADDING OFF
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'Address', N'COLUMN',N'AddressLine1'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'First line of unstructured address' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'Address', @level2type=N'COLUMN',@level2name=N'AddressLine1'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'Address', N'COLUMN',N'AddressLine2'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Second line of unstructured address' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'Address', @level2type=N'COLUMN',@level2name=N'AddressLine2'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'Address', N'COLUMN',N'PlaceName'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Suburb, Town or Locality' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'Address', @level2type=N'COLUMN',@level2name=N'PlaceName'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'Address', N'COLUMN',N'AustralianStateId'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'For Australian address, identifies the state.' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'Address', @level2type=N'COLUMN',@level2name=N'AustralianStateId'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'Address', N'COLUMN',N'InternationalStateCode'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'For international address, identifies the state or province.' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'Address', @level2type=N'COLUMN',@level2name=N'InternationalStateCode'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'Address', N'COLUMN',N'Postcode'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'For Australian address, the postcode. For international, the postal or ZIP code.
' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'Address', @level2type=N'COLUMN',@level2name=N'Postcode'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'Address', N'COLUMN',N'CountryId'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'For both australian and international address, identifies the country.' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'Address', @level2type=N'COLUMN',@level2name=N'CountryId'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'Address', N'COLUMN',N'AddressTypeId'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Identifies the address type.
' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'Address', @level2type=N'COLUMN',@level2name=N'AddressTypeId'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'Address', NULL,NULL))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'A physical address for a single patient or hospital. Records must never be shared between patients.' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'Address'
GO
IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_Address_AddressType]') AND parent_object_id = OBJECT_ID(N'[hips].[Address]'))
ALTER TABLE [hips].[Address]  WITH CHECK ADD  CONSTRAINT [FK_Address_AddressType] FOREIGN KEY([AddressTypeId])
REFERENCES [hips].[AddressType] ([AddressTypeId])
GO
IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_Address_AddressType]') AND parent_object_id = OBJECT_ID(N'[hips].[Address]'))
ALTER TABLE [hips].[Address] CHECK CONSTRAINT [FK_Address_AddressType]
GO
IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_Address_Country]') AND parent_object_id = OBJECT_ID(N'[hips].[Address]'))
ALTER TABLE [hips].[Address]  WITH CHECK ADD  CONSTRAINT [FK_Address_Country] FOREIGN KEY([CountryId])
REFERENCES [hips].[Country] ([CountryId])
GO
IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_Address_Country]') AND parent_object_id = OBJECT_ID(N'[hips].[Address]'))
ALTER TABLE [hips].[Address] CHECK CONSTRAINT [FK_Address_Country]
GO
IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_Address_State]') AND parent_object_id = OBJECT_ID(N'[hips].[Address]'))
ALTER TABLE [hips].[Address]  WITH CHECK ADD  CONSTRAINT [FK_Address_State] FOREIGN KEY([AustralianStateId])
REFERENCES [hips].[State] ([StateId])
GO
IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_Address_State]') AND parent_object_id = OBJECT_ID(N'[hips].[Address]'))
ALTER TABLE [hips].[Address] CHECK CONSTRAINT [FK_Address_State]
GO

SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[hips].[AddressType]') AND type in (N'U'))
BEGIN
CREATE TABLE [hips].[AddressType](
	[AddressTypeId] [int] IDENTITY(1,1) NOT NULL,
	[Code] [varchar](10) NOT NULL,
	[Description] [varchar](40) NOT NULL,
	[DateCreated] [datetime] NOT NULL,
	[UserCreated] [varchar](256) NOT NULL,
	[DateModified] [datetime] NOT NULL,
	[UserModified] [varchar](256) NOT NULL,
 CONSTRAINT [PK_AddressType] PRIMARY KEY CLUSTERED 
(
	[AddressTypeId] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
END
GO
SET ANSI_PADDING OFF
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'AddressType', N'COLUMN',N'Code'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'HL7 v3 Address Use Code (e.g. WP, H, PST, TMP)
' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'AddressType', @level2type=N'COLUMN',@level2name=N'Code'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'AddressType', N'COLUMN',N'Description'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Description (e.g. Business, Home, Mailing, Temporary)' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'AddressType', @level2type=N'COLUMN',@level2name=N'Description'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'AddressType', NULL,NULL))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Identifies a physical address type' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'AddressType'
GO

SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[hips].[CdaDocumentNumber]') AND type in (N'U'))
BEGIN
CREATE TABLE [hips].[CdaDocumentNumber](
	[CdaDocumentNumberId] [int] IDENTITY(1,1) NOT NULL,
	[CdaSetNumberId] [int] NOT NULL,
	[DocumentCreationDateTime] [datetime] NOT NULL,
	[DateCreated] [datetime] NOT NULL,
	[UserCreated] [varchar](256) NOT NULL,
	[DateModified] [datetime] NOT NULL,
	[UserModified] [varchar](256) NOT NULL,
 CONSTRAINT [PK_CdaDocumentNumber] PRIMARY KEY CLUSTERED 
(
	[CdaDocumentNumberId] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
END
GO
SET ANSI_PADDING OFF
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'CdaDocumentNumber', N'COLUMN',N'CdaSetNumberId'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The CDA document set that this document belongs to.' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'CdaDocumentNumber', @level2type=N'COLUMN',@level2name=N'CdaSetNumberId'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'CdaDocumentNumber', N'COLUMN',N'DocumentCreationDateTime'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The date and time when this document was finalised.' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'CdaDocumentNumber', @level2type=N'COLUMN',@level2name=N'DocumentCreationDateTime'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'CdaDocumentNumber', NULL,NULL))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'CDA documents that are created by this instance of HIPS.' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'CdaDocumentNumber'
GO
IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_CdaDocumentNumber_CdaSetNumber]') AND parent_object_id = OBJECT_ID(N'[hips].[CdaDocumentNumber]'))
ALTER TABLE [hips].[CdaDocumentNumber]  WITH CHECK ADD  CONSTRAINT [FK_CdaDocumentNumber_CdaSetNumber] FOREIGN KEY([CdaSetNumberId])
REFERENCES [hips].[CdaSetNumber] ([CdaSetNumberId])
GO
IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_CdaDocumentNumber_CdaSetNumber]') AND parent_object_id = OBJECT_ID(N'[hips].[CdaDocumentNumber]'))
ALTER TABLE [hips].[CdaDocumentNumber] CHECK CONSTRAINT [FK_CdaDocumentNumber_CdaSetNumber]
GO

SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[hips].[CdaSetNumber]') AND type in (N'U'))
BEGIN
CREATE TABLE [hips].[CdaSetNumber](
	[CdaSetNumberId] [int] IDENTITY(1,1) NOT NULL,
	[EpisodeId] [int] NOT NULL,
	[DocumentTypeId] [int] NOT NULL,
	[DocumentFormatId] [int] NOT NULL,
	[ModeOfSeparationId] [int] NOT NULL,
	[AdmissionDateTime] [datetime] NOT NULL,
	[DischargeDateTime] [datetime] NOT NULL,
	[DateCreated] [datetime] NOT NULL,
	[UserCreated] [varchar](256) NOT NULL,
	[DateModified] [datetime] NOT NULL,
	[UserModified] [varchar](256) NOT NULL,
 CONSTRAINT [PK_CdaSetNumber] PRIMARY KEY CLUSTERED 
(
	[CdaSetNumberId] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
END
GO
SET ANSI_PADDING OFF
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'CdaSetNumber', NULL,NULL))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'CDA documents that are created by this instance of HIPS.' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'CdaSetNumber'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'CdaSetNumber', N'COLUMN',N'EpisodeId'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Identifies the episode, encounter or visit.' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'CdaSetNumber', @level2type=N'COLUMN',@level2name=N'EpisodeId'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'CdaSetNumber', N'COLUMN',N'DocumentTypeId'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Identifies the type of clinical document.' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'CdaSetNumber', @level2type=N'COLUMN',@level2name=N'DocumentTypeId'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'CdaSetNumber', N'COLUMN',N'DocumentFormatId'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Identifies which CDA validation template package will be applied by the PCEHR system.' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'CdaSetNumber', @level2type=N'COLUMN',@level2name=N'DocumentFormatId'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'CdaSetNumber', N'COLUMN',N'ModeOfSeparationId'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Identifies the type of discharge and the place to which the patient is discharged.' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'CdaSetNumber', @level2type=N'COLUMN',@level2name=N'ModeOfSeparationId'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'CdaSetNumber', N'COLUMN',N'AdmissionDateTime'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The date and time when the episode started.' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'CdaSetNumber', @level2type=N'COLUMN',@level2name=N'AdmissionDateTime'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'CdaSetNumber', N'COLUMN',N'DischargeDateTime'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The date and time when the episode ended or is planned to end.' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'CdaSetNumber', @level2type=N'COLUMN',@level2name=N'DischargeDateTime'
GO
IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_CdaSetNumber_Episode]') AND parent_object_id = OBJECT_ID(N'[hips].[CdaSetNumber]'))
ALTER TABLE [hips].[CdaSetNumber]  WITH CHECK ADD  CONSTRAINT [FK_CdaSetNumber_Episode] FOREIGN KEY([EpisodeId])
REFERENCES [hips].[Episode] ([EpisodeId])
GO
IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_CdaSetNumber_Episode]') AND parent_object_id = OBJECT_ID(N'[hips].[CdaSetNumber]'))
ALTER TABLE [hips].[CdaSetNumber] CHECK CONSTRAINT [FK_CdaSetNumber_Episode]
GO
IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_CdaSetNumber_DocumentType]') AND parent_object_id = OBJECT_ID(N'[hips].[CdaSetNumber]'))
ALTER TABLE [hips].[CdaSetNumber]  WITH CHECK ADD  CONSTRAINT [FK_CdaSetNumber_DocumentType] FOREIGN KEY([DocumentTypeId])
REFERENCES [hips].[DocumentType] ([DocumentTypeId])
GO
IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_CdaSetNumber_DocumentType]') AND parent_object_id = OBJECT_ID(N'[hips].[CdaSetNumber]'))
ALTER TABLE [hips].[CdaSetNumber] CHECK CONSTRAINT [FK_CdaSetNumber_DocumentType]
GO
IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_CdaSetNumber_DocumentFormat]') AND parent_object_id = OBJECT_ID(N'[hips].[CdaSetNumber]'))
ALTER TABLE [hips].[CdaSetNumber]  WITH CHECK ADD  CONSTRAINT [FK_CdaSetNumber_DocumentFormat] FOREIGN KEY([DocumentFormatId])
REFERENCES [hips].[DocumentFormat] ([DocumentFormatId])
GO
IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_CdaSetNumber_DocumentFormat]') AND parent_object_id = OBJECT_ID(N'[hips].[CdaSetNumber]'))
ALTER TABLE [hips].[CdaSetNumber] CHECK CONSTRAINT [FK_CdaSetNumber_DocumentFormat]
GO
IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_CdaSetNumber_ModeOfSeparation]') AND parent_object_id = OBJECT_ID(N'[hips].[CdaSetNumber]'))
ALTER TABLE [hips].[CdaSetNumber]  WITH CHECK ADD  CONSTRAINT [FK_CdaSetNumber_ModeOfSeparation] FOREIGN KEY([ModeOfSeparationId])
REFERENCES [hips].[ModeOfSeparation] ([ModeOfSeparationId])
GO
IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_CdaSetNumber_ModeOfSeparation]') AND parent_object_id = OBJECT_ID(N'[hips].[CdaSetNumber]'))
ALTER TABLE [hips].[CdaSetNumber] CHECK CONSTRAINT [FK_CdaSetNumber_ModeOfSeparation]
GO

SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[hips].[ClinicalDocument]') AND type in (N'U'))
BEGIN
CREATE TABLE [hips].[ClinicalDocument](
	[ClinicalDocumentId] [int] IDENTITY(1,1) NOT NULL,
	[SourceSystemSetId] [varchar](128) NOT NULL,
	[EpisodeId] [int] NOT NULL,
	[DocumentTypeId] [int] NOT NULL,
	[ClinicalDocumentStatusId] [int] NOT NULL,
	[RemovedDate] [datetime] NULL,
	[RemovalReasonId] [int] NULL,
	[DateCreated] [datetime] NOT NULL,
	[UserCreated] [varchar](256) NOT NULL,
	[DateModified] [datetime] NOT NULL,
	[UserModified] [varchar](256) NOT NULL,
 CONSTRAINT [PK_ClinicalDocument] PRIMARY KEY CLUSTERED 
(
	[ClinicalDocumentId] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
END
GO
SET ANSI_PADDING OFF
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'ClinicalDocument', N'COLUMN',N'SourceSystemSetId'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'A globally-unique identifier for the clinical document, shared by different versions of the same document. Can be a UUID, or an OID, or an OID^extension.' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'ClinicalDocument', @level2type=N'COLUMN',@level2name=N'SourceSystemSetId'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'ClinicalDocument', N'COLUMN',N'EpisodeId'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The episode that this document relates to.' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'ClinicalDocument', @level2type=N'COLUMN',@level2name=N'EpisodeId'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'ClinicalDocument', N'COLUMN',N'DocumentTypeId'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Which type of clinical document this is.' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'ClinicalDocument', @level2type=N'COLUMN',@level2name=N'DocumentTypeId'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'ClinicalDocument', NULL,NULL))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'A locally-created clinical document' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'ClinicalDocument'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'ClinicalDocument', N'COLUMN',N'RemovedDate'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The date and time when this document was removed' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'ClinicalDocument', @level2type=N'COLUMN',@level2name=N'RemovedDate'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'ClinicalDocument', N'COLUMN',N'RemovalReasonId'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The reason that this document was removed' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'ClinicalDocument', @level2type=N'COLUMN',@level2name=N'RemovalReasonId'
GO
IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_ClinicalDocument_DocumentType]') AND parent_object_id = OBJECT_ID(N'[hips].[ClinicalDocument]'))
ALTER TABLE [hips].[ClinicalDocument]  WITH CHECK ADD  CONSTRAINT [FK_ClinicalDocument_DocumentType] FOREIGN KEY([DocumentTypeId])
REFERENCES [hips].[DocumentType] ([DocumentTypeId])
GO
IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_ClinicalDocument_DocumentType]') AND parent_object_id = OBJECT_ID(N'[hips].[ClinicalDocument]'))
ALTER TABLE [hips].[ClinicalDocument] CHECK CONSTRAINT [FK_ClinicalDocument_DocumentType]
GO
IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_ClinicalDocument_Episode]') AND parent_object_id = OBJECT_ID(N'[hips].[ClinicalDocument]'))
ALTER TABLE [hips].[ClinicalDocument]  WITH CHECK ADD  CONSTRAINT [FK_ClinicalDocument_Episode] FOREIGN KEY([EpisodeId])
REFERENCES [hips].[Episode] ([EpisodeId])
GO
IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_ClinicalDocument_Episode]') AND parent_object_id = OBJECT_ID(N'[hips].[ClinicalDocument]'))
ALTER TABLE [hips].[ClinicalDocument] CHECK CONSTRAINT [FK_ClinicalDocument_Episode]
GO
IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_ClinicalDocument_RemovalReason]') AND parent_object_id = OBJECT_ID(N'[hips].[ClinicalDocument]'))
ALTER TABLE [hips].[ClinicalDocument]  WITH CHECK ADD  CONSTRAINT [FK_ClinicalDocument_RemovalReason] FOREIGN KEY([RemovalReasonId])
REFERENCES [hips].[RemovalReason] ([RemovalReasonId])
GO
IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_ClinicalDocument_RemovalReason]') AND parent_object_id = OBJECT_ID(N'[hips].[ClinicalDocument]'))
ALTER TABLE [hips].[ClinicalDocument] CHECK CONSTRAINT [FK_ClinicalDocument_RemovalReason]
GO

SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[hips].[ClinicalDocumentStatus]') AND type in (N'U'))
BEGIN
CREATE TABLE [hips].[ClinicalDocumentStatus](
	[ClinicalDocumentStatusId] [int] IDENTITY(1,1) NOT NULL,
	[Description] [varchar](50) NOT NULL,
	[DateCreated] [datetime] NOT NULL,
	[UserCreated] [varchar](256) NOT NULL,
	[DateModified] [datetime] NOT NULL,
	[UserModified] [varchar](256) NOT NULL,
 CONSTRAINT [PK_ClinicalDocumentStatus] PRIMARY KEY CLUSTERED 
(
	[ClinicalDocumentStatusId] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
END
GO
SET ANSI_PADDING OFF
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'ClinicalDocumentStatus', N'COLUMN',N'Description'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Description (e.g. New, Uploaded, Removed, Superseded, Downloaded)' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'ClinicalDocumentStatus', @level2type=N'COLUMN',@level2name=N'Description'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'ClinicalDocumentStatus', NULL,NULL))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Identifies the status of a clinical document version' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'ClinicalDocumentStatus'
GO

SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[hips].[ClinicalDocumentVersion]') AND type in (N'U'))
BEGIN
CREATE TABLE [hips].[ClinicalDocumentVersion](
	[ClinicalDocumentVersionId] [int] IDENTITY(1,1) NOT NULL,
	[ClinicalDocumentId] [int] NOT NULL,
	[SourceSystemDocumentId] [varchar](128) NOT NULL,
	[UploadedDate] [datetime] NULL,
	[SupersededDate] [datetime] NULL,
	[Package] [varbinary](max) NULL,
	[DateCreated] [datetime] NOT NULL,
	[UserCreated] [varchar](256) NOT NULL,
	[DateModified] [datetime] NOT NULL,
	[UserModified] [varchar](256) NOT NULL,
 CONSTRAINT [PK_ClinicalDocumentVersion] PRIMARY KEY CLUSTERED 
(
	[ClinicalDocumentVersionId] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
END
GO
SET ANSI_PADDING OFF
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'ClinicalDocumentVersion', N'COLUMN',N'ClinicalDocumentId'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The document that this is a version of' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'ClinicalDocumentVersion', @level2type=N'COLUMN',@level2name=N'ClinicalDocumentId'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'ClinicalDocumentVersion', N'COLUMN',N'SourceSystemDocumentId'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'A globally-unique identifier for this version of the clinical document. Can be a UUID, or an OID, or an OID^extension.' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'ClinicalDocumentVersion', @level2type=N'COLUMN',@level2name=N'SourceSystemDocumentId'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'ClinicalDocumentVersion', N'COLUMN',N'UploadedDate'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The date and time when this version was uploaded' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'ClinicalDocumentVersion', @level2type=N'COLUMN',@level2name=N'UploadedDate'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'ClinicalDocumentVersion', N'COLUMN',N'SupersededDate'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The date and time when this version was superseded' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'ClinicalDocumentVersion', @level2type=N'COLUMN',@level2name=N'SupersededDate'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'ClinicalDocumentVersion', N'COLUMN',N'Package'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The CDA package is stored here if the source requests it to be' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'ClinicalDocumentVersion', @level2type=N'COLUMN',@level2name=N'Package'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'ClinicalDocumentVersion', NULL,NULL))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Versions of locally-created clinical documents' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'ClinicalDocumentVersion'
GO
IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_ClinicalDocumentVersion_ClinicalDocument]') AND parent_object_id = OBJECT_ID(N'[hips].[ClinicalDocumentVersion]'))
ALTER TABLE [hips].[ClinicalDocumentVersion]  WITH CHECK ADD  CONSTRAINT [FK_ClinicalDocumentVersion_ClinicalDocument] FOREIGN KEY([ClinicalDocumentId])
REFERENCES [hips].[ClinicalDocument] ([ClinicalDocumentId])
GO
IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_ClinicalDocumentVersion_ClinicalDocument]') AND parent_object_id = OBJECT_ID(N'[hips].[ClinicalDocumentVersion]'))
ALTER TABLE [hips].[ClinicalDocumentVersion] CHECK CONSTRAINT [FK_ClinicalDocumentVersion_ClinicalDocument]
GO

SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[hips].[CodeSystem]') AND type in (N'U'))
BEGIN
CREATE TABLE [hips].[CodeSystem](
	[CodeSystemId] [int] IDENTITY(1,1) NOT NULL,
	[Code] [varchar](20) NULL,
	[Description] [varchar](256) NOT NULL,
	[Oid] [varchar](256) NULL,
	[Version] [varchar](256) NULL,
	[DateCreated] [datetime] NOT NULL,
	[UserCreated] [varchar](256) NOT NULL,
	[DateModified] [datetime] NOT NULL,
	[UserModified] [varchar](256) NOT NULL,
 CONSTRAINT [PK_CodeSystem] PRIMARY KEY CLUSTERED 
(
	[CodeSystemId] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
END
GO
SET ANSI_PADDING OFF
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'CodeSystem', N'COLUMN',N'Code'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'A short code that is used in incoming messages to represent this code system' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'CodeSystem', @level2type=N'COLUMN',@level2name=N'Code'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'CodeSystem', N'COLUMN',N'Description'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Name of the coding system or the identifier assigning authority
' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'CodeSystem', @level2type=N'COLUMN',@level2name=N'Description'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'CodeSystem', N'COLUMN',N'Oid'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'OID of the coding system or root OID of the identifier.
' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'CodeSystem', @level2type=N'COLUMN',@level2name=N'Oid'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'CodeSystem', N'COLUMN',N'Version'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Version of the coding system' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'CodeSystem', @level2type=N'COLUMN',@level2name=N'Version'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'CodeSystem', NULL,NULL))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'A coding system or identifier namespace. For example, if your PAS messages always identify which hospital facility the PAS message relates to using a facility code, then the set of all such facility codes is an identifier namespace. Similarly the concept of an HPI-O is an identifier namespace. Identifiers are always unique when coupled with their proper namespace.' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'CodeSystem'
GO

SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[hips].[ConsentAudit]') AND type in (N'U'))
BEGIN
CREATE TABLE [hips].[ConsentAudit](
	[ConsentAuditId] [int] IDENTITY(1,1) NOT NULL,
	[EpisodeId] [int] NOT NULL,
	[ConsentWithdrawn] [bit] NOT NULL,
	[AuditInformation] [varbinary](MAX) NULL,
	[DateCreated] [datetime] NOT NULL,
	[UserCreated] [varchar](256) NOT NULL,
	[DateModified] [datetime] NOT NULL,
	[UserModified] [varchar](256) NOT NULL,
 CONSTRAINT [PK_ConsentAudit] PRIMARY KEY CLUSTERED 
(
	[ConsentAuditId] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
END
GO
SET ANSI_PADDING OFF
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'ConsentAudit', N'COLUMN',N'ConsentAuditId'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Primary Key' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'ConsentAudit', @level2type=N'COLUMN',@level2name=N'ConsentAuditId'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'ConsentAudit', N'COLUMN',N'EpisodeId'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Link to the episode for which consent was modified' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'ConsentAudit', @level2type=N'COLUMN',@level2name=N'EpisodeId'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'ConsentAudit', N'COLUMN',N'ConsentWithdrawn'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'New value of the consent flag' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'ConsentAudit', @level2type=N'COLUMN',@level2name=N'ConsentWithdrawn'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'ConsentAudit', N'COLUMN',N'AuditInformation'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The form requesting the change' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'ConsentAudit', @level2type=N'COLUMN',@level2name=N'AuditInformation'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'ConsentAudit', N'COLUMN',N'DateCreated'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Date that this record was inserted into the table' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'ConsentAudit', @level2type=N'COLUMN',@level2name=N'DateCreated'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'ConsentAudit', N'COLUMN',N'UserCreated'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'User account that inserted the record' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'ConsentAudit', @level2type=N'COLUMN',@level2name=N'UserCreated'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'ConsentAudit', N'COLUMN',N'DateModified'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Date and time that this record was last modified (or as inserted)' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'ConsentAudit', @level2type=N'COLUMN',@level2name=N'DateModified'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'ConsentAudit', N'COLUMN',N'UserModified'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The account of the user that last modified (or inserted) this record' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'ConsentAudit', @level2type=N'COLUMN',@level2name=N'UserModified'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'ConsentAudit', NULL,NULL))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Record that a user made a change to the patient''s consent to upload documents to the PCEHR for a particular episode.' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'ConsentAudit'
GO
IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_ConsentAudit_Episode]') AND parent_object_id = OBJECT_ID(N'[hips].[ConsentAudit]'))
ALTER TABLE [hips].[ConsentAudit]  WITH CHECK ADD  CONSTRAINT [FK_ConsentAudit_Episode] FOREIGN KEY([EpisodeId])
REFERENCES [hips].[Episode] ([EpisodeId])
GO
IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_ConsentAudit_Episode]') AND parent_object_id = OBJECT_ID(N'[hips].[ConsentAudit]'))
ALTER TABLE [hips].[ConsentAudit] CHECK CONSTRAINT [FK_ConsentAudit_Episode]
GO

SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[hips].[Contact]') AND type in (N'U'))
BEGIN
CREATE TABLE [hips].[Contact](
	[ContactId] [int] IDENTITY(1,1) NOT NULL,
	[Detail] [varchar](256) NOT NULL,
	[ContactMethodId] [int] NOT NULL,
	[DateCreated] [datetime] NOT NULL,
	[UserCreated] [varchar](256) NOT NULL,
	[DateModified] [datetime] NOT NULL,
	[UserModified] [varchar](256) NOT NULL,
 CONSTRAINT [PK_Contact] PRIMARY KEY CLUSTERED 
(
	[ContactId] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
END
GO
SET ANSI_PADDING OFF
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'Contact', N'COLUMN',N'Detail'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Contact number or address (e.g. joe.blogs@email.com or 0412345678)' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'Contact', @level2type=N'COLUMN',@level2name=N'Detail'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'Contact', N'COLUMN',N'ContactMethodId'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Identifies the contact method.' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'Contact', @level2type=N'COLUMN',@level2name=N'ContactMethodId'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'Contact', NULL,NULL))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'An electronic contact number or address for a single patient or hospital. Records must never be shared between patients.' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'Contact'
GO
IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_Contact_ContactMethod]') AND parent_object_id = OBJECT_ID(N'[hips].[Contact]'))
ALTER TABLE [hips].[Contact]  WITH CHECK ADD  CONSTRAINT [FK_Contact_ContactMethod] FOREIGN KEY([ContactMethodId])
REFERENCES [hips].[ContactMethod] ([ContactMethodId])
ON DELETE CASCADE
GO
IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_Contact_ContactMethod]') AND parent_object_id = OBJECT_ID(N'[hips].[Contact]'))
ALTER TABLE [hips].[Contact] CHECK CONSTRAINT [FK_Contact_ContactMethod]
GO

SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[hips].[ContactMethod]') AND type in (N'U'))
BEGIN
CREATE TABLE [hips].[ContactMethod](
	[ContactMethodId] [int] IDENTITY(1,1) NOT NULL,
	[TelecommunicationType] [varchar](10) NOT NULL,
	[CdaType] [varchar](10) NOT NULL,
	[Description] [varchar](40) NOT NULL,
	[DateCreated] [datetime] NOT NULL,
	[UserCreated] [varchar](256) NOT NULL,
	[DateModified] [datetime] NOT NULL,
	[UserModified] [varchar](256) NOT NULL,
 CONSTRAINT [PK_ContactMethod] PRIMARY KEY CLUSTERED 
(
	[ContactMethodId] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
END
GO
SET ANSI_PADDING OFF
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'ContactMethod', N'COLUMN',N'ContactMethodId'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Identifies an electronic contact method' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'ContactMethod', @level2type=N'COLUMN',@level2name=N'ContactMethodId'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'ContactMethod', N'COLUMN',N'TelecommunicationType'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'HL7 v3 TelecommunicationAddressType (e.g. H, MC, PG, WP)
' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'ContactMethod', @level2type=N'COLUMN',@level2name=N'TelecommunicationType'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'ContactMethod', N'COLUMN',N'CdaType'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'HL7 v3 URLScheme (e.g. tel, fax, mailto)' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'ContactMethod', @level2type=N'COLUMN',@level2name=N'CdaType'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'ContactMethod', N'COLUMN',N'Description'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Description (e.g. Home Phone, Home Fax, Personal Mobile, Personal Email, Pager, Work Phone, Work Fax, Work Mobile, Work Email)' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'ContactMethod', @level2type=N'COLUMN',@level2name=N'Description'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'ContactMethod', NULL,NULL))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Identifies an electronic contact method' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'ContactMethod'
GO

SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[hips].[Country]') AND type in (N'U'))
BEGIN
CREATE TABLE [hips].[Country](
	[CountryId] [int] IDENTITY(1,1) NOT NULL,
	[Code] [char](4) NOT NULL,
	[Description] [varchar](256) NOT NULL,
	[DateCreated] [datetime] NOT NULL,
	[UserCreated] [varchar](256) NOT NULL,
	[DateModified] [datetime] NOT NULL,
	[UserModified] [varchar](256) NOT NULL,
 CONSTRAINT [PK_Country] PRIMARY KEY CLUSTERED 
(
	[CountryId] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
END
GO
SET ANSI_PADDING OFF
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'Country', N'COLUMN',N'CountryId'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Identifies a country. Used in HIPS addresses and for PUMA to reference country of birth.' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'Country', @level2type=N'COLUMN',@level2name=N'CountryId'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'Country', N'COLUMN',N'Code'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'ABS SACC (4 digits)' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'Country', @level2type=N'COLUMN',@level2name=N'Code'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'Country', N'COLUMN',N'Description'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Description from ABS SACC' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'Country', @level2type=N'COLUMN',@level2name=N'Description'
GO

SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[hips].[CountryCode]') AND type in (N'U'))
BEGIN
CREATE TABLE [hips].[CountryCode](
	[CountryId] [int] NOT NULL,
	[CodeSystemId] [int] NOT NULL,
	[DateCreated] [datetime] NOT NULL,
	[UserCreated] [varchar](256) NOT NULL,
	[DateModified] [datetime] NOT NULL,
	[UserModified] [varchar](256) NOT NULL,
 CONSTRAINT [PK_CountryCode] PRIMARY KEY CLUSTERED 
(
	[CountryId] ASC,
	[CodeSystemId] ASC  
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
END
GO
SET ANSI_PADDING OFF
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'CountryCode', N'COLUMN',N'CountryId'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Country' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'CountryCode', @level2type=N'COLUMN',@level2name=N'CountryId'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'CountryCode', N'COLUMN',N'CodeSystemId'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Type of identifier' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'CountryCode', @level2type=N'COLUMN',@level2name=N'CodeSystemId'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'CountryCode', N'COLUMN',N'DateCreated'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Date and Time the record was created' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'CountryCode', @level2type=N'COLUMN',@level2name=N'DateCreated'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'CountryCode', N'COLUMN',N'UserCreated'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'User that created the record' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'CountryCode', @level2type=N'COLUMN',@level2name=N'UserCreated'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'CountryCode', N'COLUMN',N'DateModified'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Date and Time the record was modified' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'CountryCode', @level2type=N'COLUMN',@level2name=N'DateModified'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'CountryCode', N'COLUMN',N'UserModified'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'User that modified the record' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'CountryCode', @level2type=N'COLUMN',@level2name=N'UserModified'
GO
IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_CountryCode_CodeSystem]') AND parent_object_id = OBJECT_ID(N'[hips].[CountryCode]'))
ALTER TABLE [hips].[CountryCode]  WITH CHECK ADD  CONSTRAINT [FK_CountryCode_CodeSystem] FOREIGN KEY([CodeSystemId])
REFERENCES [hips].[CodeSystem] ([CodeSystemId])
GO
IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_CountryCode_CodeSystem]') AND parent_object_id = OBJECT_ID(N'[hips].[CountryCode]'))
ALTER TABLE [hips].[CountryCode] CHECK CONSTRAINT [FK_CountryCode_CodeSystem]
GO
IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_CountryCode_Country]') AND parent_object_id = OBJECT_ID(N'[hips].[CountryCode]'))
ALTER TABLE [hips].[CountryCode]  WITH CHECK ADD  CONSTRAINT [FK_CountryCode_Country] FOREIGN KEY([CountryId])
REFERENCES [hips].[Country] ([CountryId])
GO
IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_CountryCode_Country]') AND parent_object_id = OBJECT_ID(N'[hips].[CountryCode]'))
ALTER TABLE [hips].[CountryCode] CHECK CONSTRAINT [FK_CountryCode_Country]
GO

SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[hips].[DeathIndicator]') AND type in (N'U'))
BEGIN
CREATE TABLE [hips].[DeathIndicator](
	[DeathIndicatorId] [int] NOT NULL,
	[Description] [varchar](100) NOT NULL,
	[DateCreated] [datetime] NOT NULL,
	[UserCreated] [varchar](256) NOT NULL,
	[DateModified] [datetime] NOT NULL,
	[UserModified] [varchar](256) NOT NULL,
 CONSTRAINT [PK_DeathIndicator] PRIMARY KEY CLUSTERED 
(
	[DeathIndicatorId] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
END
GO
SET ANSI_PADDING OFF
GO

SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[hips].[DisclosureAudit]') AND type in (N'U'))
BEGIN
CREATE TABLE [hips].[DisclosureAudit](
	[DisclosureAuditId] [int] IDENTITY(1,1) NOT NULL,
	[HealthProviderOrganisationId] [int] NOT NULL,
	[PatientMasterId] [int] NOT NULL,
	[PcehrDisclosed] [bit] NOT NULL,
	[AuditInformation] [varbinary](MAX),
	[DateCreated] [datetime] NOT NULL,
	[UserCreated] [varchar](256) NOT NULL,
	[DateModified] [datetime] NOT NULL,
	[UserModified] [varchar](256) NOT NULL,
 CONSTRAINT [PK_DisclosureAudit] PRIMARY KEY CLUSTERED 
(
	[DisclosureAuditId] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
END
GO
SET ANSI_PADDING OFF
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'DisclosureAudit', N'COLUMN',N'DisclosureAuditId'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Primary Key' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'DisclosureAudit', @level2type=N'COLUMN',@level2name=N'DisclosureAuditId'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'DisclosureAudit', N'COLUMN',N'HealthProviderOrganisationId'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Link to the HPI-O for which disclosure was modified' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'DisclosureAudit', @level2type=N'COLUMN',@level2name=N'HealthProviderOrganisationId'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'DisclosureAudit', N'COLUMN',N'PatientMasterId'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Link to the patient for which consent was modified' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'DisclosureAudit', @level2type=N'COLUMN',@level2name=N'PatientMasterId'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'DisclosureAudit', N'COLUMN',N'PcehrDisclosed'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'New value of the PCEHR disclosed flag' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'DisclosureAudit', @level2type=N'COLUMN',@level2name=N'PcehrDisclosed'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'DisclosureAudit', N'COLUMN',N'AuditInformation'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Hold the form data for posterity' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'DisclosureAudit', @level2type=N'COLUMN',@level2name=N'AuditInformation'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'DisclosureAudit', N'COLUMN',N'DateCreated'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Date that this record was inserted into the table' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'DisclosureAudit', @level2type=N'COLUMN',@level2name=N'DateCreated'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'DisclosureAudit', N'COLUMN',N'UserCreated'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'User account that inserted the record' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'DisclosureAudit', @level2type=N'COLUMN',@level2name=N'UserCreated'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'DisclosureAudit', N'COLUMN',N'DateModified'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Date and time that this record was last modified (or as inserted)' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'DisclosureAudit', @level2type=N'COLUMN',@level2name=N'DateModified'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'DisclosureAudit', N'COLUMN',N'UserModified'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The account of the user that last modified (or inserted) this record' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'DisclosureAudit', @level2type=N'COLUMN',@level2name=N'UserModified'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'DisclosureAudit', NULL,NULL))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Record that a user made a change to the patient''s disclosure of a PCEHR to a particular health provider organisation.' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'DisclosureAudit'
GO
IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_DisclosureAudit_HealthProviderOrganisation]') AND parent_object_id = OBJECT_ID(N'[hips].[DisclosureAudit]'))
ALTER TABLE [hips].[DisclosureAudit]  WITH CHECK ADD  CONSTRAINT [FK_DisclosureAudit_HealthProviderOrganisation] FOREIGN KEY([HealthProviderOrganisationId])
REFERENCES [hips].[HealthProviderOrganisation] ([HealthProviderOrganisationId])
GO
IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_DisclosureAudit_HealthProviderOrganisation]') AND parent_object_id = OBJECT_ID(N'[hips].[DisclosureAudit]'))
ALTER TABLE [hips].[DisclosureAudit] CHECK CONSTRAINT [FK_DisclosureAudit_HealthProviderOrganisation]
GO
IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_DisclosureAudit_PatientMaster]') AND parent_object_id = OBJECT_ID(N'[hips].[DisclosureAudit]'))
ALTER TABLE [hips].[DisclosureAudit]  WITH CHECK ADD  CONSTRAINT [FK_DisclosureAudit_PatientMaster] FOREIGN KEY([PatientMasterId])
REFERENCES [hips].[PatientMaster] ([PatientMasterId])
GO
IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_DisclosureAudit_PatientMaster]') AND parent_object_id = OBJECT_ID(N'[hips].[DisclosureAudit]'))
ALTER TABLE [hips].[DisclosureAudit] CHECK CONSTRAINT [FK_DisclosureAudit_PatientMaster]
GO

SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[hips].[DocumentFormat]') AND type in (N'U'))
BEGIN
CREATE TABLE [hips].[DocumentFormat](
	[DocumentFormatId] [int] IDENTITY(1,1) NOT NULL,
	[Code] [varchar](100) NOT NULL,
	[Description] [varchar](200) NOT NULL,
	[CodeSystemId] [int] NOT NULL,
	[DateCreated] [datetime] NOT NULL,
	[UserCreated] [varchar](256) NOT NULL,
	[DateModified] [datetime] NOT NULL,
	[UserModified] [varchar](256) NOT NULL,
 CONSTRAINT [PK_DocumentFormat] PRIMARY KEY CLUSTERED 
(
	[DocumentFormatId] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
END
GO
SET ANSI_PADDING OFF
GO

IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'DocumentFormat', N'COLUMN',N'Code'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Code (e.g. 1.2.36.1.2001.1006.1.20000.11)' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'DocumentFormat', @level2type=N'COLUMN',@level2name=N'Code'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'DocumentFormat', N'COLUMN',N'Description'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Description (e.g. Discharge Summary - Conformance 3A)' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'DocumentFormat', @level2type=N'COLUMN',@level2name=N'Description'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'DocumentFormat', NULL,NULL))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Identifies a format of clinical document (type and conformance level)' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'DocumentFormat'
GO
IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_DocumentFormat_CodeSystem]') AND parent_object_id = OBJECT_ID(N'[hips].[DocumentFormat]'))
ALTER TABLE [hips].[DocumentFormat]  WITH CHECK ADD  CONSTRAINT [FK_DocumentFormat_CodeSystem] FOREIGN KEY([CodeSystemId])
REFERENCES [hips].[CodeSystem] ([CodeSystemId])
GO
IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_DocumentFormat_CodeSystem]') AND parent_object_id = OBJECT_ID(N'[hips].[DocumentFormat]'))
ALTER TABLE [hips].[DocumentFormat] CHECK CONSTRAINT [FK_DocumentFormat_CodeSystem]
GO

SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[hips].[DocumentType]') AND type in (N'U'))
BEGIN
CREATE TABLE [hips].[DocumentType](
	[DocumentTypeId] [int] IDENTITY(1,1) NOT NULL,
	[RepositoryId] [int] NOT NULL,
	[Description] [varchar](50) NOT NULL,
	[Code] [varchar](20) NOT NULL,
	[DateCreated] [datetime] NOT NULL,
	[UserCreated] [varchar](256) NOT NULL,
	[DateModified] [datetime] NOT NULL,
	[UserModified] [varchar](256) NOT NULL,
 CONSTRAINT [PK_DocumentType] PRIMARY KEY CLUSTERED 
(
	[DocumentTypeId] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
END
GO
SET ANSI_PADDING OFF
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'DocumentType', N'COLUMN',N'Description'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Description (e.g. Discharge Summary, Event Summary, e-Referral)' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'DocumentType', @level2type=N'COLUMN',@level2name=N'Description'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'DocumentType', NULL,NULL))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Identifies a type of clinical document' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'DocumentType'
GO
IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_DocumentType_Repository]') AND parent_object_id = OBJECT_ID(N'[hips].[DocumentType]'))
ALTER TABLE [hips].[DocumentType]  WITH CHECK ADD  CONSTRAINT [FK_DocumentType_Repository] FOREIGN KEY([RepositoryId])
REFERENCES [hips].[Repository] ([RepositoryId])
GO
IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_DocumentType_Repository]') AND parent_object_id = OBJECT_ID(N'[hips].[DocumentType]'))
ALTER TABLE [hips].[DocumentType] CHECK CONSTRAINT [FK_DocumentType_Repository]
GO

SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[hips].[DownloadedDocument]') AND type in (N'U'))
BEGIN
CREATE TABLE [hips].[DownloadedDocument](
	[DownloadedDocumentId] [int] IDENTITY(1,1) NOT NULL,
	[PatientMasterId] [int] NOT NULL,
	[SourceSystemDocumentId] [varchar](256) NOT NULL,
	[Package] [varbinary](max) NULL,
	[DownloadedDate] [datetime] NOT NULL,
	[ClinicalDocumentStatusId] [int] NOT NULL,
	[CurrentDocumentId] [int] NULL,
	[DateCreated] [datetime] NOT NULL,
	[UserCreated] [varchar](256) NOT NULL,
	[DateModified] [datetime] NOT NULL,
	[UserModified] [varchar](256) NOT NULL,
 CONSTRAINT [PK_DownloadedDocument] PRIMARY KEY CLUSTERED 
(
	[DownloadedDocumentId] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
END
GO
SET ANSI_PADDING OFF
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'DownloadedDocument', N'COLUMN',N'DownloadedDocumentId'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Identifies a downloaded document instance' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'DownloadedDocument', @level2type=N'COLUMN',@level2name=N'DownloadedDocumentId'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'DownloadedDocument', N'COLUMN',N'PatientMasterId'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The patient that this document relates to' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'DownloadedDocument', @level2type=N'COLUMN',@level2name=N'PatientMasterId'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'DownloadedDocument', N'COLUMN',N'SourceSystemDocumentId'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'A globally-unique identifier for this document instance. Can be a UUID or an OID, or an OID^extension.' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'DownloadedDocument', @level2type=N'COLUMN',@level2name=N'SourceSystemDocumentId'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'DownloadedDocument', N'COLUMN',N'Package'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The CDA package is stored here if the clinical system requests.' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'DownloadedDocument', @level2type=N'COLUMN',@level2name=N'Package'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'DownloadedDocument', N'COLUMN',N'DownloadedDate'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The date and time when this version was downloaded.' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'DownloadedDocument', @level2type=N'COLUMN',@level2name=N'DownloadedDate'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'DownloadedDocument', N'COLUMN',N'ClinicalDocumentStatusId'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Initially ''downloaded'', later may be ''superseded'' or ''removed''.' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'DownloadedDocument', @level2type=N'COLUMN',@level2name=N'ClinicalDocumentStatusId'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'DownloadedDocument', N'COLUMN',N'CurrentDocumentId'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Link within this table to the most recent version of this document' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'DownloadedDocument', @level2type=N'COLUMN',@level2name=N'CurrentDocumentId'
GO
IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_DownloadedDocument_ClinicalDocumentStatus]') AND parent_object_id = OBJECT_ID(N'[hips].[DownloadedDocument]'))
ALTER TABLE [hips].[DownloadedDocument]  WITH CHECK ADD  CONSTRAINT [FK_DownloadedDocument_ClinicalDocumentStatus] FOREIGN KEY([ClinicalDocumentStatusId])
REFERENCES [hips].[ClinicalDocumentStatus] ([ClinicalDocumentStatusId])
GO
IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_DownloadedDocument_ClinicalDocumentStatus]') AND parent_object_id = OBJECT_ID(N'[hips].[DownloadedDocument]'))
ALTER TABLE [hips].[DownloadedDocument] CHECK CONSTRAINT [FK_DownloadedDocument_ClinicalDocumentStatus]
GO
IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_DownloadedDocument_DownloadedDocument]') AND parent_object_id = OBJECT_ID(N'[hips].[DownloadedDocument]'))
ALTER TABLE [hips].[DownloadedDocument]  WITH CHECK ADD  CONSTRAINT [FK_DownloadedDocument_DownloadedDocument] FOREIGN KEY([CurrentDocumentId])
REFERENCES [hips].[DownloadedDocument] ([DownloadedDocumentId])
GO
IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_DownloadedDocument_DownloadedDocument]') AND parent_object_id = OBJECT_ID(N'[hips].[DownloadedDocument]'))
ALTER TABLE [hips].[DownloadedDocument] CHECK CONSTRAINT [FK_DownloadedDocument_DownloadedDocument]
GO
IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_DownloadedDocument_PatientMaster]') AND parent_object_id = OBJECT_ID(N'[hips].[DownloadedDocument]'))
ALTER TABLE [hips].[DownloadedDocument]  WITH CHECK ADD  CONSTRAINT [FK_DownloadedDocument_PatientMaster] FOREIGN KEY([PatientMasterId])
REFERENCES [hips].[PatientMaster] ([PatientMasterId])
GO
IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_DownloadedDocument_PatientMaster]') AND parent_object_id = OBJECT_ID(N'[hips].[DownloadedDocument]'))
ALTER TABLE [hips].[DownloadedDocument] CHECK CONSTRAINT [FK_DownloadedDocument_PatientMaster]
GO

SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[hips].[Episode]') AND type in (N'U'))
BEGIN
CREATE TABLE [hips].[Episode](
	[EpisodeId] [int] IDENTITY(1,1) NOT NULL,
	[PatientId] [int] NOT NULL,
	[SourceSystemEpisodeId] [varchar](100) NOT NULL,
	[AdmissionDate] [datetime] NOT NULL,
	[AdmissionReason] [varchar](1000) NULL,
	[DischargeDate] [datetime] NULL,
	[ResponsibleProviderId] [int] NOT NULL,
	[EpisodeTypeId] [int] NULL,
	[EpisodeLifecycleId] [int] NULL,
	[ConsentWithdrawn] [bit] NOT NULL,
	[Ward] [varchar](40) NULL,
	[Room] [varchar](40) NULL,
	[Bed] [varchar](40) NULL,
	[DateCreated] [datetime] NOT NULL,
	[UserCreated] [varchar](256) NOT NULL,
	[DateModified] [datetime] NOT NULL,
	[UserModified] [varchar](256) NOT NULL,
 CONSTRAINT [PK_Episode] PRIMARY KEY CLUSTERED 
(
	[EpisodeId] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
END
GO
SET ANSI_PADDING OFF
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'Episode', N'COLUMN',N'PatientId'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The patient record at the specific hospital in which this episode is situated.' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'Episode', @level2type=N'COLUMN',@level2name=N'PatientId'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'Episode', N'COLUMN',N'SourceSystemEpisodeId'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Identifier for this episode allocated by the PAS' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'Episode', @level2type=N'COLUMN',@level2name=N'SourceSystemEpisodeId'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'Episode', N'COLUMN',N'AdmissionDate'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Admission / service start date and time
' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'Episode', @level2type=N'COLUMN',@level2name=N'AdmissionDate'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'Episode', N'COLUMN',N'AdmissionReason'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Overall reason why the patient is in hospital.
' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'Episode', @level2type=N'COLUMN',@level2name=N'AdmissionReason'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'Episode', N'COLUMN',N'DischargeDate'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Discharge / service stop date and time' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'Episode', @level2type=N'COLUMN',@level2name=N'DischargeDate'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'Episode', N'COLUMN',N'ResponsibleProviderId'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Responsible provider for this episode, as supplied by the PAS' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'Episode', @level2type=N'COLUMN',@level2name=N'ResponsibleProviderId'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'Episode', N'COLUMN',N'EpisodeTypeId'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Type of episode (e.g. inpatient admission, day admission, outpatient visit, emergency visit).' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'Episode', @level2type=N'COLUMN',@level2name=N'EpisodeTypeId'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'Episode', N'COLUMN',N'EpisodeLifecycleId'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The current stage of this episode (e.g. future booking, in progress, ended, cancelled).' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'Episode', @level2type=N'COLUMN',@level2name=N'EpisodeLifecycleId'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'Episode', N'COLUMN',N'ConsentWithdrawn'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Stores the patient''s withdrawal of consent to upload documents relating to this episode to his/her PCEHR. When 0 it represents the default state where uploading will proceed. When 1 then consent is withdrawn and HIPS must prevent the upload.' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'Episode', @level2type=N'COLUMN',@level2name=N'ConsentWithdrawn'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'Episode', N'COLUMN',N'Ward'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Ward component of patient location' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'Episode', @level2type=N'COLUMN',@level2name=N'Ward'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'Episode', N'COLUMN',N'Room'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Room component of patient location' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'Episode', @level2type=N'COLUMN',@level2name=N'Room'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'Episode', N'COLUMN',N'Bed'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Bed component of patient location' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'Episode', @level2type=N'COLUMN',@level2name=N'Bed'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'Episode', NULL,NULL))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'An admission or other visit by a patient to a hospital.' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'Episode'
GO
IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_Episode_EpisodeLifecycle]') AND parent_object_id = OBJECT_ID(N'[hips].[Episode]'))
ALTER TABLE [hips].[Episode]  WITH CHECK ADD  CONSTRAINT [FK_Episode_EpisodeLifecycle] FOREIGN KEY([EpisodeLifecycleId])
REFERENCES [hips].[EpisodeLifecycle] ([EpisodeLifecycleId])
GO
IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_Episode_EpisodeLifecycle]') AND parent_object_id = OBJECT_ID(N'[hips].[Episode]'))
ALTER TABLE [hips].[Episode] CHECK CONSTRAINT [FK_Episode_EpisodeLifecycle]
GO
IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_Episode_EpisodeType]') AND parent_object_id = OBJECT_ID(N'[hips].[Episode]'))
ALTER TABLE [hips].[Episode]  WITH CHECK ADD  CONSTRAINT [FK_Episode_EpisodeType] FOREIGN KEY([EpisodeTypeId])
REFERENCES [hips].[EpisodeType] ([EpisodeTypeId])
GO
IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_Episode_EpisodeType]') AND parent_object_id = OBJECT_ID(N'[hips].[Episode]'))
ALTER TABLE [hips].[Episode] CHECK CONSTRAINT [FK_Episode_EpisodeType]
GO
IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_Episode_HealthProviderIndividual]') AND parent_object_id = OBJECT_ID(N'[hips].[Episode]'))
ALTER TABLE [hips].[Episode]  WITH CHECK ADD  CONSTRAINT [FK_Episode_HealthProviderIndividual] FOREIGN KEY([ResponsibleProviderId])
REFERENCES [hips].[HealthProviderIndividual] ([HealthProviderIndividualId])
GO
IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_Episode_HealthProviderIndividual]') AND parent_object_id = OBJECT_ID(N'[hips].[Episode]'))
ALTER TABLE [hips].[Episode] CHECK CONSTRAINT [FK_Episode_HealthProviderIndividual]
GO
IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_Episode_Patient]') AND parent_object_id = OBJECT_ID(N'[hips].[Episode]'))
ALTER TABLE [hips].[Episode]  WITH CHECK ADD  CONSTRAINT [FK_Episode_Patient] FOREIGN KEY([PatientId])
REFERENCES [hips].[HospitalPatient] ([PatientId])
GO
IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_Episode_Patient]') AND parent_object_id = OBJECT_ID(N'[hips].[Episode]'))
ALTER TABLE [hips].[Episode] CHECK CONSTRAINT [FK_Episode_Patient]
GO

SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[hips].[EpisodeLifecycle]') AND type in (N'U'))
BEGIN
CREATE TABLE [hips].[EpisodeLifecycle](
	[EpisodeLifecycleId] [int] NOT NULL,
	[Description] [varchar](50) NOT NULL,
	[DateCreated] [datetime] NOT NULL,
	[UserCreated] [varchar](256) NOT NULL,
	[DateModified] [datetime] NOT NULL,
	[UserModified] [varchar](256) NOT NULL,
 CONSTRAINT [PK_EpisodeLifecycle] PRIMARY KEY CLUSTERED 
(
	[EpisodeLifecycleId] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
END
GO
SET ANSI_PADDING OFF
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'EpisodeLifecycle', N'COLUMN',N'EpisodeLifecycleId'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The episode lifecycle ID' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'EpisodeLifecycle', @level2type=N'COLUMN',@level2name=N'EpisodeLifecycleId'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'EpisodeLifecycle', N'COLUMN',N'Description'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Description (e.g. Booked, In Progress, Completed, Cancelled)' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'EpisodeLifecycle', @level2type=N'COLUMN',@level2name=N'Description'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'EpisodeLifecycle', N'COLUMN',N'DateCreated'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Date that this patient record was inserted into the table' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'EpisodeLifecycle', @level2type=N'COLUMN',@level2name=N'DateCreated'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'EpisodeLifecycle', N'COLUMN',N'UserCreated'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'User account that inserted the record' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'EpisodeLifecycle', @level2type=N'COLUMN',@level2name=N'UserCreated'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'EpisodeLifecycle', N'COLUMN',N'DateModified'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Date and time that this record was last modified (or as inserted)' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'EpisodeLifecycle', @level2type=N'COLUMN',@level2name=N'DateModified'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'EpisodeLifecycle', N'COLUMN',N'UserModified'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The account of the user that last modified (or inserted) this record' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'EpisodeLifecycle', @level2type=N'COLUMN',@level2name=N'UserModified'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'EpisodeLifecycle', NULL,NULL))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Identifies a type of episode (HL7 PV1-2 Patient Class)' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'EpisodeLifecycle'
GO

SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[hips].[EpisodeType]') AND type in (N'U'))
BEGIN
CREATE TABLE [hips].[EpisodeType](
	[EpisodeTypeId] [int] NOT NULL,
	[Code] [varchar](10) NOT NULL,
	[Description] [varchar](50) NOT NULL,
	[DateCreated] [datetime] NOT NULL,
	[UserCreated] [varchar](256) NOT NULL,
	[DateModified] [datetime] NOT NULL,
	[UserModified] [varchar](256) NOT NULL,
 CONSTRAINT [PK_EpisodeType] PRIMARY KEY CLUSTERED 
(
	[EpisodeTypeId] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
END
GO
SET ANSI_PADDING OFF
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'EpisodeType', N'COLUMN',N'EpisodeTypeId'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The episode type ID' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'EpisodeType', @level2type=N'COLUMN',@level2name=N'EpisodeTypeId'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'EpisodeType', N'COLUMN',N'Code'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Enterprise Code (e.g. I, S, O, E, P, R)' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'EpisodeType', @level2type=N'COLUMN',@level2name=N'Code'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'EpisodeType', N'COLUMN',N'Description'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Enterprise Description (e.g. Inpatient, Same day patient, Outpatient, Emergency, Pre-admit, Recurring patient)' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'EpisodeType', @level2type=N'COLUMN',@level2name=N'Description'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'EpisodeType', N'COLUMN',N'DateCreated'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Date that this patient record was inserted into the table' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'EpisodeType', @level2type=N'COLUMN',@level2name=N'DateCreated'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'EpisodeType', N'COLUMN',N'UserCreated'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'User account that inserted the record' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'EpisodeType', @level2type=N'COLUMN',@level2name=N'UserCreated'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'EpisodeType', N'COLUMN',N'DateModified'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Date and time that this record was last modified (or as inserted)' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'EpisodeType', @level2type=N'COLUMN',@level2name=N'DateModified'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'EpisodeType', N'COLUMN',N'UserModified'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The account of the user that last modified (or inserted) this record' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'EpisodeType', @level2type=N'COLUMN',@level2name=N'UserModified'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'EpisodeType', NULL,NULL))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Identifies a type of episode (HL7 PV1-2 Patient Class)' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'EpisodeType'
GO

SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[hips].[HealthProviderIndividual]') AND type in (N'U'))
BEGIN
CREATE TABLE [hips].[HealthProviderIndividual](
	[HealthProviderIndividualId] [int] IDENTITY(1,1) NOT NULL,
	[IamProviderIdentifier] [varchar](30) NULL,
	[HpiI] [varchar](16) NULL,
	[HpiILastValidatedDate] [datetime] NULL,
	[TitleId] [int] NOT NULL,
	[FamilyName] [varchar](80) NOT NULL,
	[GivenNames] [varchar](100) NULL,
	[SuffixId] [int] NOT NULL,
	[DateCreated] [datetime] NOT NULL,
	[UserCreated] [varchar](256) NOT NULL,
	[DateModified] [datetime] NOT NULL,
	[UserModified] [varchar](256) NOT NULL,
 CONSTRAINT [PK_Provider] PRIMARY KEY CLUSTERED 
(
	[HealthProviderIndividualId] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
END
GO
SET ANSI_PADDING OFF
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'HealthProviderIndividual', N'COLUMN',N'IamProviderIdentifier'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Identifier of this provider allocated by the jurisdiction''s Identity and Access Management (IAM) system (e.g. Health Active Directory account)' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'HealthProviderIndividual', @level2type=N'COLUMN',@level2name=N'IamProviderIdentifier'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'HealthProviderIndividual', N'COLUMN',N'HpiI'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'HPI-I of this provider' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'HealthProviderIndividual', @level2type=N'COLUMN',@level2name=N'HpiI'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'HealthProviderIndividual', N'COLUMN',N'HpiILastValidatedDate'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Date and time when the HPI-I was last validated' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'HealthProviderIndividual', @level2type=N'COLUMN',@level2name=N'HpiILastValidatedDate'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'HealthProviderIndividual', N'COLUMN',N'TitleId'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Name title' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'HealthProviderIndividual', @level2type=N'COLUMN',@level2name=N'TitleId'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'HealthProviderIndividual', N'COLUMN',N'FamilyName'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Family name with which the HPI-I was validated' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'HealthProviderIndividual', @level2type=N'COLUMN',@level2name=N'FamilyName'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'HealthProviderIndividual', N'COLUMN',N'GivenNames'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Given names with which the HPI-I was validated' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'HealthProviderIndividual', @level2type=N'COLUMN',@level2name=N'GivenNames'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'HealthProviderIndividual', N'COLUMN',N'SuffixId'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Name suffix' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'HealthProviderIndividual', @level2type=N'COLUMN',@level2name=N'SuffixId'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'HealthProviderIndividual', NULL,NULL))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Identifies an individual healthcare provider who works at one or more of the hospital facilities within the jurisdiction, who is suitable to be identified as a Document Author or Responsible Health Professional at Time of Discharge.' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'HealthProviderIndividual'
GO
IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_HealthProviderIndividual_Suffix]') AND parent_object_id = OBJECT_ID(N'[hips].[HealthProviderIndividual]'))
ALTER TABLE [hips].[HealthProviderIndividual]  WITH CHECK ADD  CONSTRAINT [FK_HealthProviderIndividual_Suffix] FOREIGN KEY([SuffixId])
REFERENCES [hips].[Suffix] ([SuffixId])
GO
IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_HealthProviderIndividual_Suffix]') AND parent_object_id = OBJECT_ID(N'[hips].[HealthProviderIndividual]'))
ALTER TABLE [hips].[HealthProviderIndividual] CHECK CONSTRAINT [FK_HealthProviderIndividual_Suffix]
GO
IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_HealthProviderIndividual_Title]') AND parent_object_id = OBJECT_ID(N'[hips].[HealthProviderIndividual]'))
ALTER TABLE [hips].[HealthProviderIndividual]  WITH CHECK ADD  CONSTRAINT [FK_HealthProviderIndividual_Title] FOREIGN KEY([TitleId])
REFERENCES [hips].[Title] ([TitleId])
GO
IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_HealthProviderIndividual_Title]') AND parent_object_id = OBJECT_ID(N'[hips].[HealthProviderIndividual]'))
ALTER TABLE [hips].[HealthProviderIndividual] CHECK CONSTRAINT [FK_HealthProviderIndividual_Title]
GO

SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[hips].[HealthProviderOrganisation]') AND type in (N'U'))
BEGIN
CREATE TABLE [hips].[HealthProviderOrganisation](
	[HealthProviderOrganisationId] [int] IDENTITY(1,1) NOT NULL,
	[HpiO] [varchar](16) NOT NULL,
	[Name] [varchar](100) NOT NULL,
	[HiCertSerial] [varchar](32) NOT NULL,
	[PcehrCertSerial] [varchar](32) NOT NULL,
	[HpoCertSerial] [varchar](32) NULL,
	[AuthorisedEmployeeName] [varchar](100) NULL,
	[AuthorisedEmployeeUserId] [varchar](30) NULL,
	[VisitorHospitalId] [int] NULL,
	[HiCSP] BIT NOT NULL,
	[PcehrCsp] BIT NOT NULL,
	[HealthProviderOrganisationNetworkId] INT NOT NULL,
	[DateCreated] [datetime] NOT NULL,
	[UserCreated] [varchar](256) NOT NULL,
	[DateModified] [datetime] NOT NULL,
	[UserModified] [varchar](256) NOT NULL,
 CONSTRAINT [PK_HealthProviderOrganisation] PRIMARY KEY CLUSTERED 
(
	[HealthProviderOrganisationId] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
END
GO
SET ANSI_PADDING OFF
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'HealthProviderOrganisation', N'COLUMN',N'HealthProviderOrganisationId'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Represents an organisation in the HPI-O network structure.' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'HealthProviderOrganisation', @level2type=N'COLUMN',@level2name=N'HealthProviderOrganisationId'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'HealthProviderOrganisation', N'COLUMN',N'HpiO'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'National identifier for health provider organisation.' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'HealthProviderOrganisation', @level2type=N'COLUMN',@level2name=N'HpiO'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'HealthProviderOrganisation', N'COLUMN',N'Name'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Name of the organisation.' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'HealthProviderOrganisation', @level2type=N'COLUMN',@level2name=N'Name'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'HealthProviderOrganisation', N'COLUMN',N'HiCertSerial'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Hexadecimal serial number for certificate used to establish connections to Healthcare Identifier Service.' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'HealthProviderOrganisation', @level2type=N'COLUMN',@level2name=N'HiCertSerial'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'HealthProviderOrganisation', N'COLUMN',N'PcehrCertSerial'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Hexadecimal serial number for certificate used to establish connections to PCEHR B2B Gateway Service.' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'HealthProviderOrganisation', @level2type=N'COLUMN',@level2name=N'PcehrCertSerial'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'HealthProviderOrganisation', N'COLUMN',N'AuthorisedEmployeeUserId'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Name of the Authorised Employee for this HPIO.' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'HealthProviderOrganisation', @level2type=N'COLUMN',@level2name=N'AuthorisedEmployeeUserId'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'HealthProviderOrganisation', N'COLUMN',N'AuthorisedEmployeeName'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'User Name of the Authorised Employee for this HPIO.' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'HealthProviderOrganisation', @level2type=N'COLUMN',@level2name=N'AuthorisedEmployeeName'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'HealthProviderOrganisation', N'COLUMN',N'VisitorHospitalId'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Hospital Id related to the visitor hospital.' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'HealthProviderOrganisation', @level2type=N'COLUMN',@level2name=N'VisitorHospitalId'
GO

SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[hips].[HealthProviderOrganisationNetwork]') AND type in (N'U'))
BEGIN
CREATE TABLE [hips].[HealthProviderOrganisationNetwork](
	[HealthProviderOrganisationNetworkId] [int] IDENTITY(1,1) NOT NULL,
	[SeedHpio] [varchar](16) NOT NULL,
	[SeedName] [varchar](256) NOT NULL,
	[DateCreated] [datetime] NOT NULL,
	[UserCreated] [varchar](256) NOT NULL,
	[DateModified] [datetime] NOT NULL,
	[UserModified] [varchar](256) NOT NULL,
 CONSTRAINT [PK_HealthProviderOrganisationNetwork] PRIMARY KEY CLUSTERED 
(
	[HealthProviderOrganisationNetworkId] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
END
GO
SET ANSI_PADDING OFF
GO

SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[hips].[HealthProviderOrganisationPatient]') AND type in (N'U'))
BEGIN
CREATE TABLE [hips].[HealthProviderOrganisationPatient](
	[HealthProviderOrganisationId] [int] NOT NULL,
	[PatientMasterId] [int] NOT NULL,
	[PcehrAdvertised] [bit] NULL,
	[AccessCodeRequiredId] [int] NOT NULL,
	[PcehrDisclosed] [bit] NOT NULL,
	[DateCreated] [datetime] NOT NULL,
	[UserCreated] [varchar](256) NOT NULL,
	[DateModified] [datetime] NOT NULL,
	[UserModified] [varchar](256) NOT NULL,
 CONSTRAINT [PK_HealthProviderOrganisationPatient] PRIMARY KEY CLUSTERED 
(
	[HealthProviderOrganisationId] ASC,
	[PatientMasterId] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
END
GO
SET ANSI_PADDING OFF
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'HealthProviderOrganisationPatient', N'COLUMN',N'HealthProviderOrganisationId'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Link to the Health Provider Organisation (HPI-O).' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'HealthProviderOrganisationPatient', @level2type=N'COLUMN',@level2name=N'HealthProviderOrganisationId'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'HealthProviderOrganisationPatient', N'COLUMN',N'PatientMasterId'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Link to the HIPS Patient Master record.' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'HealthProviderOrganisationPatient', @level2type=N'COLUMN',@level2name=N'PatientMasterId'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'HealthProviderOrganisationPatient', N'COLUMN',N'PcehrAdvertised'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Whether the patient has chosen to advertise the existence of his/her PCEHR to this HPO.' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'HealthProviderOrganisationPatient', @level2type=N'COLUMN',@level2name=N'PcehrAdvertised'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'HealthProviderOrganisationPatient', N'COLUMN',N'AccessCodeRequiredId'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Whether access has been gained, and whether a code will be required to gain access.' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'HealthProviderOrganisationPatient', @level2type=N'COLUMN',@level2name=N'AccessCodeRequiredId'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'HealthProviderOrganisationPatient', N'COLUMN',N'PcehrDisclosed'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Whether the patient has disclosed the existence of his/her PCEHR to this HPO.' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'HealthProviderOrganisationPatient', @level2type=N'COLUMN',@level2name=N'PcehrDisclosed'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'HealthProviderOrganisationPatient', N'COLUMN',N'DateCreated'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Date that this patient record was inserted into the table' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'HealthProviderOrganisationPatient', @level2type=N'COLUMN',@level2name=N'DateCreated'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'HealthProviderOrganisationPatient', N'COLUMN',N'UserCreated'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'User account that inserted the record' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'HealthProviderOrganisationPatient', @level2type=N'COLUMN',@level2name=N'UserCreated'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'HealthProviderOrganisationPatient', N'COLUMN',N'DateModified'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Date and time that this record was last modified (or as inserted)' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'HealthProviderOrganisationPatient', @level2type=N'COLUMN',@level2name=N'DateModified'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'HealthProviderOrganisationPatient', N'COLUMN',N'UserModified'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The account of the user that last modified (or inserted) this record' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'HealthProviderOrganisationPatient', @level2type=N'COLUMN',@level2name=N'UserModified'
GO
IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_HealthProviderOrganisationPatient_AccessCodeRequired]') AND parent_object_id = OBJECT_ID(N'[hips].[HealthProviderOrganisationPatient]'))
ALTER TABLE [hips].[HealthProviderOrganisationPatient]  WITH CHECK ADD  CONSTRAINT [FK_HealthProviderOrganisationPatient_AccessCodeRequired] FOREIGN KEY([AccessCodeRequiredId])
REFERENCES [hips].[AccessCodeRequired] ([AccessCodeRequiredId])
GO
IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_HealthProviderOrganisationPatient_AccessCodeRequired]') AND parent_object_id = OBJECT_ID(N'[hips].[HealthProviderOrganisationPatient]'))
ALTER TABLE [hips].[HealthProviderOrganisationPatient] CHECK CONSTRAINT [FK_HealthProviderOrganisationPatient_AccessCodeRequired]
GO
IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_HealthProviderOrganisationPatient_HealthProviderOrganisation]') AND parent_object_id = OBJECT_ID(N'[hips].[HealthProviderOrganisationPatient]'))
ALTER TABLE [hips].[HealthProviderOrganisationPatient]  WITH CHECK ADD  CONSTRAINT [FK_HealthProviderOrganisationPatient_HealthProviderOrganisation] FOREIGN KEY([HealthProviderOrganisationId])
REFERENCES [hips].[HealthProviderOrganisation] ([HealthProviderOrganisationId])
GO
IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_HealthProviderOrganisationPatient_HealthProviderOrganisation]') AND parent_object_id = OBJECT_ID(N'[hips].[HealthProviderOrganisationPatient]'))
ALTER TABLE [hips].[HealthProviderOrganisationPatient] CHECK CONSTRAINT [FK_HealthProviderOrganisationPatient_HealthProviderOrganisation]
GO
IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_HealthProviderOrganisationPatient_PatientMaster]') AND parent_object_id = OBJECT_ID(N'[hips].[HealthProviderOrganisationPatient]'))
ALTER TABLE [hips].[HealthProviderOrganisationPatient]  WITH CHECK ADD  CONSTRAINT [FK_HealthProviderOrganisationPatient_PatientMaster] FOREIGN KEY([PatientMasterId])
REFERENCES [hips].[PatientMaster] ([PatientMasterId])
GO
IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_HealthProviderOrganisationPatient_PatientMaster]') AND parent_object_id = OBJECT_ID(N'[hips].[HealthProviderOrganisationPatient]'))
ALTER TABLE [hips].[HealthProviderOrganisationPatient] CHECK CONSTRAINT [FK_HealthProviderOrganisationPatient_PatientMaster]
GO

SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[hips].[HL7MessageLog]') AND type in (N'U'))
BEGIN
CREATE TABLE [hips].[HL7MessageLog](
	[HL7MessageLogId] [int] IDENTITY(1,1) NOT NULL,
	[HospitalId] [int] NULL,
	[HospitalPatientIdentifier] [varchar](20) NULL,
	[SendingApplication] [varchar](180) NULL,
	[SendingFacility] [varchar](180) NULL,
	[MessageControlId] [varchar](25) NULL,
	[DateTimeOfMessage] [datetime] NULL,
	[ShouldRetry] [bit] NOT NULL,
	[RetryCount] [int] NOT NULL,
	[FailureReason] [varchar](256) NULL,
	[QueueStatusId] [int] NOT NULL,
	[FullMessage] [varchar](max) NOT NULL,	
	[DateCreated] [datetime] NOT NULL,
	[UserCreated] [varchar](256) NOT NULL,
	[DateModified] [datetime] NOT NULL,
	[UserModified] [varchar](256) NOT NULL,
 CONSTRAINT [PK_HL7MessageLog] PRIMARY KEY CLUSTERED 
(
	[HL7MessageLogId] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
END
GO
SET ANSI_PADDING OFF
GO
IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_HL7MessageLog_Hospital]') AND parent_object_id = OBJECT_ID(N'[hips].[HL7MessageLog]'))
ALTER TABLE [hips].[HL7MessageLog]  WITH CHECK ADD  CONSTRAINT [FK_HL7MessageLog_Hospital] FOREIGN KEY([HospitalId])
REFERENCES [hips].[Hospital] ([HospitalId])
GO
IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_HL7MessageLog_Hospital]') AND parent_object_id = OBJECT_ID(N'[hips].[HL7MessageLog]'))
ALTER TABLE [hips].[HL7MessageLog] CHECK CONSTRAINT [FK_HL7MessageLog_Hospital]
GO
IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_HL7MessageLog_QueueStatus]') AND parent_object_id = OBJECT_ID(N'[hips].[HL7MessageLog]'))
ALTER TABLE [hips].[HL7MessageLog]  WITH CHECK ADD  CONSTRAINT [FK_HL7MessageLog_QueueStatus] FOREIGN KEY([QueueStatusId])
REFERENCES [hips].[QueueStatus] ([QueueStatusId])
GO
IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_HL7MessageLog_QueueStatus]') AND parent_object_id = OBJECT_ID(N'[hips].[HL7MessageLog]'))
ALTER TABLE [hips].[HL7MessageLog] CHECK CONSTRAINT [FK_HL7MessageLog_QueueStatus]
GO

SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[hips].[Hospital]') AND type in (N'U'))
BEGIN
CREATE TABLE [hips].[Hospital](
	[HospitalId] [int] IDENTITY(1,1) NOT NULL,
	[Description] [varchar](60) NOT NULL,
	[Name] [varchar](60) NULL,
	[HealthProviderOrganisationId] [int] NOT NULL,
	[AuthorisedEmployeeName] [varchar](100) NULL,
	[AuthorisedEmployeeUserId] [varchar](30) NULL,
	[Logo] [varbinary](max) NULL,
	[UploadDocumentMinimumAge] [int] NOT NULL,
	[DateCreated] [datetime] NOT NULL,
	[UserCreated] [varchar](256) NOT NULL,
	[DateModified] [datetime] NOT NULL,
	[UserModified] [varchar](256) NOT NULL,
 CONSTRAINT [PK_Hospital] PRIMARY KEY CLUSTERED 
(
	[HospitalId] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
END
GO
SET ANSI_PADDING OFF
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'Hospital', N'COLUMN',N'HospitalId'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Represents a hospital facility within the jurisdiction.
' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'Hospital', @level2type=N'COLUMN',@level2name=N'HospitalId'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'Hospital', N'COLUMN',N'Description'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'A well-known description of the hospital (e.g. RAH or Noarlunga)
' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'Hospital', @level2type=N'COLUMN',@level2name=N'Description'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'Hospital', N'COLUMN',N'Name'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The full name of the hospital (e.g. Royal Adelaide Hospital)
' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'Hospital', @level2type=N'COLUMN',@level2name=N'Name'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'Hospital', N'COLUMN',N'HealthProviderOrganisationId'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The HPI-O and related information that this hospital will use (depending on final HPI-O network structure).' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'Hospital', @level2type=N'COLUMN',@level2name=N'HealthProviderOrganisationId'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'Hospital', N'COLUMN',N'AuthorisedEmployeeName'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Name of the authorised employee for actions triggered by automatic processes, such as IHI/HPII searching and PCEHR advertised checking.' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'Hospital', @level2type=N'COLUMN',@level2name=N'AuthorisedEmployeeName'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'Hospital', N'COLUMN',N'AuthorisedEmployeeUserId'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Identifier of the authorised employee for actions triggered by automatic processes, such as IHI/HPII searching and PCEHR advertised checking.' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'Hospital', @level2type=N'COLUMN',@level2name=N'AuthorisedEmployeeUserId'
GO
IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_Hospital_HealthProviderOrganisation]') AND parent_object_id = OBJECT_ID(N'[hips].[Hospital]'))
ALTER TABLE [hips].[Hospital]  WITH CHECK ADD  CONSTRAINT [FK_Hospital_HealthProviderOrganisation] FOREIGN KEY([HealthProviderOrganisationId])
REFERENCES [hips].[HealthProviderOrganisation] ([HealthProviderOrganisationId])
GO
IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_Hospital_HealthProviderOrganisation]') AND parent_object_id = OBJECT_ID(N'[hips].[Hospital]'))
ALTER TABLE [hips].[Hospital] CHECK CONSTRAINT [FK_Hospital_HealthProviderOrganisation]
GO

SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[hips].[HospitalAddress]') AND type in (N'U'))
BEGIN
CREATE TABLE [hips].[HospitalAddress](
	[HospitalId] [int] NOT NULL,
	[AddressId] [int] NOT NULL,
	[DateCreated] [datetime] NOT NULL,
	[UserCreated] [varchar](256) NOT NULL,
	[DateModified] [datetime] NOT NULL,
	[UserModified] [varchar](256) NOT NULL,
 CONSTRAINT [PK_HospitalAddress] PRIMARY KEY CLUSTERED 
(
	[HospitalId] ASC,
	[AddressId] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
END
GO
SET ANSI_PADDING OFF
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'HospitalAddress', N'COLUMN',N'HospitalId'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Link to a hospital.' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'HospitalAddress', @level2type=N'COLUMN',@level2name=N'HospitalId'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'HospitalAddress', N'COLUMN',N'AddressId'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Link to an address for this hospital.' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'HospitalAddress', @level2type=N'COLUMN',@level2name=N'AddressId'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'HospitalAddress', NULL,NULL))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Links a hospital to multiple physical addresses, such as the street address and postal address.' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'HospitalAddress'
GO
IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_HospitalAddress_Address]') AND parent_object_id = OBJECT_ID(N'[hips].[HospitalAddress]'))
ALTER TABLE [hips].[HospitalAddress]  WITH CHECK ADD  CONSTRAINT [FK_HospitalAddress_Address] FOREIGN KEY([AddressId])
REFERENCES [hips].[Address] ([AddressId])
GO
IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_HospitalAddress_Address]') AND parent_object_id = OBJECT_ID(N'[hips].[HospitalAddress]'))
ALTER TABLE [hips].[HospitalAddress] CHECK CONSTRAINT [FK_HospitalAddress_Address]
GO
IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_HospitalAddress_Hospital]') AND parent_object_id = OBJECT_ID(N'[hips].[HospitalAddress]'))
ALTER TABLE [hips].[HospitalAddress]  WITH CHECK ADD  CONSTRAINT [FK_HospitalAddress_Hospital] FOREIGN KEY([HospitalId])
REFERENCES [hips].[Hospital] ([HospitalId])
GO
IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_HospitalAddress_Hospital]') AND parent_object_id = OBJECT_ID(N'[hips].[HospitalAddress]'))
ALTER TABLE [hips].[HospitalAddress] CHECK CONSTRAINT [FK_HospitalAddress_Hospital]
GO

SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[hips].[HospitalCode]') AND type in (N'U'))
BEGIN
CREATE TABLE [hips].[HospitalCode](
	[HospitalId] [int] NOT NULL,
	[CodeSystemId] [int] NOT NULL,
	[Code] [varchar](256) NOT NULL,
	[DateCreated] [datetime] NOT NULL,
	[UserCreated] [varchar](256) NOT NULL,
	[DateModified] [datetime] NOT NULL,
	[UserModified] [varchar](256) NOT NULL,
 CONSTRAINT [PK_HospitalCode] PRIMARY KEY CLUSTERED 
(
	[HospitalId] ASC,
	[CodeSystemId] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
END
GO
SET ANSI_PADDING OFF
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'HospitalCode', N'COLUMN',N'HospitalId'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Hospital' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'HospitalCode', @level2type=N'COLUMN',@level2name=N'HospitalId'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'HospitalCode', N'COLUMN',N'CodeSystemId'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Type of identifier' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'HospitalCode', @level2type=N'COLUMN',@level2name=N'CodeSystemId'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'HospitalCode', N'COLUMN',N'Code'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Identifier of the hospital' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'HospitalCode', @level2type=N'COLUMN',@level2name=N'Code'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'HospitalCode', NULL,NULL))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Links a hospital to multiple codes (identifiers), and a code to multiple hospitals. One of the codes that is linked is the HPI-O which may be shared between hospitals.' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'HospitalCode'
GO
IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_HospitalCode_CodeSystem]') AND parent_object_id = OBJECT_ID(N'[hips].[HospitalCode]'))
ALTER TABLE [hips].[HospitalCode]  WITH CHECK ADD  CONSTRAINT [FK_HospitalCode_CodeSystem] FOREIGN KEY([CodeSystemId])
REFERENCES [hips].[CodeSystem] ([CodeSystemId])
GO
IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_HospitalCode_CodeSystem]') AND parent_object_id = OBJECT_ID(N'[hips].[HospitalCode]'))
ALTER TABLE [hips].[HospitalCode] CHECK CONSTRAINT [FK_HospitalCode_CodeSystem]
GO
IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_HospitalCode_Hospital]') AND parent_object_id = OBJECT_ID(N'[hips].[HospitalCode]'))
ALTER TABLE [hips].[HospitalCode]  WITH CHECK ADD  CONSTRAINT [FK_HospitalCode_Hospital] FOREIGN KEY([HospitalId])
REFERENCES [hips].[Hospital] ([HospitalId])
GO
IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_HospitalCode_Hospital]') AND parent_object_id = OBJECT_ID(N'[hips].[HospitalCode]'))
ALTER TABLE [hips].[HospitalCode] CHECK CONSTRAINT [FK_HospitalCode_Hospital]
GO

SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[hips].[HospitalContact]') AND type in (N'U'))
BEGIN
CREATE TABLE [hips].[HospitalContact](
	[HospitalId] [int] NOT NULL,
	[ContactId] [int] NOT NULL,
	[DateCreated] [datetime] NOT NULL,
	[UserCreated] [varchar](256) NOT NULL,
	[DateModified] [datetime] NOT NULL,
	[UserModified] [varchar](256) NOT NULL,
 CONSTRAINT [PK_HospitalContact] PRIMARY KEY CLUSTERED 
(
	[HospitalId] ASC,
	[ContactId] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
END
GO
SET ANSI_PADDING OFF
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'HospitalContact', N'COLUMN',N'HospitalId'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Link to a hospital.
' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'HospitalContact', @level2type=N'COLUMN',@level2name=N'HospitalId'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'HospitalContact', N'COLUMN',N'ContactId'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Link to a single electronic contact number or address for this hospital' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'HospitalContact', @level2type=N'COLUMN',@level2name=N'ContactId'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'HospitalContact', NULL,NULL))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Links a hospital to multiple electronic contact numbers or addresses, such as the phone number and fax number.' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'HospitalContact'
GO
IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_HospitalContact_Hospital]') AND parent_object_id = OBJECT_ID(N'[hips].[HospitalContact]'))
ALTER TABLE [hips].[HospitalContact]  WITH CHECK ADD  CONSTRAINT [FK_HospitalContact_Hospital] FOREIGN KEY([HospitalId])
REFERENCES [hips].[Hospital] ([HospitalId])
GO
IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_HospitalContact_Hospital]') AND parent_object_id = OBJECT_ID(N'[hips].[HospitalContact]'))
ALTER TABLE [hips].[HospitalContact] CHECK CONSTRAINT [FK_HospitalContact_Hospital]
GO
IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_HospitalContact_HospitalContact]') AND parent_object_id = OBJECT_ID(N'[hips].[HospitalContact]'))
ALTER TABLE [hips].[HospitalContact]  WITH CHECK ADD  CONSTRAINT [FK_HospitalContact_HospitalContact] FOREIGN KEY([ContactId])
REFERENCES [hips].[Contact] ([ContactId])
GO
IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_HospitalContact_HospitalContact]') AND parent_object_id = OBJECT_ID(N'[hips].[HospitalContact]'))
ALTER TABLE [hips].[HospitalContact] CHECK CONSTRAINT [FK_HospitalContact_HospitalContact]
GO

SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[hips].[HospitalHealthProviderIndividual]') AND type in (N'U'))
BEGIN
CREATE TABLE [hips].[HospitalHealthProviderIndividual](
	[HospitalId] [int] NOT NULL,
	[HealthProviderIndividualId] [int] NOT NULL,
	[CisProviderIdentifier] [varchar](30) NULL,
	[PasProviderIdentifier] [varchar](30) NOT NULL,
	[DateCreated] [datetime] NOT NULL,
	[UserCreated] [varchar](256) NOT NULL,
	[DateModified] [datetime] NOT NULL,
	[UserModified] [varchar](256) NOT NULL,
 CONSTRAINT [PK_HospitalProvider_1] PRIMARY KEY CLUSTERED 
(
	[HospitalId] ASC,
	[HealthProviderIndividualId] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
END
GO
SET ANSI_PADDING OFF
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'HospitalHealthProviderIndividual', N'COLUMN',N'HospitalId'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Hospital in which an individual provider works' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'HospitalHealthProviderIndividual', @level2type=N'COLUMN',@level2name=N'HospitalId'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'HospitalHealthProviderIndividual', N'COLUMN',N'HealthProviderIndividualId'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Link to an individual healthcare provider who works in the hospital' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'HospitalHealthProviderIndividual', @level2type=N'COLUMN',@level2name=N'HealthProviderIndividualId'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'HospitalHealthProviderIndividual', N'COLUMN',N'CisProviderIdentifier'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Identifier of this provider allocated by the Clinical Information System (CIS) used at the hospital facility (e.g. Oacis User ID)' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'HospitalHealthProviderIndividual', @level2type=N'COLUMN',@level2name=N'CisProviderIdentifier'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'HospitalHealthProviderIndividual', N'COLUMN',N'PasProviderIdentifier'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Identifier of this provider allocated by the Patient Administration System (PAS) at the hospital facility (e.g. Homer Doctor Code)' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'HospitalHealthProviderIndividual', @level2type=N'COLUMN',@level2name=N'PasProviderIdentifier'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'HospitalHealthProviderIndividual', NULL,NULL))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Identifies an individual health provider working at a particular hospital. This is a many-to-many join table and uses a composite primary key.' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'HospitalHealthProviderIndividual'
GO
IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_HospitalHealthProviderIndividual_HealthProviderIndividual]') AND parent_object_id = OBJECT_ID(N'[hips].[HospitalHealthProviderIndividual]'))
ALTER TABLE [hips].[HospitalHealthProviderIndividual]  WITH CHECK ADD  CONSTRAINT [FK_HospitalHealthProviderIndividual_HealthProviderIndividual] FOREIGN KEY([HealthProviderIndividualId])
REFERENCES [hips].[HealthProviderIndividual] ([HealthProviderIndividualId])
GO
IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_HospitalHealthProviderIndividual_HealthProviderIndividual]') AND parent_object_id = OBJECT_ID(N'[hips].[HospitalHealthProviderIndividual]'))
ALTER TABLE [hips].[HospitalHealthProviderIndividual] CHECK CONSTRAINT [FK_HospitalHealthProviderIndividual_HealthProviderIndividual]
GO
IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_HospitalHealthProviderIndividual_Hospital]') AND parent_object_id = OBJECT_ID(N'[hips].[HospitalHealthProviderIndividual]'))
ALTER TABLE [hips].[HospitalHealthProviderIndividual]  WITH CHECK ADD  CONSTRAINT [FK_HospitalHealthProviderIndividual_Hospital] FOREIGN KEY([HospitalId])
REFERENCES [hips].[Hospital] ([HospitalId])
GO
IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_HospitalHealthProviderIndividual_Hospital]') AND parent_object_id = OBJECT_ID(N'[hips].[HospitalHealthProviderIndividual]'))
ALTER TABLE [hips].[HospitalHealthProviderIndividual] CHECK CONSTRAINT [FK_HospitalHealthProviderIndividual_Hospital]
GO

SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[hips].[HospitalPatient]') AND type in (N'U'))
BEGIN
CREATE TABLE [hips].[HospitalPatient](
	[PatientId] [int] IDENTITY(1,1) NOT NULL,
	[PatientMasterId] [int] NOT NULL,
	[HospitalId] [int] NOT NULL,
	[Mrn] [varchar](20) NOT NULL,
	[DateCreated] [datetime] NOT NULL,
	[UserCreated] [varchar](256) NOT NULL,
	[DateModified] [datetime] NOT NULL,
	[UserModified] [varchar](256) NOT NULL,
 CONSTRAINT [PK_Patient_1] PRIMARY KEY CLUSTERED 
(
	[PatientId] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
END
GO
SET ANSI_PADDING OFF
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'HospitalPatient', N'COLUMN',N'PatientId'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Patient record at a single hospital facility' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'HospitalPatient', @level2type=N'COLUMN',@level2name=N'PatientId'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'HospitalPatient', N'COLUMN',N'PatientMasterId'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Link to the enterprise patient master record.' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'HospitalPatient', @level2type=N'COLUMN',@level2name=N'PatientMasterId'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'HospitalPatient', N'COLUMN',N'HospitalId'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Link to the hospital facility.
' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'HospitalPatient', @level2type=N'COLUMN',@level2name=N'HospitalId'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'HospitalPatient', N'COLUMN',N'Mrn'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Identifier for the patient, allocated by the PAS at this hospital.' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'HospitalPatient', @level2type=N'COLUMN',@level2name=N'Mrn'
GO
IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_Patient_Hospital]') AND parent_object_id = OBJECT_ID(N'[hips].[HospitalPatient]'))
ALTER TABLE [hips].[HospitalPatient]  WITH CHECK ADD  CONSTRAINT [FK_Patient_Hospital] FOREIGN KEY([HospitalId])
REFERENCES [hips].[Hospital] ([HospitalId])
GO
IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_Patient_Hospital]') AND parent_object_id = OBJECT_ID(N'[hips].[HospitalPatient]'))
ALTER TABLE [hips].[HospitalPatient] CHECK CONSTRAINT [FK_Patient_Hospital]
GO
IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_Patient_PatientMaster]') AND parent_object_id = OBJECT_ID(N'[hips].[HospitalPatient]'))
ALTER TABLE [hips].[HospitalPatient]  WITH CHECK ADD  CONSTRAINT [FK_Patient_PatientMaster] FOREIGN KEY([PatientMasterId])
REFERENCES [hips].[PatientMaster] ([PatientMasterId])
GO
IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_Patient_PatientMaster]') AND parent_object_id = OBJECT_ID(N'[hips].[HospitalPatient]'))
ALTER TABLE [hips].[HospitalPatient] CHECK CONSTRAINT [FK_Patient_PatientMaster]
GO

SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[hips].[HospitalPatientHistory]') AND type in (N'U'))
BEGIN
CREATE TABLE [hips].[HospitalPatientHistory](
	[HospitalPatientHistoryId] [int] IDENTITY(1,1) NOT NULL,
	[HospitalPatientId] [int] NOT NULL,
	[FromPatientMasterId] [int] NOT NULL,
	[ToPatientMasterId] [int] NOT NULL,
	[HospitalId] [int] NOT NULL,
	[FromMrn] [varchar](20) NOT NULL,
	[ToMrn] [varchar](20) NOT NULL,
	[DateCreated] [datetime] NOT NULL,
	[UserCreated] [varchar](256) NOT NULL,
	[DateModified] [datetime] NOT NULL,
	[UserModified] [varchar](256) NOT NULL,
 CONSTRAINT [PK_HospitalPatientHistory_1] PRIMARY KEY CLUSTERED 
(
	[HospitalPatientHistoryId] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
END
GO
SET ANSI_PADDING OFF
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'HospitalPatientHistory', N'COLUMN',N'HospitalPatientHistoryId'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'History of changes to HospitalPatient record made during merges or moves' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'HospitalPatientHistory', @level2type=N'COLUMN',@level2name=N'HospitalPatientHistoryId'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'HospitalPatientHistory', N'COLUMN',N'HospitalPatientHistoryId'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Identifier of the HospitalPatient record in question' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'HospitalPatientHistory', @level2type=N'COLUMN',@level2name=N'HospitalPatientId'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'HospitalPatientHistory', N'COLUMN',N'FromPatientMasterId'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Previously linked enterprise patient master record.' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'HospitalPatientHistory', @level2type=N'COLUMN',@level2name=N'FromPatientMasterId'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'HospitalPatientHistory', N'COLUMN',N'ToPatientMasterId'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Newly linked enterprise patient master record.' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'HospitalPatientHistory', @level2type=N'COLUMN',@level2name=N'ToPatientMasterId'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'HospitalPatientHistory', N'COLUMN',N'HospitalId'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Link to the hospital facility.' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'HospitalPatientHistory', @level2type=N'COLUMN',@level2name=N'HospitalId'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'HospitalPatientHistory', N'COLUMN',N'FromMrn'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Previous identifier for the patient, allocated by the PAS at this hospital.' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'HospitalPatientHistory', @level2type=N'COLUMN',@level2name=N'FromMrn'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'HospitalPatientHistory', N'COLUMN',N'ToMrn'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'New identifier for the patient, allocated by the PAS at this hospital.' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'HospitalPatientHistory', @level2type=N'COLUMN',@level2name=N'ToMrn'
GO
IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_HospitalPatientHistory_HospitalPatient]') AND parent_object_id = OBJECT_ID(N'[hips].[HospitalPatientHistory]'))
ALTER TABLE [hips].[HospitalPatientHistory]  WITH CHECK ADD  CONSTRAINT [FK_HospitalPatientHistory_HospitalPatient] FOREIGN KEY([HospitalPatientId])
REFERENCES [hips].[HospitalPatient] ([PatientId])
GO
IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_HospitalPatientHistory_HospitalPatient]') AND parent_object_id = OBJECT_ID(N'[hips].[HospitalPatientHistory]'))
ALTER TABLE [hips].[HospitalPatientHistory] CHECK CONSTRAINT [FK_HospitalPatientHistory_HospitalPatient]
GO
IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_HospitalPatientHistory_Hospital]') AND parent_object_id = OBJECT_ID(N'[hips].[HospitalPatientHistory]'))
ALTER TABLE [hips].[HospitalPatientHistory]  WITH CHECK ADD  CONSTRAINT [FK_HospitalPatientHistory_Hospital] FOREIGN KEY([HospitalId])
REFERENCES [hips].[Hospital] ([HospitalId])
GO
IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_HospitalPatientHistory_Hospital]') AND parent_object_id = OBJECT_ID(N'[hips].[HospitalPatientHistory]'))
ALTER TABLE [hips].[HospitalPatientHistory] CHECK CONSTRAINT [FK_HospitalPatientHistory_Hospital]
GO
IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_HospitalPatientHistory_FromPatientMaster]') AND parent_object_id = OBJECT_ID(N'[hips].[HospitalPatientHistory]'))
ALTER TABLE [hips].[HospitalPatientHistory]  WITH CHECK ADD  CONSTRAINT [FK_HospitalPatientHistory_FromPatientMaster] FOREIGN KEY([FromPatientMasterId])
REFERENCES [hips].[PatientMaster] ([PatientMasterId])
GO
IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_HospitalPatientHistory_FromPatientMaster]') AND parent_object_id = OBJECT_ID(N'[hips].[HospitalPatientHistory]'))
ALTER TABLE [hips].[HospitalPatientHistory] CHECK CONSTRAINT [FK_HospitalPatientHistory_FromPatientMaster]
GO
IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_HospitalPatientHistory_ToPatientMaster]') AND parent_object_id = OBJECT_ID(N'[hips].[HospitalPatientHistory]'))
ALTER TABLE [hips].[HospitalPatientHistory]  WITH CHECK ADD  CONSTRAINT [FK_HospitalPatientHistory_ToPatientMaster] FOREIGN KEY([ToPatientMasterId])
REFERENCES [hips].[PatientMaster] ([PatientMasterId])
GO
IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_HospitalPatientHistory_ToPatientMaster]') AND parent_object_id = OBJECT_ID(N'[hips].[HospitalPatientHistory]'))
ALTER TABLE [hips].[HospitalPatientHistory] CHECK CONSTRAINT [FK_HospitalPatientHistory_ToPatientMaster]
GO

SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[hips].[HpiiLookupAudit]') AND type in (N'U'))
BEGIN
CREATE TABLE [hips].[HpiiLookupAudit](
	[HpiiLookupAuditId] [int] IDENTITY(1,1) NOT NULL,
	[HpiiNumber] [varchar](50) NULL,
	[HpiiStatusId] [int] NULL,
	[RegistrationId] [varchar](20) NULL,
	[FamilyName] [varchar](40) NOT NULL,
	[GivenNames] [varchar](500) NULL,
	[DateOfBirth] [datetime] NULL,
	[SexId] [int] NULL,
	[AustralianStateId] [int] NULL,
	[Postcode] [varchar](4) NULL,
	[CountryCode] [varchar](4) NULL,
	[BatchItemId] [int] NULL,
	[BatchIdentifier] [varchar](36) NULL,
	[Message] [varchar](200) NULL,
	[OperatorHpiI] [varchar](16) NULL,
	[HpiO] [varchar](16) NOT NULL,
	[Operator] [varchar](100) NOT NULL,
	[IdentifierType] [varchar](40) NULL,
	[IdentifierValue] [varchar](128) NULL,
	[HiWebServiceName] [varchar](40) NOT NULL,
	[HiWebServiceVersion] [varchar](10) NOT NULL,
	[ServiceMessageRequestID] [varchar](50) NULL,
	[ServiceMessageResponseID] [varchar](50) NULL,
	[Request] [xml] NULL,
	[Response] [xml] NULL,
	[DateCreated] [datetime] NOT NULL,
	[UserCreated] [varchar](256) NOT NULL,
	[DateModified] [datetime] NOT NULL,
	[UserModified] [varchar](256) NOT NULL,
 CONSTRAINT [PK_HpiiLookupAudit] PRIMARY KEY CLUSTERED 
(
	[HpiiLookupAuditId] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_PADDING OFF
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'HpiiLookupAudit', N'COLUMN',N'HpiiNumber'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'HPII Number of the provider used in the Search for an HPII' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'HpiiLookupAudit', @level2type=N'COLUMN',@level2name=N'HpiiNumber'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'HpiiLookupAudit', N'COLUMN',N'HpiiStatusId'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'HPII Status of the returned HPII' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'HpiiLookupAudit', @level2type=N'COLUMN',@level2name=N'HpiiStatusId'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'HpiiLookupAudit', N'COLUMN',N'RegistrationId'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Registration Number of the provider used in the Search for an HPII' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'HpiiLookupAudit', @level2type=N'COLUMN',@level2name=N'RegistrationId'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'HpiiLookupAudit', N'COLUMN',N'FamilyName'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Family Name of the provider used in the Search for an HPII' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'HpiiLookupAudit', @level2type=N'COLUMN',@level2name=N'FamilyName'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'HpiiLookupAudit', N'COLUMN',N'GivenNames'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Given Name of the provider used in the Search for an HPII' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'HpiiLookupAudit', @level2type=N'COLUMN',@level2name=N'GivenNames'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'HpiiLookupAudit', N'COLUMN',N'DateOfBirth'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Date of birth of the provider used in the Search for an HPII' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'HpiiLookupAudit', @level2type=N'COLUMN',@level2name=N'DateOfBirth'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'HpiiLookupAudit', N'COLUMN',N'SexId'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Gender Identifier used in the Search for an HPII' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'HpiiLookupAudit', @level2type=N'COLUMN',@level2name=N'SexId'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'HpiiLookupAudit', N'COLUMN',N'AustralianStateId'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Australian State Identifier used in the Search for an HPII' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'HpiiLookupAudit', @level2type=N'COLUMN',@level2name=N'AustralianStateId'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'HpiiLookupAudit', N'COLUMN',N'Postcode'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Postcode used in the Search for an HPII' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'HpiiLookupAudit', @level2type=N'COLUMN',@level2name=N'Postcode'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'HpiiLookupAudit', N'COLUMN',N'CountryCode'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Country identifier used in the Search for an HPII' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'HpiiLookupAudit', @level2type=N'COLUMN',@level2name=N'CountryCode'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'HpiiLookupAudit', N'COLUMN',N'BatchItemId'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Singular identifier of a request within a batch ' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'HpiiLookupAudit', @level2type=N'COLUMN',@level2name=N'BatchItemId'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'HpiiLookupAudit', N'COLUMN',N'BatchIdentifier'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Batch Identifier for the grouped batch request' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'HpiiLookupAudit', @level2type=N'COLUMN',@level2name=N'BatchIdentifier'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'HpiiLookupAudit', N'COLUMN',N'Message'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Error or Warning Messages returned from the Hi Service ' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'HpiiLookupAudit', @level2type=N'COLUMN',@level2name=N'Message'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'HpiiLookupAudit', N'COLUMN',N'OperatorHpiI'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'HPII of the individual making the request' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'HpiiLookupAudit', @level2type=N'COLUMN',@level2name=N'OperatorHpiI'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'HpiiLookupAudit', N'COLUMN',N'HpiO'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'HPIO of the organisation making the request' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'HpiiLookupAudit', @level2type=N'COLUMN',@level2name=N'HpiO'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'HpiiLookupAudit', N'COLUMN',N'Operator'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Authorised operator that performed the request' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'HpiiLookupAudit', @level2type=N'COLUMN',@level2name=N'Operator'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'HpiiLookupAudit', N'COLUMN',N'IdentifierType'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Local Identifier Type of associated local record identifiers' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'HpiiLookupAudit', @level2type=N'COLUMN',@level2name=N'IdentifierType'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'HpiiLookupAudit', N'COLUMN',N'IdentifierValue'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Local Identifier Value of associated local record identifiers' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'HpiiLookupAudit', @level2type=N'COLUMN',@level2name=N'IdentifierValue'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'HpiiLookupAudit', N'COLUMN',N'HiWebServiceName'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Name of the HI Web Service called ' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'HpiiLookupAudit', @level2type=N'COLUMN',@level2name=N'HiWebServiceName'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'HpiiLookupAudit', N'COLUMN',N'HiWebServiceVersion'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Version of the HI Web Service called ' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'HpiiLookupAudit', @level2type=N'COLUMN',@level2name=N'HiWebServiceVersion'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'HpiiLookupAudit', N'COLUMN',N'ServiceMessageRequestID'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Service Message Request ID for the Hi Service' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'HpiiLookupAudit', @level2type=N'COLUMN',@level2name=N'ServiceMessageRequestID'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'HpiiLookupAudit', N'COLUMN',N'ServiceMessageResponseID'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Service Message Response ID for the Hi Service' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'HpiiLookupAudit', @level2type=N'COLUMN',@level2name=N'ServiceMessageResponseID'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'HpiiLookupAudit', N'COLUMN',N'Request'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Request XML for the Hi Service' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'HpiiLookupAudit', @level2type=N'COLUMN',@level2name=N'Request'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'HpiiLookupAudit', N'COLUMN',N'Response'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Response XML from the Hi Service' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'HpiiLookupAudit', @level2type=N'COLUMN',@level2name=N'Response'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'HpiiLookupAudit', N'COLUMN',N'DateCreated'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Date that this patient record was inserted into the table' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'HpiiLookupAudit', @level2type=N'COLUMN',@level2name=N'DateCreated'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'HpiiLookupAudit', N'COLUMN',N'UserCreated'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'User account that inserted the record' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'HpiiLookupAudit', @level2type=N'COLUMN',@level2name=N'UserCreated'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'HpiiLookupAudit', N'COLUMN',N'DateModified'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Date and time that this record was last modified (or as inserted)' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'HpiiLookupAudit', @level2type=N'COLUMN',@level2name=N'DateModified'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'HpiiLookupAudit', N'COLUMN',N'UserModified'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The account of the user that last modified (or inserted) this record' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'HpiiLookupAudit', @level2type=N'COLUMN',@level2name=N'UserModified'
GO


IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_HpiiLookupAudit_Sex]') AND parent_object_id = OBJECT_ID(N'[hips].[HpiiLookupAudit]'))
ALTER TABLE [hips].[HpiiLookupAudit]  WITH CHECK ADD  CONSTRAINT [FK_HpiiLookupAudit_Sex] FOREIGN KEY([SexId])
REFERENCES [hips].[Sex] ([SexId])
GO
IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_HpiiLookupAudit_Sex]') AND parent_object_id = OBJECT_ID(N'[hips].[HpiiLookupAudit]'))
ALTER TABLE [hips].[HpiiLookupAudit] CHECK CONSTRAINT [FK_HpiiLookupAudit_Sex]
GO

IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_HpiiLookupAudit_State]') AND parent_object_id = OBJECT_ID(N'[hips].[HpiiLookupAudit]'))
ALTER TABLE [hips].[HpiiLookupAudit]  WITH CHECK ADD  CONSTRAINT [FK_HpiiLookupAudit_State] FOREIGN KEY([AustralianStateId])
REFERENCES [hips].[State] ([StateId])
GO
IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_HpiiLookupAudit_State]') AND parent_object_id = OBJECT_ID(N'[hips].[HpiiLookupAudit]'))
ALTER TABLE [hips].[HpiiLookupAudit] CHECK CONSTRAINT [FK_HpiiLookupAudit_State]
GO

IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_HpiiLookupAudit_Status]') AND parent_object_id = OBJECT_ID(N'[hips].[HpiiLookupAudit]'))
ALTER TABLE [hips].[HpiiLookupAudit]  WITH CHECK ADD  CONSTRAINT [FK_HpiiLookupAudit_Status] FOREIGN KEY([HpiiStatusId])
REFERENCES [hips].[HpiiStatus] ([HpiiStatusId])
GO
IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_HpiiLookupAudit_Status]') AND parent_object_id = OBJECT_ID(N'[hips].[HpiiLookupAudit]'))
ALTER TABLE [hips].[HpiiLookupAudit] CHECK CONSTRAINT [FK_HpiiLookupAudit_Status]
GO

SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[hips].[HpiiStatus]') AND type in (N'U'))
BEGIN
CREATE TABLE [hips].[HpiiStatus](
	[HpiiStatusId] [int] NOT NULL,
	[Description] [varchar](50) NOT NULL,
	[DateCreated] [datetime] NOT NULL,
	[UserCreated] [varchar](256) NOT NULL,
	[DateModified] [datetime] NOT NULL,
	[UserModified] [varchar](256) NOT NULL,
 CONSTRAINT [PK_HpiiStatus] PRIMARY KEY CLUSTERED 
(
	[HpiiStatusId] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
END
GO
SET ANSI_PADDING OFF
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'HpiiStatus', N'COLUMN',N'HpiiStatusId'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Identifies the IHI status.' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'HpiiStatus', @level2type=N'COLUMN',@level2name=N'HpiiStatusId'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'HpiiStatus', N'COLUMN',N'Description'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Description (e.g. Active, Undefined, Retired or Deactivated)' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'HpiiStatus', @level2type=N'COLUMN',@level2name=N'Description'
GO

SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[hips].[IhiLookupAlert]') AND type in (N'U'))
BEGIN
CREATE TABLE [hips].[IhiLookupAlert](
	[IhiLookupAlertId] [int] IDENTITY(1,1) NOT NULL,
	[PatientMasterId] [int] NOT NULL,
	[Message] [varchar](512) NOT NULL,
	[Request] [xml] NULL,
	[Response] [xml] NULL,
	[DateModified] [datetime] NOT NULL,
	[UserModified] [varchar](256) NOT NULL,
	[DateCreated] [datetime] NOT NULL,
	[UserCreated] [varchar](256) NOT NULL,
 CONSTRAINT [PK_IhiLookupAlert] PRIMARY KEY CLUSTERED 
(
	[IhiLookupAlertId] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
END
GO
SET ANSI_PADDING OFF
GO
IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_IhiLookupAlert_PatientMaster]') AND parent_object_id = OBJECT_ID(N'[hips].[IhiLookupAlert]'))
ALTER TABLE [hips].[IhiLookupAlert]  WITH CHECK ADD  CONSTRAINT [FK_IhiLookupAlert_PatientMaster] FOREIGN KEY([PatientMasterId])
REFERENCES [hips].[PatientMaster] ([PatientMasterId])
GO
IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_IhiLookupAlert_PatientMaster]') AND parent_object_id = OBJECT_ID(N'[hips].[IhiLookupAlert]'))
ALTER TABLE [hips].[IhiLookupAlert] CHECK CONSTRAINT [FK_IhiLookupAlert_PatientMaster]
GO

SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[hips].[IhiLookupAudit]') AND type in (N'U'))
BEGIN
CREATE TABLE [hips].[IhiLookupAudit](
	[IhiLookupAuditId] [int] IDENTITY(1,1) NOT NULL,
	[PatientMasterId] [int] NOT NULL,
	[SequenceNumber] [int] NOT NULL,
	[IhiNumber] [varchar](50) NULL,
	[IhiStatus] [int] NOT NULL,
	[IhiRecordStatus] [int] NOT NULL,
	[FamilyName] [varchar](80) NOT NULL,
	[GivenName] [varchar](80) NOT NULL,
	[SexId] [int] NOT NULL,
	[DateOfBirth] [datetime] NOT NULL,
	[MedicareNumber] [varchar](12) NULL,
	[DvaNumber] [varchar](18) NULL,
	[Message] [varchar](200) NULL,
	[HpiI] [varchar](16) NULL,
	[HpiO] [varchar](16) NOT NULL,
	[Operator] [varchar](100) NOT NULL,
	[Request] [xml] NULL,
	[Response] [xml] NULL,
	[DateCreated] [datetime] NOT NULL,
	[UserCreated] [varchar](256) NOT NULL,
	[DateModified] [datetime] NOT NULL,
	[UserModified] [varchar](256) NOT NULL,
 CONSTRAINT [PK_IhiLookupAudit] PRIMARY KEY CLUSTERED 
(
	[IhiLookupAuditId] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
END
GO
SET ANSI_PADDING OFF
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'IhiLookupAudit', N'COLUMN',N'DateCreated'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Date that this patient record was inserted into the table' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'IhiLookupAudit', @level2type=N'COLUMN',@level2name=N'DateCreated'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'IhiLookupAudit', N'COLUMN',N'UserCreated'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'User account that inserted the record' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'IhiLookupAudit', @level2type=N'COLUMN',@level2name=N'UserCreated'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'IhiLookupAudit', N'COLUMN',N'DateModified'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Date and time that this record was last modified (or as inserted)' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'IhiLookupAudit', @level2type=N'COLUMN',@level2name=N'DateModified'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'IhiLookupAudit', N'COLUMN',N'UserModified'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The account of the user that last modified (or inserted) this record' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'IhiLookupAudit', @level2type=N'COLUMN',@level2name=N'UserModified'
GO
IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_IhiLookupAudit_IhiRecordStatus]') AND parent_object_id = OBJECT_ID(N'[hips].[IhiLookupAudit]'))
ALTER TABLE [hips].[IhiLookupAudit]  WITH CHECK ADD  CONSTRAINT [FK_IhiLookupAudit_IhiRecordStatus] FOREIGN KEY([IhiRecordStatus])
REFERENCES [hips].[IhiRecordStatus] ([IhiRecordStatusId])
GO
IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_IhiLookupAudit_IhiRecordStatus]') AND parent_object_id = OBJECT_ID(N'[hips].[IhiLookupAudit]'))
ALTER TABLE [hips].[IhiLookupAudit] CHECK CONSTRAINT [FK_IhiLookupAudit_IhiRecordStatus]
GO
IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_IhiLookupAudit_IhiStatus]') AND parent_object_id = OBJECT_ID(N'[hips].[IhiLookupAudit]'))
ALTER TABLE [hips].[IhiLookupAudit]  WITH CHECK ADD  CONSTRAINT [FK_IhiLookupAudit_IhiStatus] FOREIGN KEY([IhiStatus])
REFERENCES [hips].[IhiStatus] ([IhiStatusId])
GO
IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_IhiLookupAudit_IhiStatus]') AND parent_object_id = OBJECT_ID(N'[hips].[IhiLookupAudit]'))
ALTER TABLE [hips].[IhiLookupAudit] CHECK CONSTRAINT [FK_IhiLookupAudit_IhiStatus]
GO
IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_IhiLookupAudit_PatientMaster]') AND parent_object_id = OBJECT_ID(N'[hips].[IhiLookupAudit]'))
ALTER TABLE [hips].[IhiLookupAudit]  WITH CHECK ADD  CONSTRAINT [FK_IhiLookupAudit_PatientMaster] FOREIGN KEY([PatientMasterId])
REFERENCES [hips].[PatientMaster] ([PatientMasterId])
GO
IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_IhiLookupAudit_PatientMaster]') AND parent_object_id = OBJECT_ID(N'[hips].[IhiLookupAudit]'))
ALTER TABLE [hips].[IhiLookupAudit] CHECK CONSTRAINT [FK_IhiLookupAudit_PatientMaster]
GO
IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_IhiLookupAudit_Sex]') AND parent_object_id = OBJECT_ID(N'[hips].[IhiLookupAudit]'))
ALTER TABLE [hips].[IhiLookupAudit]  WITH CHECK ADD  CONSTRAINT [FK_IhiLookupAudit_Sex] FOREIGN KEY([SexId])
REFERENCES [hips].[Sex] ([SexId])
GO
IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_IhiLookupAudit_Sex]') AND parent_object_id = OBJECT_ID(N'[hips].[IhiLookupAudit]'))
ALTER TABLE [hips].[IhiLookupAudit] CHECK CONSTRAINT [FK_IhiLookupAudit_Sex]
GO

SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[hips].[IhiRecordStatus]') AND type in (N'U'))
BEGIN
CREATE TABLE [hips].[IhiRecordStatus](
	[IhiRecordStatusId] [int] NOT NULL,
	[Description] [varchar](50) NOT NULL,
	[DateCreated] [datetime] NOT NULL,
	[UserCreated] [varchar](256) NOT NULL,
	[DateModified] [datetime] NOT NULL,
	[UserModified] [varchar](256) NOT NULL,
 CONSTRAINT [PK_IhiRecordStatus] PRIMARY KEY CLUSTERED 
(
	[IhiRecordStatusId] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
END
GO
SET ANSI_PADDING OFF
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'IhiRecordStatus', N'COLUMN',N'IhiRecordStatusId'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Identifies the IHI record status.' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'IhiRecordStatus', @level2type=N'COLUMN',@level2name=N'IhiRecordStatusId'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'IhiRecordStatus', N'COLUMN',N'Description'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Description (e.g. Verified, Unverified, Provisional)' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'IhiRecordStatus', @level2type=N'COLUMN',@level2name=N'Description'
GO

SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[hips].[IhiStatus]') AND type in (N'U'))
BEGIN
CREATE TABLE [hips].[IhiStatus](
	[IhiStatusId] [int] NOT NULL,
	[Description] [varchar](50) NOT NULL,
	[DateCreated] [datetime] NOT NULL,
	[UserCreated] [varchar](256) NOT NULL,
	[DateModified] [datetime] NOT NULL,
	[UserModified] [varchar](256) NOT NULL,
 CONSTRAINT [PK_IhiStatus] PRIMARY KEY CLUSTERED 
(
	[IhiStatusId] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
END
GO
SET ANSI_PADDING OFF
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'IhiStatus', N'COLUMN',N'IhiStatusId'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Identifies the IHI status.' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'IhiStatus', @level2type=N'COLUMN',@level2name=N'IhiStatusId'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'IhiStatus', N'COLUMN',N'Description'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Description (e.g. Active, Deceased, Retired, Expired, Resolved, Potential Duplicate or  Potential Replica)' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'IhiStatus', @level2type=N'COLUMN',@level2name=N'Description'
GO

SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[hips].[LevelType]') AND type in (N'U'))
BEGIN
CREATE TABLE [hips].[LevelType](
	[LevelTypeId] [int] IDENTITY(1,1) NOT NULL,
	[Code] [char](4) NOT NULL,
	[Description] [varchar](256) NOT NULL,
	[DateCreated] [datetime] NOT NULL,
	[UserCreated] [varchar](256) NOT NULL,
	[DateModified] [datetime] NOT NULL,
	[UserModified] [varchar](256) NOT NULL,
 CONSTRAINT [PK_LevelType] PRIMARY KEY CLUSTERED 
(
	[LevelTypeId] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
END
GO
SET ANSI_PADDING OFF
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'LevelType', N'COLUMN',N'LevelTypeId'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Identifies a LevelType.' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'LevelType', @level2type=N'COLUMN',@level2name=N'LevelTypeId'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'LevelType', N'COLUMN',N'Code'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'ABS SACC (4 digits)' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'LevelType', @level2type=N'COLUMN',@level2name=N'Code'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'LevelType', N'COLUMN',N'Description'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Description from ABS SACC' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'LevelType', @level2type=N'COLUMN',@level2name=N'Description'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'LevelType', N'COLUMN',N'DateCreated'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Date and Time the record was created' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'LevelType', @level2type=N'COLUMN',@level2name=N'DateCreated'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'LevelType', N'COLUMN',N'UserCreated'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'User that created the record' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'LevelType', @level2type=N'COLUMN',@level2name=N'UserCreated'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'LevelType', N'COLUMN',N'DateModified'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Date and Time the record was modified' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'LevelType', @level2type=N'COLUMN',@level2name=N'DateModified'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'LevelType', N'COLUMN',N'UserModified'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'User that modified the record' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'LevelType', @level2type=N'COLUMN',@level2name=N'UserModified'
GO

SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[hips].[LevelTypeCode]') AND type in (N'U'))
BEGIN
CREATE TABLE [hips].[LevelTypeCode](
	[LevelTypeId] [int] NOT NULL,
	[CodeSystemId] [int] NOT NULL,
	[DateCreated] [datetime] NOT NULL,
	[UserCreated] [varchar](256) NOT NULL,
	[DateModified] [datetime] NOT NULL,
	[UserModified] [varchar](256) NOT NULL,
 CONSTRAINT [PK_LevelTypeCode] PRIMARY KEY CLUSTERED 
(
	[LevelTypeId] ASC,
	[CodeSystemId] ASC  
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
END
GO
SET ANSI_PADDING OFF
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'LevelTypeCode', N'COLUMN',N'LevelTypeId'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'LevelType' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'LevelTypeCode', @level2type=N'COLUMN',@level2name=N'LevelTypeId'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'LevelTypeCode', N'COLUMN',N'CodeSystemId'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Type of identifier' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'LevelTypeCode', @level2type=N'COLUMN',@level2name=N'CodeSystemId'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'LevelTypeCode', N'COLUMN',N'DateCreated'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Date and Time the record was created' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'LevelTypeCode', @level2type=N'COLUMN',@level2name=N'DateCreated'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'LevelTypeCode', N'COLUMN',N'UserCreated'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'User that created the record' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'LevelTypeCode', @level2type=N'COLUMN',@level2name=N'UserCreated'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'LevelTypeCode', N'COLUMN',N'DateModified'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Date and Time the record was modified' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'LevelTypeCode', @level2type=N'COLUMN',@level2name=N'DateModified'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'LevelTypeCode', N'COLUMN',N'UserModified'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'User that modified the record' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'LevelTypeCode', @level2type=N'COLUMN',@level2name=N'UserModified'
GO
IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_LevelTypeCode_CodeSystem]') AND parent_object_id = OBJECT_ID(N'[hips].[LevelTypeCode]'))
ALTER TABLE [hips].[LevelTypeCode]  WITH CHECK ADD  CONSTRAINT [FK_LevelTypeCode_CodeSystem] FOREIGN KEY([CodeSystemId])
REFERENCES [hips].[CodeSystem] ([CodeSystemId])
GO
IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_LevelTypeCode_CodeSystem]') AND parent_object_id = OBJECT_ID(N'[hips].[LevelTypeCode]'))
ALTER TABLE [hips].[LevelTypeCode] CHECK CONSTRAINT [FK_LevelTypeCode_CodeSystem]
GO
IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_LevelTypeCode_LevelType]') AND parent_object_id = OBJECT_ID(N'[hips].[LevelTypeCode]'))
ALTER TABLE [hips].[LevelTypeCode]  WITH CHECK ADD  CONSTRAINT [FK_LevelTypeCode_LevelType] FOREIGN KEY([LevelTypeId])
REFERENCES [hips].[LevelType] ([LevelTypeId])
GO
IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_LevelTypeCode_LevelType]') AND parent_object_id = OBJECT_ID(N'[hips].[LevelTypeCode]'))
ALTER TABLE [hips].[LevelTypeCode] CHECK CONSTRAINT [FK_LevelTypeCode_LevelType]
GO

SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[hips].[LogMessage]') AND type in (N'U'))
BEGIN
CREATE TABLE [hips].[LogMessage](
	[LogMessageId] [int] NOT NULL,
	[Description] [varchar](256) NOT NULL,
	[Method] [varchar](50) NOT NULL,
    [Class] [varchar](50) NOT NULL,
	[DateCreated] [datetime] NOT NULL,
	[UserCreated] [varchar](256) NOT NULL,
	[DateModified] [datetime] NOT NULL,
	[UserModified] [varchar](256) NOT NULL,
 CONSTRAINT [PK_LogMessage] PRIMARY KEY CLUSTERED 
(
	[LogMessageId] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
END
GO
SET ANSI_PADDING OFF
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'LogMessage', N'COLUMN',N'LogMessageId'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Identifies the log message.' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'LogMessage', @level2type=N'COLUMN',@level2name=N'LogMessageId'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'LogMessage', N'COLUMN',N'Description'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Description of the log message' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'LogMessage', @level2type=N'COLUMN',@level2name=N'Description'
GO

SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[hips].[MedicareExclusion]') AND type in (N'U'))
BEGIN
CREATE TABLE [hips].[MedicareExclusion](
	[MedicareExclusionId] [int] IDENTITY(1,1) NOT NULL,
	[MedicareNumber] [varchar](10) NOT NULL,
	[Description] [varchar](100) NOT NULL,
	[DateCreated] [datetime] NOT NULL,
	[UserCreated] [varchar](256) NOT NULL,
	[DateModified] [datetime] NOT NULL,
	[UserModified] [varchar](256) NOT NULL,
 CONSTRAINT [PK_MedicareExclusion] PRIMARY KEY CLUSTERED 
(
	[MedicareExclusionId] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
END
GO
SET ANSI_PADDING OFF
GO

SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[hips].[ModeOfSeparation]') AND type in (N'U'))
BEGIN
CREATE TABLE [hips].[ModeOfSeparation](
	[ModeOfSeparationId] [int] NOT NULL,
	[Description] [varchar](256) NOT NULL,
	[DateCreated] [datetime] NOT NULL,
	[UserCreated] [varchar](256) NOT NULL,
	[DateModified] [datetime] NOT NULL,
	[UserModified] [varchar](256) NOT NULL,
 CONSTRAINT [PK_ModeOfSeparation] PRIMARY KEY CLUSTERED 
(
	[ModeOfSeparationId] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
END
GO
SET ANSI_PADDING OFF
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'ModeOfSeparation', NULL,NULL))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Type of discharge and place to which the patient is discharged.' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'ModeOfSeparation'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'ModeOfSeparation', N'COLUMN',N'ModeOfSeparationId'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Identifies the mode of separation.' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'ModeOfSeparation', @level2type=N'COLUMN',@level2name=N'ModeOfSeparationId'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'ModeOfSeparation', N'COLUMN',N'Description'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Description of the mode of separation.' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'ModeOfSeparation', @level2type=N'COLUMN',@level2name=N'Description'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'ModeOfSeparation', N'COLUMN',N'DateCreated'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Date that this patient record was inserted into the table' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'ModeOfSeparation', @level2type=N'COLUMN',@level2name=N'DateCreated'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'ModeOfSeparation', N'COLUMN',N'UserCreated'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'User account that inserted the record' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'ModeOfSeparation', @level2type=N'COLUMN',@level2name=N'UserCreated'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'ModeOfSeparation', N'COLUMN',N'DateModified'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Date and time that this record was last modified (or as inserted)' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'ModeOfSeparation', @level2type=N'COLUMN',@level2name=N'DateModified'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'ModeOfSeparation', N'COLUMN',N'UserModified'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The account of the user that last modified (or inserted) this record' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'ModeOfSeparation', @level2type=N'COLUMN',@level2name=N'UserModified'
GO

SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[hips].[MonitorTab]') AND type in (N'U'))
BEGIN
CREATE TABLE [hips].[MonitorTab](
	[MonitorTabId] [int] NOT NULL,
	[Description] [varchar](256) NOT NULL,
	[DateCreated] [datetime] NOT NULL,
	[UserCreated] [varchar](256) NOT NULL,
	[DateModified] [datetime] NOT NULL,
	[UserModified] [varchar](256) NOT NULL,
 CONSTRAINT [PK_MonitorTab] PRIMARY KEY CLUSTERED 
(
	[MonitorTabId] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
END
GO
SET ANSI_PADDING OFF
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'MonitorTab', N'COLUMN',N'MonitorTabId'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Identifies the monitor tab.' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'MonitorTab', @level2type=N'COLUMN',@level2name=N'MonitorTabId'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'MonitorTab', N'COLUMN',N'Description'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Description of the monitor tab' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'MonitorTab', @level2type=N'COLUMN',@level2name=N'Description'
GO

SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[hips].[MonitorTabMessage]') AND type in (N'U'))
BEGIN
CREATE TABLE [hips].[MonitorTabMessage](
	[MonitorTabId] [int] NOT NULL,
	[LogMessageId] [int] NOT NULL,
	[DateCreated] [datetime] NOT NULL,
	[UserCreated] [varchar](256) NOT NULL,
	[DateModified] [datetime] NOT NULL,
	[UserModified] [varchar](256) NOT NULL,
 CONSTRAINT [PK_MonitorTabMessage] PRIMARY KEY CLUSTERED 
(
	[MonitorTabId] ASC
	,[LogMessageId] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
END
GO
SET ANSI_PADDING OFF
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'MonitorTabMessage', N'COLUMN',N'MonitorTabId'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Link to the monitor tab.' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'MonitorTabMessage', @level2type=N'COLUMN',@level2name=N'MonitorTabId'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'MonitorTabMessage', N'COLUMN',N'LogMessageId'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Link to the log message.' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'MonitorTabMessage', @level2type=N'COLUMN',@level2name=N'LogMessageId'
GO
IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_MonitorTabMessage_LogMessage]') AND parent_object_id = OBJECT_ID(N'[hips].[MonitorTabMessage]'))
ALTER TABLE [hips].[MonitorTabMessage]  WITH CHECK ADD  CONSTRAINT [FK_MonitorTabMessage_LogMessage] FOREIGN KEY([LogMessageId])
REFERENCES [hips].[LogMessage] ([LogMessageId])
GO
IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_MonitorTabMessage_LogMessage]') AND parent_object_id = OBJECT_ID(N'[hips].[MonitorTabMessage]'))
ALTER TABLE [hips].[MonitorTabMessage] CHECK CONSTRAINT [FK_MonitorTabMessage_LogMessage]
GO
IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_MonitorTabMessage_MonitorTab]') AND parent_object_id = OBJECT_ID(N'[hips].[MonitorTabMessage]'))
ALTER TABLE [hips].[MonitorTabMessage]  WITH CHECK ADD  CONSTRAINT [FK_MonitorTabMessage_MonitorTab] FOREIGN KEY([MonitorTabId])
REFERENCES [hips].[MonitorTab] ([MonitorTabId])
GO
IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_MonitorTabMessage_MonitorTab]') AND parent_object_id = OBJECT_ID(N'[hips].[MonitorTabMessage]'))
ALTER TABLE [hips].[MonitorTabMessage] CHECK CONSTRAINT [FK_MonitorTabMessage_MonitorTab]
GO

SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[hips].[NameType]') AND type in (N'U'))
BEGIN
CREATE TABLE [hips].[NameType](
	[NameTypeId] [int] NOT NULL,
	[Code] [varchar](8) NOT NULL,
	[Description] [varchar](50) NOT NULL,
	[DateCreated] [datetime] NOT NULL,
	[UserCreated] [varchar](256) NOT NULL,
	[DateModified] [datetime] NOT NULL,
	[UserModified] [varchar](256) NOT NULL,
 CONSTRAINT [PK_NameType] PRIMARY KEY CLUSTERED 
(
	[NameTypeId] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
END
GO
SET ANSI_PADDING OFF
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'NameType', N'COLUMN',N'NameTypeId'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Identifies a type of patient name - Note that this is not an identity seed as the values are also configured in code as the enum NameType' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'NameType', @level2type=N'COLUMN',@level2name=N'NameTypeId'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'NameType', N'COLUMN',N'Code'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'HL7 Name Use Code (e.g. L, C, P)
' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'NameType', @level2type=N'COLUMN',@level2name=N'Code'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'NameType', N'COLUMN',N'Description'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Description (e.g. Registered Name, Current Name, Other)
' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'NameType', @level2type=N'COLUMN',@level2name=N'Description'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'NameType', NULL,NULL))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Identifies a type of patient name' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'NameType'
GO

SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[hips].[PatientMaster]') AND type in (N'U'))
BEGIN
CREATE TABLE [hips].[PatientMaster](
	[PatientMasterId] [int] IDENTITY(1,1) NOT NULL,
	[CurrentSexId] [int] NOT NULL,
	[DateOfBirth] [datetime] NOT NULL,
	[DateOfDeath] [datetime] NULL,
	[DeathIndicatorId] [int] NULL,
	[MedicareNumber] [varchar](12) NULL,
	[MedicareIrn] [varchar](3) NULL,
	[IsMedicareNumberValid] [bit] NULL,
	[DvaNumber] [varchar](18) NULL,
	[StatePatientId] [varchar](64) NULL,
	[DateCreated] [datetime] NOT NULL,
	[UserCreated] [varchar](256) NOT NULL,
	[DateModified] [datetime] NOT NULL,
	[UserModified] [varchar](256) NOT NULL,
 CONSTRAINT [PK_PatientMaster] PRIMARY KEY CLUSTERED 
(
	[PatientMasterId] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
END
GO
SET ANSI_PADDING OFF
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'PatientMaster', N'COLUMN',N'PatientMasterId'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Enterprise master patient record (from linked hospital facility records)' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'PatientMaster', @level2type=N'COLUMN',@level2name=N'PatientMasterId'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'PatientMaster', N'COLUMN',N'CurrentSexId'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Sex supplied by the PAS' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'PatientMaster', @level2type=N'COLUMN',@level2name=N'CurrentSexId'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'PatientMaster', N'COLUMN',N'DateOfBirth'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Date of Birth supplied by the PAS' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'PatientMaster', @level2type=N'COLUMN',@level2name=N'DateOfBirth'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'PatientMaster', N'COLUMN',N'DateOfDeath'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Date of Death (if applicable) supplied by the PAS' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'PatientMaster', @level2type=N'COLUMN',@level2name=N'DateOfDeath'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'PatientMaster', N'COLUMN',N'DeathIndicatorId'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Death indicator as linked to Date of Death' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'PatientMaster', @level2type=N'COLUMN',@level2name=N'DeathIndicatorId'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'PatientMaster', N'COLUMN',N'MedicareNumber'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Medicare Card Number (10 digits) supplied by the PAS' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'PatientMaster', @level2type=N'COLUMN',@level2name=N'MedicareNumber'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'PatientMaster', N'COLUMN',N'MedicareIrn'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Medicare Card Individual Reference Number (1 digit) supplied by the PAS' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'PatientMaster', @level2type=N'COLUMN',@level2name=N'MedicareIrn'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'PatientMaster', N'COLUMN',N'IsMedicareNumberValid'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Whether the Medicare Card Number passed checksum validation' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'PatientMaster', @level2type=N'COLUMN',@level2name=N'IsMedicareNumberValid'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'PatientMaster', N'COLUMN',N'DvaNumber'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Department of Veterans'' Affairs File Number supplied by the PAS' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'PatientMaster', @level2type=N'COLUMN',@level2name=N'DvaNumber'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'PatientMaster', N'COLUMN',N'DateCreated'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Date that this patient record was inserted into the table' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'PatientMaster', @level2type=N'COLUMN',@level2name=N'DateCreated'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'PatientMaster', N'COLUMN',N'UserCreated'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'User account that inserted the record' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'PatientMaster', @level2type=N'COLUMN',@level2name=N'UserCreated'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'PatientMaster', N'COLUMN',N'DateModified'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Date and time that this record was last modified (or as inserted)' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'PatientMaster', @level2type=N'COLUMN',@level2name=N'DateModified'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'PatientMaster', N'COLUMN',N'UserModified'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The account of the user that last modified (or inserted) this record' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'PatientMaster', @level2type=N'COLUMN',@level2name=N'UserModified'
GO
IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_PatientMaster_Sex]') AND parent_object_id = OBJECT_ID(N'[hips].[PatientMaster]'))
ALTER TABLE [hips].[PatientMaster]  WITH CHECK ADD  CONSTRAINT [FK_PatientMaster_Sex] FOREIGN KEY([CurrentSexId])
REFERENCES [hips].[Sex] ([SexId])
GO
IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_PatientMaster_Sex]') AND parent_object_id = OBJECT_ID(N'[hips].[PatientMaster]'))
ALTER TABLE [hips].[PatientMaster] CHECK CONSTRAINT [FK_PatientMaster_Sex]
GO
IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_PatientMaster_DeathIndicator]') AND parent_object_id = OBJECT_ID(N'[hips].[PatientMaster]'))
ALTER TABLE [hips].[PatientMaster]  WITH CHECK ADD  CONSTRAINT [FK_PatientMaster_DeathIndicator] FOREIGN KEY([DeathIndicatorId])
REFERENCES [hips].[DeathIndicator] ([DeathIndicatorId])
GO
IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_PatientMaster_DeathIndicator]') AND parent_object_id = OBJECT_ID(N'[hips].[PatientMaster]'))
ALTER TABLE [hips].[PatientMaster] CHECK CONSTRAINT [FK_PatientMaster_DeathIndicator]
GO

SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[hips].[PatientMasterAddress]') AND type in (N'U'))
BEGIN
CREATE TABLE [hips].[PatientMasterAddress](
	[PatientMasterId] [int] NOT NULL,
	[AddressId] [int] NOT NULL,
	[DateCreated] [datetime] NOT NULL,
	[UserCreated] [varchar](256) NOT NULL,
	[DateModified] [datetime] NOT NULL,
	[UserModified] [varchar](256) NOT NULL,
 CONSTRAINT [PK_PatientMasterAddress_1] PRIMARY KEY CLUSTERED 
(
	[PatientMasterId] ASC,
	[AddressId] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
END
GO
SET ANSI_PADDING OFF
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'PatientMasterAddress', N'COLUMN',N'PatientMasterId'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Link to the patient master record
' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'PatientMasterAddress', @level2type=N'COLUMN',@level2name=N'PatientMasterId'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'PatientMasterAddress', N'COLUMN',N'AddressId'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Link to the address record' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'PatientMasterAddress', @level2type=N'COLUMN',@level2name=N'AddressId'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'PatientMasterAddress', NULL,NULL))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Links a patient master to multiple addresses.' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'PatientMasterAddress'
GO
IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_PatientMasterAddress_Address]') AND parent_object_id = OBJECT_ID(N'[hips].[PatientMasterAddress]'))
ALTER TABLE [hips].[PatientMasterAddress]  WITH CHECK ADD  CONSTRAINT [FK_PatientMasterAddress_Address] FOREIGN KEY([AddressId])
REFERENCES [hips].[Address] ([AddressId])
ON DELETE CASCADE
GO
IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_PatientMasterAddress_Address]') AND parent_object_id = OBJECT_ID(N'[hips].[PatientMasterAddress]'))
ALTER TABLE [hips].[PatientMasterAddress] CHECK CONSTRAINT [FK_PatientMasterAddress_Address]
GO
IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_PatientMasterAddress_PatientMaster]') AND parent_object_id = OBJECT_ID(N'[hips].[PatientMasterAddress]'))
ALTER TABLE [hips].[PatientMasterAddress]  WITH CHECK ADD  CONSTRAINT [FK_PatientMasterAddress_PatientMaster] FOREIGN KEY([PatientMasterId])
REFERENCES [hips].[PatientMaster] ([PatientMasterId])
ON DELETE CASCADE
GO
IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_PatientMasterAddress_PatientMaster]') AND parent_object_id = OBJECT_ID(N'[hips].[PatientMasterAddress]'))
ALTER TABLE [hips].[PatientMasterAddress] CHECK CONSTRAINT [FK_PatientMasterAddress_PatientMaster]
GO

SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[hips].[PatientMasterContact]') AND type in (N'U'))
BEGIN
CREATE TABLE [hips].[PatientMasterContact](
	[PatientMasterId] [int] NOT NULL,
	[ContactId] [int] NOT NULL,
	[DateCreated] [datetime] NOT NULL,
	[UserCreated] [varchar](256) NOT NULL,
	[DateModified] [datetime] NOT NULL,
	[UserModified] [varchar](256) NOT NULL,
 CONSTRAINT [PK_PatientMasterContact] PRIMARY KEY CLUSTERED 
(
	[PatientMasterId] ASC,
	[ContactId] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
END
GO
SET ANSI_PADDING OFF
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'PatientMasterContact', N'COLUMN',N'PatientMasterId'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The patient master.' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'PatientMasterContact', @level2type=N'COLUMN',@level2name=N'PatientMasterId'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'PatientMasterContact', NULL,NULL))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Links a patient master to multiple electronic contact numbers or addresses.' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'PatientMasterContact'
GO
IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_PatientMasterContact_Contact]') AND parent_object_id = OBJECT_ID(N'[hips].[PatientMasterContact]'))
ALTER TABLE [hips].[PatientMasterContact]  WITH CHECK ADD  CONSTRAINT [FK_PatientMasterContact_Contact] FOREIGN KEY([ContactId])
REFERENCES [hips].[Contact] ([ContactId])
ON DELETE CASCADE
GO
IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_PatientMasterContact_Contact]') AND parent_object_id = OBJECT_ID(N'[hips].[PatientMasterContact]'))
ALTER TABLE [hips].[PatientMasterContact] CHECK CONSTRAINT [FK_PatientMasterContact_Contact]
GO
IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_PatientMasterContact_PatientMaster]') AND parent_object_id = OBJECT_ID(N'[hips].[PatientMasterContact]'))
ALTER TABLE [hips].[PatientMasterContact]  WITH CHECK ADD  CONSTRAINT [FK_PatientMasterContact_PatientMaster] FOREIGN KEY([PatientMasterId])
REFERENCES [hips].[PatientMaster] ([PatientMasterId])
ON DELETE CASCADE
GO
IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_PatientMasterContact_PatientMaster]') AND parent_object_id = OBJECT_ID(N'[hips].[PatientMasterContact]'))
ALTER TABLE [hips].[PatientMasterContact] CHECK CONSTRAINT [FK_PatientMasterContact_PatientMaster]
GO

SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[hips].[PatientMasterHistory]') AND type in (N'U'))
BEGIN
CREATE TABLE [hips].[PatientMasterHistory](
	[PatientMasterHistoryId] [int] IDENTITY(1,1) NOT NULL,
	[PatientMasterId] [int] NOT NULL,
	[FromStatePatientId] [varchar](64) NULL,
	[ToStatePatientId] [varchar](64) NULL,
	[DateCreated] [datetime] NOT NULL,
	[UserCreated] [varchar](256) NOT NULL,
	[DateModified] [datetime] NOT NULL,
	[UserModified] [varchar](256) NOT NULL,
 CONSTRAINT [PK_PatientMasterHistory_1] PRIMARY KEY CLUSTERED 
(
	[PatientMasterHistoryId] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
END
GO
SET ANSI_PADDING OFF
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'PatientMasterHistory', N'COLUMN',N'PatientMasterHistoryId'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'History of changes to PatientMaster record made during merges or moves' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'PatientMasterHistory', @level2type=N'COLUMN',@level2name=N'PatientMasterHistoryId'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'PatientMasterHistory', N'COLUMN',N'PatientMasterHistoryId'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Identifier of the PatientMaster record in question' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'PatientMasterHistory', @level2type=N'COLUMN',@level2name=N'PatientMasterId'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'PatientMasterHistory', N'COLUMN',N'FromStatePatientId'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Previous identifier for the patient, allocated by the EMPI.' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'PatientMasterHistory', @level2type=N'COLUMN',@level2name=N'FromStatePatientId'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'PatientMasterHistory', N'COLUMN',N'ToStatePatientId'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'New identifier for the patient, allocated by the EMPI.' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'PatientMasterHistory', @level2type=N'COLUMN',@level2name=N'ToStatePatientId'
GO
IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_PatientMasterHistory_PatientMaster]') AND parent_object_id = OBJECT_ID(N'[hips].[PatientMasterHistory]'))
ALTER TABLE [hips].[PatientMasterHistory]  WITH CHECK ADD  CONSTRAINT [FK_PatientMasterHistory_PatientMaster] FOREIGN KEY([PatientMasterId])
REFERENCES [hips].[PatientMaster] ([PatientMasterId])
GO
IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_PatientMasterHistory_PatientMaster]') AND parent_object_id = OBJECT_ID(N'[hips].[PatientMasterHistory]'))
ALTER TABLE [hips].[PatientMasterHistory] CHECK CONSTRAINT [FK_PatientMasterHistory_PatientMaster]
GO

SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[hips].[PatientMasterIhi]') AND type in (N'U'))
BEGIN
CREATE TABLE [hips].[PatientMasterIhi](
	[PatientMasterId] [int] NOT NULL,
	[HealthProviderOrganisationNetworkId] [int] NOT NULL,
	[Ihi] [varchar](16) NULL,
	[IhiStatusId] [int] NOT NULL,
	[IhiRecordStatusId] [int] NOT NULL,
	[RegisteredGivenName] [varchar](80) NOT NULL,
	[RegisteredFamilyName] [varchar](80) NOT NULL,
	[RegisteredSexId] [int] NOT NULL,
	[DateLastValidated] [datetime] NOT NULL,
	[RegisteredDateOfBirth] [datetime] NULL,	
	[DateCreated] [datetime] NOT NULL,
	[UserCreated] [varchar](256) NOT NULL,
	[DateModified] [datetime] NOT NULL,
	[UserModified] [varchar](256) NOT NULL,	
 CONSTRAINT [PK_PatientMasterIhi] PRIMARY KEY CLUSTERED 
(
	[PatientMasterId] ASC
	, [HealthProviderOrganisationNetworkId] 
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
END

GO
SET ANSI_PADDING OFF
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'PatientMasterIhi', N'COLUMN',N'PatientMasterId'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Link to the HIPS Patient Master record.
' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'PatientMasterIhi', @level2type=N'COLUMN',@level2name=N'PatientMasterId'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'PatientMasterIhi', N'COLUMN',N'Ihi'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Individual Healthcare Identifier (IHI) assigned to this patient master.' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'PatientMasterIhi', @level2type=N'COLUMN',@level2name=N'Ihi'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'PatientMasterIhi', N'COLUMN',N'IhiStatusId'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Whether the IHI is Active, Deceased, Retired, Expired or Resolved, and also whether there is a current exception alert on this IHI, such as because it is a potential duplicate or replica.' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'PatientMasterIhi', @level2type=N'COLUMN',@level2name=N'IhiStatusId'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'PatientMasterIhi', N'COLUMN',N'IhiRecordStatusId'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Whether the IHI is Verified, Unverified or Provisional.
' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'PatientMasterIhi', @level2type=N'COLUMN',@level2name=N'IhiRecordStatusId'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'PatientMasterIhi', N'COLUMN',N'RegisteredGivenName'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Given name  registered with medicare' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'PatientMasterIhi', @level2type=N'COLUMN',@level2name=N'RegisteredGivenName'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'PatientMasterIhi', N'COLUMN',N'RegisteredFamilyName'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Family name registered with medicare' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'PatientMasterIhi', @level2type=N'COLUMN',@level2name=N'RegisteredFamilyName'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'PatientMasterIhi', N'COLUMN',N'RegisteredSexId'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The sex for which the IHI was obtained.' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'PatientMasterIhi', @level2type=N'COLUMN',@level2name=N'RegisteredSexId'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'PatientMasterIhi', N'COLUMN',N'RegisteredDateOfBirth'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The DOB for which the IHI was obtained.' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'PatientMasterIhi', @level2type=N'COLUMN',@level2name=N'RegisteredDateOfBirth'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'PatientMasterIhi', N'COLUMN',N'DateCreated'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Date that this patient record was inserted into the table' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'PatientMasterIhi', @level2type=N'COLUMN',@level2name=N'DateCreated'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'PatientMasterIhi', N'COLUMN',N'UserCreated'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'User account that inserted the record' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'PatientMasterIhi', @level2type=N'COLUMN',@level2name=N'UserCreated'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'PatientMasterIhi', N'COLUMN',N'DateModified'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Date and time that this record was last modified (or as inserted)' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'PatientMasterIhi', @level2type=N'COLUMN',@level2name=N'DateModified'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'PatientMasterIhi', N'COLUMN',N'UserModified'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The account of the user that last modified (or inserted) this record' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'PatientMasterIhi', @level2type=N'COLUMN',@level2name=N'UserModified'
GO
IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_PatientMasterIhi_IhiRecordStatus]') AND parent_object_id = OBJECT_ID(N'[hips].[PatientMasterIhi]'))
ALTER TABLE [hips].[PatientMasterIhi]  WITH CHECK ADD  CONSTRAINT [FK_PatientMasterIhi_IhiRecordStatus] FOREIGN KEY([IhiRecordStatusId])
REFERENCES [hips].[IhiRecordStatus] ([IhiRecordStatusId])
GO
IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_PatientMasterIhi_IhiRecordStatus]') AND parent_object_id = OBJECT_ID(N'[hips].[PatientMasterIhi]'))
ALTER TABLE [hips].[PatientMasterIhi] CHECK CONSTRAINT [FK_PatientMasterIhi_IhiRecordStatus]
GO
IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_PatientMasterIhi_IhiStatus]') AND parent_object_id = OBJECT_ID(N'[hips].[PatientMasterIhi]'))
ALTER TABLE [hips].[PatientMasterIhi]  WITH CHECK ADD  CONSTRAINT [FK_PatientMasterIhi_IhiStatus] FOREIGN KEY([IhiStatusId])
REFERENCES [hips].[IhiStatus] ([IhiStatusId])
GO
IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_PatientMasterIhi_IhiStatus]') AND parent_object_id = OBJECT_ID(N'[hips].[PatientMasterIhi]'))
ALTER TABLE [hips].[PatientMasterIhi] CHECK CONSTRAINT [FK_PatientMasterIhi_IhiStatus]
GO
IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_PatientMasterIhi_Sex]') AND parent_object_id = OBJECT_ID(N'[hips].[PatientMasterIhi]'))
ALTER TABLE [hips].[PatientMasterIhi]  WITH CHECK ADD  CONSTRAINT [FK_PatientMasterIhi_Sex] FOREIGN KEY([RegisteredSexId])
REFERENCES [hips].[Sex] ([SexId])
GO
IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_PatientMasterIhi_Sex]') AND parent_object_id = OBJECT_ID(N'[hips].[PatientMasterIhi]'))
ALTER TABLE [hips].[PatientMasterIhi] CHECK CONSTRAINT [FK_PatientMasterIhi_Sex]
GO
IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_PatientMasterIhi_PatientMaster]') AND parent_object_id = OBJECT_ID(N'[hips].[PatientMasterIhi]'))
ALTER TABLE [hips].[PatientMasterIhi]  WITH CHECK ADD  CONSTRAINT [FK_PatientMasterIhi_PatientMaster] FOREIGN KEY([PatientMasterId])
REFERENCES [hips].[PatientMaster] ([PatientMasterId])
GO
IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_PatientMasterIhi_PatientMaster]') AND parent_object_id = OBJECT_ID(N'[hips].[PatientMasterIhi]'))
ALTER TABLE [hips].[PatientMasterIhi] CHECK CONSTRAINT [FK_PatientMasterIhi_PatientMaster]
GO
IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_PatientMasterIhi_HealthProviderOrganisationNetwork]') AND parent_object_id = OBJECT_ID(N'[hips].[PatientMasterIhi]'))
ALTER TABLE [hips].[PatientMasterIhi]  WITH CHECK ADD  CONSTRAINT [FK_PatientMasterIhi_HealthProviderOrganisationNetwork] FOREIGN KEY([HealthProviderOrganisationNetworkId])
REFERENCES [hips].[HealthProviderOrganisationNetwork] ([HealthProviderOrganisationNetworkId])
GO

SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[hips].[PatientMasterIhiHistory]') AND type in (N'U'))
BEGIN
CREATE TABLE [hips].[PatientMasterIhiHistory](
	[IhiHistoryId] [int] IDENTITY(1,1) NOT NULL,
	[PatientMasterId] [int] NOT NULL,	
	[HealthProviderOrganisationNetworkId] [int] NOT NULL,
	[Ihi] [varchar](50) NULL,
	[IhiRecordStatusId] [int] NOT NULL,
	[IhiStatusId] [int] NOT NULL,
	[DateCreated] [datetime] NOT NULL,
	[UserCreated] [varchar](256) NOT NULL,
	[DateModified] [datetime] NOT NULL,
	[UserModified] [varchar](256) NOT NULL,
 CONSTRAINT [PK_PatientMasterIhiHistory_1] PRIMARY KEY CLUSTERED 
(
	[IhiHistoryId] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
END
GO
SET ANSI_PADDING OFF
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'PatientMasterIhiHistory', N'COLUMN',N'IhiHistoryId'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Primary key' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'PatientMasterIhiHistory', @level2type=N'COLUMN',@level2name=N'IhiHistoryId'
GO
IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_PatientMasterIhiHistory_HealthProviderOrganisationNetwork]') AND parent_object_id = OBJECT_ID(N'[hips].[PatientMasterIhiHistory]'))
ALTER TABLE [hips].[PatientMasterIhiHistory]  WITH CHECK ADD  CONSTRAINT [FK_PatientMasterIhiHistory_HealthProviderOrganisationNetwork] FOREIGN KEY([HealthProviderOrganisationNetworkId])
REFERENCES [hips].[HealthProviderOrganisationNetwork] ([HealthProviderOrganisationNetworkId])
GO

SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[hips].[PatientMasterName]') AND type in (N'U'))
BEGIN
CREATE TABLE [hips].[PatientMasterName](
	[PatientMasterNameId] [int] IDENTITY(1,1) NOT NULL,
	[PatientMasterId] [int] NOT NULL,
	[TitleId] [int] NULL,
	[GivenNames] [varchar](80) NOT NULL,
	[FamilyName] [varchar](80) NOT NULL,
	[SuffixId] [int] NULL,
	[NameTypeId] [int] NOT NULL,
	[DateCreated] [datetime] NOT NULL,
	[UserCreated] [varchar](256) NOT NULL,
	[DateModified] [datetime] NOT NULL,
	[UserModified] [varchar](256) NOT NULL,
 CONSTRAINT [PK_PatientMasterName] PRIMARY KEY CLUSTERED 
(
	[PatientMasterNameId] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
END
GO
SET ANSI_PADDING OFF
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'PatientMasterName', N'COLUMN',N'PatientMasterNameId'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Identifies one of the names that a patient is known by.' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'PatientMasterName', @level2type=N'COLUMN',@level2name=N'PatientMasterNameId'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'PatientMasterName', N'COLUMN',N'PatientMasterId'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Link to the patient master record' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'PatientMasterName', @level2type=N'COLUMN',@level2name=N'PatientMasterId'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'PatientMasterName', N'COLUMN',N'TitleId'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Name title (e.g. Dr, Ms, Miss, Mrs, Mr)' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'PatientMasterName', @level2type=N'COLUMN',@level2name=N'TitleId'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'PatientMasterName', N'COLUMN',N'GivenNames'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Given names separated by spaces' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'PatientMasterName', @level2type=N'COLUMN',@level2name=N'GivenNames'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'PatientMasterName', N'COLUMN',N'FamilyName'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Family name' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'PatientMasterName', @level2type=N'COLUMN',@level2name=N'FamilyName'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'PatientMasterName', N'COLUMN',N'SuffixId'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Name suffix (e.g. Jr, Sr)' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'PatientMasterName', @level2type=N'COLUMN',@level2name=N'SuffixId'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'PatientMasterName', N'COLUMN',N'NameTypeId'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Type of name (Registered, Current or Other)' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'PatientMasterName', @level2type=N'COLUMN',@level2name=N'NameTypeId'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'PatientMasterName', N'COLUMN',N'DateCreated'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Date that this patient record was inserted into the table' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'PatientMasterName', @level2type=N'COLUMN',@level2name=N'DateCreated'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'PatientMasterName', N'COLUMN',N'UserCreated'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'User account that inserted the record' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'PatientMasterName', @level2type=N'COLUMN',@level2name=N'UserCreated'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'PatientMasterName', N'COLUMN',N'DateModified'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Date and time that this record was last modified (or as inserted)' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'PatientMasterName', @level2type=N'COLUMN',@level2name=N'DateModified'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'PatientMasterName', N'COLUMN',N'UserModified'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The account of the user that last modified (or inserted) this record' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'PatientMasterName', @level2type=N'COLUMN',@level2name=N'UserModified'
GO
IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_PatientMasterName_NameType]') AND parent_object_id = OBJECT_ID(N'[hips].[PatientMasterName]'))
ALTER TABLE [hips].[PatientMasterName]  WITH CHECK ADD  CONSTRAINT [FK_PatientMasterName_NameType] FOREIGN KEY([NameTypeId])
REFERENCES [hips].[NameType] ([NameTypeId])
GO
IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_PatientMasterName_NameType]') AND parent_object_id = OBJECT_ID(N'[hips].[PatientMasterName]'))
ALTER TABLE [hips].[PatientMasterName] CHECK CONSTRAINT [FK_PatientMasterName_NameType]
GO
IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_PatientMasterName_PatientMaster]') AND parent_object_id = OBJECT_ID(N'[hips].[PatientMasterName]'))
ALTER TABLE [hips].[PatientMasterName]  WITH CHECK ADD  CONSTRAINT [FK_PatientMasterName_PatientMaster] FOREIGN KEY([TitleId])
REFERENCES [hips].[Title] ([TitleId])
GO
IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_PatientMasterName_PatientMaster]') AND parent_object_id = OBJECT_ID(N'[hips].[PatientMasterName]'))
ALTER TABLE [hips].[PatientMasterName] CHECK CONSTRAINT [FK_PatientMasterName_PatientMaster]
GO
IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_PatientMasterName_PatientMaster1]') AND parent_object_id = OBJECT_ID(N'[hips].[PatientMasterName]'))
ALTER TABLE [hips].[PatientMasterName]  WITH CHECK ADD  CONSTRAINT [FK_PatientMasterName_PatientMaster1] FOREIGN KEY([PatientMasterId])
REFERENCES [hips].[PatientMaster] ([PatientMasterId])
GO
IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_PatientMasterName_PatientMaster1]') AND parent_object_id = OBJECT_ID(N'[hips].[PatientMasterName]'))
ALTER TABLE [hips].[PatientMasterName] CHECK CONSTRAINT [FK_PatientMasterName_PatientMaster1]
GO
IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_PatientMasterName_Suffix]') AND parent_object_id = OBJECT_ID(N'[hips].[PatientMasterName]'))
ALTER TABLE [hips].[PatientMasterName]  WITH CHECK ADD  CONSTRAINT [FK_PatientMasterName_Suffix] FOREIGN KEY([SuffixId])
REFERENCES [hips].[Suffix] ([SuffixId])
GO
IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_PatientMasterName_Suffix]') AND parent_object_id = OBJECT_ID(N'[hips].[PatientMasterName]'))
ALTER TABLE [hips].[PatientMasterName] CHECK CONSTRAINT [FK_PatientMasterName_Suffix]
GO
IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_PatientMasterName_Title]') AND parent_object_id = OBJECT_ID(N'[hips].[PatientMasterName]'))
ALTER TABLE [hips].[PatientMasterName]  WITH CHECK ADD  CONSTRAINT [FK_PatientMasterName_Title] FOREIGN KEY([TitleId])
REFERENCES [hips].[Title] ([TitleId])
GO
IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_PatientMasterName_Title]') AND parent_object_id = OBJECT_ID(N'[hips].[PatientMasterName]'))
ALTER TABLE [hips].[PatientMasterName] CHECK CONSTRAINT [FK_PatientMasterName_Title]
GO

SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[hips].[PcehrAudit]') AND type in (N'U'))
BEGIN
CREATE TABLE [hips].[PcehrAudit](
	[PcehrAuditId] [int] IDENTITY(1,1) NOT NULL,
	[PatientMasterId] [int] NOT NULL,
	[ServiceName] [varchar](256) NOT NULL,
	[ServiceMessage] [varchar](max) NOT NULL,
	[Request] [xml] NULL,
	[Response] [xml] NULL,
	[Ihi] [varchar](16) NOT NULL,
	[HpiO] [varchar](16) NOT NULL,
	[UserName] [varchar](256) NOT NULL,
	[DateCreated] [datetime] NOT NULL,
	[UserCreated] [varchar](256) NOT NULL,
	[DateModified] [datetime] NOT NULL,
	[UserModified] [varchar](256) NOT NULL,
 CONSTRAINT [PK_PcehrAudit] PRIMARY KEY CLUSTERED 
(
	[PcehrAuditId] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
END
GO
SET ANSI_PADDING OFF
GO
IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_PcehrAudit_PatientMaster]') AND parent_object_id = OBJECT_ID(N'[hips].[PcehrAudit]'))
ALTER TABLE [hips].[PcehrAudit]  WITH CHECK ADD  CONSTRAINT [FK_PcehrAudit_PatientMaster] FOREIGN KEY([PatientMasterId])
REFERENCES [hips].[PatientMaster] ([PatientMasterId])
GO
IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_PcehrAudit_PatientMaster]') AND parent_object_id = OBJECT_ID(N'[hips].[PcehrAudit]'))
ALTER TABLE [hips].[PcehrAudit] CHECK CONSTRAINT [FK_PcehrAudit_PatientMaster]
GO

SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[hips].[PcehrMessageQueue]') AND type in (N'U'))
BEGIN
CREATE TABLE [hips].[PcehrMessageQueue](
	[PcehrMessageQueueId] [int] IDENTITY(1,1) NOT NULL,
	[QueueOperationId] [int] NOT NULL,
	[QueueStatusId] [int] NOT NULL,
	[EpisodeId] [int] NULL,
	[SourceSystemSetId] [varchar](128) NULL,
	[SourceSystemDocumentId] [varchar](128) NULL,
	[SerialisedObject] [varbinary](max) NOT NULL,
	[Request] [xml] NULL,
	[Response] [xml] NULL,
	[Details] [varchar](max) NULL,
	[DateCreated] [datetime] NOT NULL,
	[UserCreated] [varchar](256) NOT NULL,
	[DateModified] [datetime] NOT NULL,
	[UserModified] [varchar](256) NOT NULL,
 CONSTRAINT [PK_PcehrMessageQueue] PRIMARY KEY CLUSTERED 
(
	[PcehrMessageQueueId] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
END
GO
SET ANSI_PADDING OFF
GO
IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_PcehrMessageQueue_QueueOperation]') AND parent_object_id = OBJECT_ID(N'[hips].[PcehrMessageQueue]'))
ALTER TABLE [hips].[PcehrMessageQueue]  WITH CHECK ADD  CONSTRAINT [FK_PcehrMessageQueue_QueueOperation] FOREIGN KEY([QueueOperationId])
REFERENCES [hips].[QueueOperation] ([QueueOperationId])
GO
IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_PcehrMessageQueue_QueueOperation]') AND parent_object_id = OBJECT_ID(N'[hips].[PcehrMessageQueue]'))
ALTER TABLE [hips].[PcehrMessageQueue] CHECK CONSTRAINT [FK_PcehrMessageQueue_QueueOperation]
GO
IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_PcehrMessageQueue_QueueStatus]') AND parent_object_id = OBJECT_ID(N'[hips].[PcehrMessageQueue]'))
ALTER TABLE [hips].[PcehrMessageQueue]  WITH CHECK ADD  CONSTRAINT [FK_PcehrMessageQueue_QueueStatus] FOREIGN KEY([QueueStatusId])
REFERENCES [hips].[QueueStatus] ([QueueStatusId])
GO
IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_PcehrMessageQueue_QueueStatus]') AND parent_object_id = OBJECT_ID(N'[hips].[PcehrMessageQueue]'))
ALTER TABLE [hips].[PcehrMessageQueue] CHECK CONSTRAINT [FK_PcehrMessageQueue_QueueStatus]
GO

SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[hips].[PendingIhiPcehrLookup]') AND type in (N'U'))
BEGIN
CREATE TABLE [hips].[PendingIhiPcehrLookup](
	[HealthProviderOrganisationId] [int] NOT NULL,
	[PatientMasterId] [int] NOT NULL,
	[DateCreated] [datetime] NOT NULL,
	[UserCreated] [varchar](256) NOT NULL,
	[DateModified] [datetime] NOT NULL,
	[UserModified] [varchar](256) NOT NULL,
 CONSTRAINT [PK_PendingIhiPcehrLookup] PRIMARY KEY CLUSTERED 
(
	[HealthProviderOrganisationId] ASC,
	[PatientMasterId] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
END
GO
SET ANSI_PADDING OFF
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'PendingIhiPcehrLookup', N'COLUMN',N'HealthProviderOrganisationId'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Link to the Health Provider Organisation (HPI-O).' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'PendingIhiPcehrLookup', @level2type=N'COLUMN',@level2name=N'HealthProviderOrganisationId'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'PendingIhiPcehrLookup', N'COLUMN',N'PatientMasterId'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Link to the HIPS Patient Master record.' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'PendingIhiPcehrLookup', @level2type=N'COLUMN',@level2name=N'PatientMasterId'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'PendingIhiPcehrLookup', N'COLUMN',N'DateCreated'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Date that this patient record was inserted into the table' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'PendingIhiPcehrLookup', @level2type=N'COLUMN',@level2name=N'DateCreated'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'PendingIhiPcehrLookup', N'COLUMN',N'UserCreated'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'User account that inserted the record' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'PendingIhiPcehrLookup', @level2type=N'COLUMN',@level2name=N'UserCreated'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'PendingIhiPcehrLookup', N'COLUMN',N'DateModified'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Date and time that this record was last modified (or as inserted)' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'PendingIhiPcehrLookup', @level2type=N'COLUMN',@level2name=N'DateModified'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'PendingIhiPcehrLookup', N'COLUMN',N'UserModified'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The account of the user that last modified (or inserted) this record' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'PendingIhiPcehrLookup', @level2type=N'COLUMN',@level2name=N'UserModified'
GO
IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_PendingIhiPcehrLookup_HealthProviderOrganisation]') AND parent_object_id = OBJECT_ID(N'[hips].[PendingIhiPcehrLookup]'))
ALTER TABLE [hips].[PendingIhiPcehrLookup]  WITH CHECK ADD  CONSTRAINT [FK_PendingIhiPcehrLookup_HealthProviderOrganisation] FOREIGN KEY([HealthProviderOrganisationId])
REFERENCES [hips].[HealthProviderOrganisation] ([HealthProviderOrganisationId])
GO
IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_PendingIhiPcehrLookup_HealthProviderOrganisation]') AND parent_object_id = OBJECT_ID(N'[hips].[PendingIhiPcehrLookup]'))
ALTER TABLE [hips].[PendingIhiPcehrLookup] CHECK CONSTRAINT [FK_PendingIhiPcehrLookup_HealthProviderOrganisation]
GO
IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_PendingIhiPcehrLookup_PatientMaster]') AND parent_object_id = OBJECT_ID(N'[hips].[PendingIhiPcehrLookup]'))
ALTER TABLE [hips].[PendingIhiPcehrLookup]  WITH CHECK ADD  CONSTRAINT [FK_PendingIhiPcehrLookup_PatientMaster] FOREIGN KEY([PatientMasterId])
REFERENCES [hips].[PatientMaster] ([PatientMasterId])
GO
IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_PendingIhiPcehrLookup_PatientMaster]') AND parent_object_id = OBJECT_ID(N'[hips].[PendingIhiPcehrLookup]'))
ALTER TABLE [hips].[PendingIhiPcehrLookup] CHECK CONSTRAINT [FK_PendingIhiPcehrLookup_PatientMaster]
GO

SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[hips].[PostalDeliveryType]') AND type in (N'U'))
BEGIN
CREATE TABLE [hips].[PostalDeliveryType](
	[PostalDeliveryTypeId] [int] IDENTITY(1,1) NOT NULL,
	[Code] [varchar](12) NOT NULL,
	[Description] [varchar](256) NOT NULL,
	[DateCreated] [datetime] NOT NULL,
	[UserCreated] [varchar](256) NOT NULL,
	[DateModified] [datetime] NOT NULL,
	[UserModified] [varchar](256) NOT NULL,
 CONSTRAINT [PK_PostalDeliveryType] PRIMARY KEY CLUSTERED 
(
	[PostalDeliveryTypeId] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
END
GO
SET ANSI_PADDING OFF
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'PostalDeliveryType', N'COLUMN',N'PostalDeliveryTypeId'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Identifies a PostalDeliveryType.' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'PostalDeliveryType', @level2type=N'COLUMN',@level2name=N'PostalDeliveryTypeId'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'PostalDeliveryType', N'COLUMN',N'Code'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'ABS SACC (4 digits)' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'PostalDeliveryType', @level2type=N'COLUMN',@level2name=N'Code'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'PostalDeliveryType', N'COLUMN',N'Description'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Description from ABS SACC' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'PostalDeliveryType', @level2type=N'COLUMN',@level2name=N'Description'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'PostalDeliveryType', N'COLUMN',N'DateCreated'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Date and Time the record was created' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'PostalDeliveryType', @level2type=N'COLUMN',@level2name=N'DateCreated'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'PostalDeliveryType', N'COLUMN',N'UserCreated'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'User that created the record' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'PostalDeliveryType', @level2type=N'COLUMN',@level2name=N'UserCreated'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'PostalDeliveryType', N'COLUMN',N'DateModified'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Date and Time the record was modified' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'PostalDeliveryType', @level2type=N'COLUMN',@level2name=N'DateModified'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'PostalDeliveryType', N'COLUMN',N'UserModified'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'User that modified the record' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'PostalDeliveryType', @level2type=N'COLUMN',@level2name=N'UserModified'
GO

SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[hips].[PostalDeliveryTypeCode]') AND type in (N'U'))
BEGIN
CREATE TABLE [hips].[PostalDeliveryTypeCode](
	[PostalDeliveryTypeId] [int] NOT NULL,
	[CodeSystemId] [int] NOT NULL,
	[DateCreated] [datetime] NOT NULL,
	[UserCreated] [varchar](256) NOT NULL,
	[DateModified] [datetime] NOT NULL,
	[UserModified] [varchar](256) NOT NULL,
 CONSTRAINT [PK_PostalDeliveryTypeCode] PRIMARY KEY CLUSTERED 
(
	[PostalDeliveryTypeId] ASC,
	[CodeSystemId] ASC  
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
END
GO
SET ANSI_PADDING OFF
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'PostalDeliveryTypeCode', N'COLUMN',N'PostalDeliveryTypeId'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'PostalDeliveryType' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'PostalDeliveryTypeCode', @level2type=N'COLUMN',@level2name=N'PostalDeliveryTypeId'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'PostalDeliveryTypeCode', N'COLUMN',N'CodeSystemId'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Type of identifier' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'PostalDeliveryTypeCode', @level2type=N'COLUMN',@level2name=N'CodeSystemId'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'PostalDeliveryTypeCode', N'COLUMN',N'DateCreated'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Date and Time the record was created' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'PostalDeliveryTypeCode', @level2type=N'COLUMN',@level2name=N'DateCreated'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'PostalDeliveryTypeCode', N'COLUMN',N'UserCreated'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'User that created the record' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'PostalDeliveryTypeCode', @level2type=N'COLUMN',@level2name=N'UserCreated'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'PostalDeliveryTypeCode', N'COLUMN',N'DateModified'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Date and Time the record was modified' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'PostalDeliveryTypeCode', @level2type=N'COLUMN',@level2name=N'DateModified'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'PostalDeliveryTypeCode', N'COLUMN',N'UserModified'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'User that modified the record' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'PostalDeliveryTypeCode', @level2type=N'COLUMN',@level2name=N'UserModified'
GO
IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_PostalDeliveryTypeCode_CodeSystem]') AND parent_object_id = OBJECT_ID(N'[hips].[PostalDeliveryTypeCode]'))
ALTER TABLE [hips].[PostalDeliveryTypeCode]  WITH CHECK ADD  CONSTRAINT [FK_PostalDeliveryTypeCode_CodeSystem] FOREIGN KEY([CodeSystemId])
REFERENCES [hips].[CodeSystem] ([CodeSystemId])
GO
IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_PostalDeliveryTypeCode_CodeSystem]') AND parent_object_id = OBJECT_ID(N'[hips].[PostalDeliveryTypeCode]'))
ALTER TABLE [hips].[PostalDeliveryTypeCode] CHECK CONSTRAINT [FK_PostalDeliveryTypeCode_CodeSystem]
GO
IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_PostalDeliveryTypeCode_PostalDeliveryType]') AND parent_object_id = OBJECT_ID(N'[hips].[PostalDeliveryTypeCode]'))
ALTER TABLE [hips].[PostalDeliveryTypeCode]  WITH CHECK ADD  CONSTRAINT [FK_PostalDeliveryTypeCode_PostalDeliveryType] FOREIGN KEY([PostalDeliveryTypeId])
REFERENCES [hips].[PostalDeliveryType] ([PostalDeliveryTypeId])
GO
IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_PostalDeliveryTypeCode_PostalDeliveryType]') AND parent_object_id = OBJECT_ID(N'[hips].[PostalDeliveryTypeCode]'))
ALTER TABLE [hips].[PostalDeliveryTypeCode] CHECK CONSTRAINT [FK_PostalDeliveryTypeCode_PostalDeliveryType]
GO

SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[hips].[QueueOperation]') AND type in (N'U'))
BEGIN
CREATE TABLE [hips].[QueueOperation](
	[QueueOperationId] [int] NOT NULL,
	[Description] [varchar](100) NOT NULL,
	[DateCreated] [datetime] NOT NULL,
	[UserCreated] [varchar](256) NOT NULL,
	[DateModified] [datetime] NOT NULL,
	[UserModified] [varchar](256) NOT NULL,
 CONSTRAINT [PK_QueueOperation] PRIMARY KEY CLUSTERED 
(
	[QueueOperationId] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
END
GO
SET ANSI_PADDING OFF
GO

SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[hips].[QueueStatus]') AND type in (N'U'))
BEGIN
CREATE TABLE [hips].[QueueStatus](
	[QueueStatusId] [int] NOT NULL,
	[Description] [varchar](20) NOT NULL,
	[DateCreated] [datetime] NOT NULL,
	[UserCreated] [varchar](256) NOT NULL,
	[DateModified] [datetime] NOT NULL,
	[UserModified] [varchar](256) NOT NULL,
 CONSTRAINT [PK_QueueStatus] PRIMARY KEY CLUSTERED 
(
	[QueueStatusId] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
END
GO
SET ANSI_PADDING OFF
GO

SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[hips].[RemovalReason]') AND type in (N'U'))
BEGIN
CREATE TABLE [hips].[RemovalReason](
	[RemovalReasonId] [int] IDENTITY(1,1) NOT NULL,
	[Description] [varchar](50) NOT NULL,
	[DateCreated] [datetime] NOT NULL,
	[UserCreated] [varchar](256) NOT NULL,
	[DateModified] [datetime] NOT NULL,
	[UserModified] [varchar](256) NOT NULL,
 CONSTRAINT [PK_RemovalReason] PRIMARY KEY CLUSTERED 
(
	[RemovalReasonId] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
END
GO
SET ANSI_PADDING OFF
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'RemovalReason', N'COLUMN',N'Description'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Description (e.g. Withdrawn, Elect to Remove, Incorrect Identity)' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'RemovalReason', @level2type=N'COLUMN',@level2name=N'Description'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'RemovalReason', NULL,NULL))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Reason why a document version was removed from PCEHR' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'RemovalReason'
GO

SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[hips].[RemoveAudit]') AND type in (N'U'))
BEGIN
CREATE TABLE [hips].[RemoveAudit](
	[RemoveAuditId] [int] IDENTITY(1,1) NOT NULL,
	[ClinicalDocumentId] [int] NOT NULL,
	[RemovalReasonId] [int] NOT NULL,
	[AuditInformation] [varbinary](MAX) NULL,
	[DateCreated] [datetime] NOT NULL,
	[UserCreated] [varchar](256) NOT NULL,
	[DateModified] [datetime] NOT NULL,
	[UserModified] [varchar](256) NOT NULL,
 CONSTRAINT [PK_RemoveAudit] PRIMARY KEY CLUSTERED 
(
	[RemoveAuditId] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
END
GO
SET ANSI_PADDING OFF
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'RemoveAudit', N'COLUMN',N'RemoveAuditId'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Primary Key' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'RemoveAudit', @level2type=N'COLUMN',@level2name=N'RemoveAuditId'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'RemoveAudit', N'COLUMN',N'ClinicalDocumentId'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Link to the ClinicalDocument that was removed from the PCEHR system' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'RemoveAudit', @level2type=N'COLUMN',@level2name=N'ClinicalDocumentId'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'RemoveAudit', N'COLUMN',N'RemovalReasonId'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Reason for removal from the PCEHR system' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'RemoveAudit', @level2type=N'COLUMN',@level2name=N'RemovalReasonId'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'RemoveAudit', N'COLUMN',N'AuditInformation'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Supplied audit information about the request for removal' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'RemoveAudit', @level2type=N'COLUMN',@level2name=N'AuditInformation'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'RemoveAudit', N'COLUMN',N'DateCreated'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Date that this record was inserted into the table' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'RemoveAudit', @level2type=N'COLUMN',@level2name=N'DateCreated'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'RemoveAudit', N'COLUMN',N'UserCreated'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'User account that inserted the record' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'RemoveAudit', @level2type=N'COLUMN',@level2name=N'UserCreated'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'RemoveAudit', N'COLUMN',N'DateModified'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Date and time that this record was last modified (or as inserted)' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'RemoveAudit', @level2type=N'COLUMN',@level2name=N'DateModified'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'RemoveAudit', N'COLUMN',N'UserModified'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The account of the user that last modified (or inserted) this record' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'RemoveAudit', @level2type=N'COLUMN',@level2name=N'UserModified'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'RemoveAudit', NULL,NULL))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Record that a user removed a document from the PCEHR.' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'RemoveAudit'
GO
IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_RemoveAudit_ClinicalDocument]') AND parent_object_id = OBJECT_ID(N'[hips].[RemoveAudit]'))
ALTER TABLE [hips].[RemoveAudit]  WITH CHECK ADD  CONSTRAINT [FK_RemoveAudit_ClinicalDocument] FOREIGN KEY([ClinicalDocumentId])
REFERENCES [hips].[ClinicalDocument] ([ClinicalDocumentId])
GO
IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_RemoveAudit_ClinicalDocument]') AND parent_object_id = OBJECT_ID(N'[hips].[RemoveAudit]'))
ALTER TABLE [hips].[RemoveAudit] CHECK CONSTRAINT [FK_RemoveAudit_ClinicalDocument]
GO
IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_RemoveAudit_RemovalReason]') AND parent_object_id = OBJECT_ID(N'[hips].[RemoveAudit]'))
ALTER TABLE [hips].[RemoveAudit]  WITH CHECK ADD  CONSTRAINT [FK_RemoveAudit_RemovalReason] FOREIGN KEY([RemovalReasonId])
REFERENCES [hips].[RemovalReason] ([RemovalReasonId])
GO
IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_RemoveAudit_RemovalReason]') AND parent_object_id = OBJECT_ID(N'[hips].[RemoveAudit]'))
ALTER TABLE [hips].[RemoveAudit] CHECK CONSTRAINT [FK_RemoveAudit_RemovalReason]
GO

SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[hips].[Repository]') AND type in (N'U'))
BEGIN
CREATE TABLE [hips].[Repository](
	[RepositoryId] [int] NOT NULL,
	[Description] [varchar](50) NOT NULL,
	[RepositoryUniqueId] [varchar](100) NULL,
	[DateCreated] [datetime] NOT NULL,
	[UserCreated] [varchar](256) NOT NULL,
	[DateModified] [datetime] NOT NULL,
	[UserModified] [varchar](256) NOT NULL,
 CONSTRAINT [PK_Repository] PRIMARY KEY CLUSTERED 
(
	[RepositoryId] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
END
GO
SET ANSI_PADDING OFF
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'Repository', N'COLUMN',N'Description'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Description (e.g. PCEHR, NPDR)' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'Repository', @level2type=N'COLUMN',@level2name=N'Description'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'Repository', N'COLUMN',N'RepositoryUniqueId'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'AThe OID that identifies the repository' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'Repository', @level2type=N'COLUMN',@level2name=N'RepositoryUniqueId'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'Repository', NULL,NULL))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Identifies an XDS.b repository to which HIPS can upload and remove documents' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'Repository'
GO

SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[hips].[Sex]') AND type in (N'U'))
BEGIN
CREATE TABLE [hips].[Sex](
	[SexId] [int] NOT NULL,
	[Code] [varchar](10) NOT NULL,
	[Description] [varchar](100) NOT NULL,
	[DateCreated] [datetime] NOT NULL,
	[UserCreated] [varchar](256) NOT NULL,
	[DateModified] [datetime] NOT NULL,
	[UserModified] [varchar](256) NOT NULL,
 CONSTRAINT [PK_Sex] PRIMARY KEY CLUSTERED 
(
	[SexId] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
END
GO
SET ANSI_PADDING OFF
GO

SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[hips].[SexCode]') AND type in (N'U'))
BEGIN
CREATE TABLE [hips].[SexCode](
	[SexId] [int] NOT NULL,
	[CodeSystemId] [int] NOT NULL,
	[CodeOverride] [varchar](20) NULL,
	[DateCreated] [datetime] NOT NULL,
	[UserCreated] [varchar](256) NOT NULL,
	[DateModified] [datetime] NOT NULL,
	[UserModified] [varchar](256) NOT NULL,
 CONSTRAINT [PK_SexCode] PRIMARY KEY CLUSTERED 
(
	[SexId] ASC,
	[CodeSystemId] ASC  
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
END
GO
SET ANSI_PADDING OFF
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'SexCode', N'COLUMN',N'SexId'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Sex' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'SexCode', @level2type=N'COLUMN',@level2name=N'SexId'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'SexCode', N'COLUMN',N'CodeSystemId'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Type of identifier' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'SexCode', @level2type=N'COLUMN',@level2name=N'CodeSystemId'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'SexCode', N'COLUMN',N'CodeOverride'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Overrides the sex code in this code system' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'SexCode', @level2type=N'COLUMN',@level2name=N'CodeOverride'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'SexCode', N'COLUMN',N'DateCreated'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Date and Time the record was created' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'SexCode', @level2type=N'COLUMN',@level2name=N'DateCreated'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'SexCode', N'COLUMN',N'UserCreated'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'User that created the record' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'SexCode', @level2type=N'COLUMN',@level2name=N'UserCreated'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'SexCode', N'COLUMN',N'DateModified'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Date and Time the record was modified' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'SexCode', @level2type=N'COLUMN',@level2name=N'DateModified'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'SexCode', N'COLUMN',N'UserModified'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'User that modified the record' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'SexCode', @level2type=N'COLUMN',@level2name=N'UserModified'
GO
IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_SexCode_CodeSystem]') AND parent_object_id = OBJECT_ID(N'[hips].[SexCode]'))
ALTER TABLE [hips].[SexCode]  WITH CHECK ADD  CONSTRAINT [FK_SexCode_CodeSystem] FOREIGN KEY([CodeSystemId])
REFERENCES [hips].[CodeSystem] ([CodeSystemId])
GO
IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_SexCode_CodeSystem]') AND parent_object_id = OBJECT_ID(N'[hips].[SexCode]'))
ALTER TABLE [hips].[SexCode] CHECK CONSTRAINT [FK_SexCode_CodeSystem]
GO
IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_SexCode_Sex]') AND parent_object_id = OBJECT_ID(N'[hips].[SexCode]'))
ALTER TABLE [hips].[SexCode]  WITH CHECK ADD  CONSTRAINT [FK_SexCode_Sex] FOREIGN KEY([SexId])
REFERENCES [hips].[Sex] ([SexId])
GO
IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_SexCode_Sex]') AND parent_object_id = OBJECT_ID(N'[hips].[SexCode]'))
ALTER TABLE [hips].[SexCode] CHECK CONSTRAINT [FK_SexCode_Sex]
GO

SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[hips].[State]') AND type in (N'U'))
BEGIN
CREATE TABLE [hips].[State](
	[StateId] [int] IDENTITY(1,1) NOT NULL,
	[Code] [varchar](10) NOT NULL,
	[Description] [varchar](50) NOT NULL,
	[DateCreated] [datetime] NOT NULL,
	[UserCreated] [varchar](256) NOT NULL,
	[DateModified] [datetime] NOT NULL,
	[UserModified] [varchar](256) NOT NULL,
 CONSTRAINT [PK_State] PRIMARY KEY CLUSTERED 
(
	[StateId] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
END
GO
SET ANSI_PADDING OFF
GO

SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[hips].[StateCode]') AND type in (N'U'))
BEGIN
CREATE TABLE [hips].[StateCode](
	[StateId] [int] NOT NULL,
	[CodeSystemId] [int] NOT NULL,
	[DateCreated] [datetime] NOT NULL,
	[UserCreated] [varchar](256) NOT NULL,
	[DateModified] [datetime] NOT NULL,
	[UserModified] [varchar](256) NOT NULL,
 CONSTRAINT [PK_StateCode] PRIMARY KEY CLUSTERED 
(
	[StateId] ASC,
	[CodeSystemId] ASC  
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
END
GO
SET ANSI_PADDING OFF
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'StateCode', N'COLUMN',N'StateId'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'State' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'StateCode', @level2type=N'COLUMN',@level2name=N'StateId'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'StateCode', N'COLUMN',N'CodeSystemId'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Type of identifier' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'StateCode', @level2type=N'COLUMN',@level2name=N'CodeSystemId'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'StateCode', N'COLUMN',N'DateCreated'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Date and Time the record was created' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'StateCode', @level2type=N'COLUMN',@level2name=N'DateCreated'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'StateCode', N'COLUMN',N'UserCreated'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'User that created the record' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'StateCode', @level2type=N'COLUMN',@level2name=N'UserCreated'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'StateCode', N'COLUMN',N'DateModified'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Date and Time the record was modified' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'StateCode', @level2type=N'COLUMN',@level2name=N'DateModified'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'StateCode', N'COLUMN',N'UserModified'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'User that modified the record' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'StateCode', @level2type=N'COLUMN',@level2name=N'UserModified'
GO
IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_StateCode_CodeSystem]') AND parent_object_id = OBJECT_ID(N'[hips].[StateCode]'))
ALTER TABLE [hips].[StateCode]  WITH CHECK ADD  CONSTRAINT [FK_StateCode_CodeSystem] FOREIGN KEY([CodeSystemId])
REFERENCES [hips].[CodeSystem] ([CodeSystemId])
GO
IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_StateCode_CodeSystem]') AND parent_object_id = OBJECT_ID(N'[hips].[StateCode]'))
ALTER TABLE [hips].[StateCode] CHECK CONSTRAINT [FK_StateCode_CodeSystem]
GO
IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_StateCode_State]') AND parent_object_id = OBJECT_ID(N'[hips].[StateCode]'))
ALTER TABLE [hips].[StateCode]  WITH CHECK ADD  CONSTRAINT [FK_StateCode_State] FOREIGN KEY([StateId])
REFERENCES [hips].[State] ([StateId])
GO
IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_StateCode_State]') AND parent_object_id = OBJECT_ID(N'[hips].[StateCode]'))
ALTER TABLE [hips].[StateCode] CHECK CONSTRAINT [FK_StateCode_State]
GO

SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[hips].[StreetSuffixType]') AND type in (N'U'))
BEGIN
CREATE TABLE [hips].[StreetSuffixType](
	[StreetSuffixTypeId] [int] IDENTITY(1,1) NOT NULL,
	[Code] [char](4) NOT NULL,
	[Description] [varchar](256) NOT NULL,
	[DateCreated] [datetime] NOT NULL,
	[UserCreated] [varchar](256) NOT NULL,
	[DateModified] [datetime] NOT NULL,
	[UserModified] [varchar](256) NOT NULL,
 CONSTRAINT [PK_StreetSuffixType] PRIMARY KEY CLUSTERED 
(
	[StreetSuffixTypeId] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
END
GO
SET ANSI_PADDING OFF
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'StreetSuffixType', N'COLUMN',N'StreetSuffixTypeId'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Identifies a StreetSuffixType.' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'StreetSuffixType', @level2type=N'COLUMN',@level2name=N'StreetSuffixTypeId'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'StreetSuffixType', N'COLUMN',N'Code'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'ABS SACC (4 digits)' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'StreetSuffixType', @level2type=N'COLUMN',@level2name=N'Code'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'StreetSuffixType', N'COLUMN',N'Description'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Description from ABS SACC' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'StreetSuffixType', @level2type=N'COLUMN',@level2name=N'Description'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'StreetSuffixType', N'COLUMN',N'DateCreated'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Date and Time the record was created' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'StreetSuffixType', @level2type=N'COLUMN',@level2name=N'DateCreated'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'StreetSuffixType', N'COLUMN',N'UserCreated'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'User that created the record' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'StreetSuffixType', @level2type=N'COLUMN',@level2name=N'UserCreated'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'StreetSuffixType', N'COLUMN',N'DateModified'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Date and Time the record was modified' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'StreetSuffixType', @level2type=N'COLUMN',@level2name=N'DateModified'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'StreetSuffixType', N'COLUMN',N'UserModified'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'User that modified the record' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'StreetSuffixType', @level2type=N'COLUMN',@level2name=N'UserModified'
GO

SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[hips].[StreetSuffixTypeCode]') AND type in (N'U'))
BEGIN
CREATE TABLE [hips].[StreetSuffixTypeCode](
	[StreetSuffixTypeId] [int] NOT NULL,
	[CodeSystemId] [int] NOT NULL,
	[DateCreated] [datetime] NOT NULL,
	[UserCreated] [varchar](256) NOT NULL,
	[DateModified] [datetime] NOT NULL,
	[UserModified] [varchar](256) NOT NULL,
 CONSTRAINT [PK_StreetSuffixTypeCode] PRIMARY KEY CLUSTERED 
(
	[StreetSuffixTypeId] ASC,
	[CodeSystemId] ASC  
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
END
GO
SET ANSI_PADDING OFF
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'StreetSuffixTypeCode', N'COLUMN',N'StreetSuffixTypeId'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'StreetSuffixType' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'StreetSuffixTypeCode', @level2type=N'COLUMN',@level2name=N'StreetSuffixTypeId'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'StreetSuffixTypeCode', N'COLUMN',N'CodeSystemId'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Type of identifier' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'StreetSuffixTypeCode', @level2type=N'COLUMN',@level2name=N'CodeSystemId'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'StreetSuffixTypeCode', N'COLUMN',N'DateCreated'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Date and Time the record was created' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'StreetSuffixTypeCode', @level2type=N'COLUMN',@level2name=N'DateCreated'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'StreetSuffixTypeCode', N'COLUMN',N'UserCreated'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'User that created the record' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'StreetSuffixTypeCode', @level2type=N'COLUMN',@level2name=N'UserCreated'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'StreetSuffixTypeCode', N'COLUMN',N'DateModified'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Date and Time the record was modified' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'StreetSuffixTypeCode', @level2type=N'COLUMN',@level2name=N'DateModified'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'StreetSuffixTypeCode', N'COLUMN',N'UserModified'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'User that modified the record' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'StreetSuffixTypeCode', @level2type=N'COLUMN',@level2name=N'UserModified'
GO
IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_StreetSuffixTypeCode_CodeSystem]') AND parent_object_id = OBJECT_ID(N'[hips].[StreetSuffixTypeCode]'))
ALTER TABLE [hips].[StreetSuffixTypeCode]  WITH CHECK ADD  CONSTRAINT [FK_StreetSuffixTypeCode_CodeSystem] FOREIGN KEY([CodeSystemId])
REFERENCES [hips].[CodeSystem] ([CodeSystemId])
GO
IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_StreetSuffixTypeCode_CodeSystem]') AND parent_object_id = OBJECT_ID(N'[hips].[StreetSuffixTypeCode]'))
ALTER TABLE [hips].[StreetSuffixTypeCode] CHECK CONSTRAINT [FK_StreetSuffixTypeCode_CodeSystem]
GO
IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_StreetSuffixTypeCode_StreetSuffixType]') AND parent_object_id = OBJECT_ID(N'[hips].[StreetSuffixTypeCode]'))
ALTER TABLE [hips].[StreetSuffixTypeCode]  WITH CHECK ADD  CONSTRAINT [FK_StreetSuffixTypeCode_StreetSuffixType] FOREIGN KEY([StreetSuffixTypeId])
REFERENCES [hips].[StreetSuffixType] ([StreetSuffixTypeId])
GO
IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_StreetSuffixTypeCode_StreetSuffixType]') AND parent_object_id = OBJECT_ID(N'[hips].[StreetSuffixTypeCode]'))
ALTER TABLE [hips].[StreetSuffixTypeCode] CHECK CONSTRAINT [FK_StreetSuffixTypeCode_StreetSuffixType]
GO

SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[hips].[StreetType]') AND type in (N'U'))
BEGIN
CREATE TABLE [hips].[StreetType](
	[StreetTypeId] [int] IDENTITY(1,1) NOT NULL,
	[Code] [char](4) NOT NULL,
	[Description] [varchar](256) NOT NULL,
	[DateCreated] [datetime] NOT NULL,
	[UserCreated] [varchar](256) NOT NULL,
	[DateModified] [datetime] NOT NULL,
	[UserModified] [varchar](256) NOT NULL,
 CONSTRAINT [PK_StreetType] PRIMARY KEY CLUSTERED 
(
	[StreetTypeId] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
END
GO
SET ANSI_PADDING OFF
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'StreetType', N'COLUMN',N'StreetTypeId'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Identifies a StreetType.' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'StreetType', @level2type=N'COLUMN',@level2name=N'StreetTypeId'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'StreetType', N'COLUMN',N'Code'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'ABS SACC (4 digits)' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'StreetType', @level2type=N'COLUMN',@level2name=N'Code'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'StreetType', N'COLUMN',N'Description'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Description from ABS SACC' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'StreetType', @level2type=N'COLUMN',@level2name=N'Description'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'StreetType', N'COLUMN',N'DateCreated'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Date and Time the record was created' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'StreetType', @level2type=N'COLUMN',@level2name=N'DateCreated'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'StreetType', N'COLUMN',N'UserCreated'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'User that created the record' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'StreetType', @level2type=N'COLUMN',@level2name=N'UserCreated'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'StreetType', N'COLUMN',N'DateModified'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Date and Time the record was modified' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'StreetType', @level2type=N'COLUMN',@level2name=N'DateModified'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'StreetType', N'COLUMN',N'UserModified'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'User that modified the record' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'StreetType', @level2type=N'COLUMN',@level2name=N'UserModified'
GO

SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[hips].[StreetTypeCode]') AND type in (N'U'))
BEGIN
CREATE TABLE [hips].[StreetTypeCode](
	[StreetTypeId] [int] NOT NULL,
	[CodeSystemId] [int] NOT NULL,
	[DateCreated] [datetime] NOT NULL,
	[UserCreated] [varchar](256) NOT NULL,
	[DateModified] [datetime] NOT NULL,
	[UserModified] [varchar](256) NOT NULL,
 CONSTRAINT [PK_StreetTypeCode] PRIMARY KEY CLUSTERED 
(
	[StreetTypeId] ASC,
	[CodeSystemId] ASC  
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
END
GO
SET ANSI_PADDING OFF
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'StreetTypeCode', N'COLUMN',N'StreetTypeId'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'StreetType' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'StreetTypeCode', @level2type=N'COLUMN',@level2name=N'StreetTypeId'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'StreetTypeCode', N'COLUMN',N'CodeSystemId'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Type of identifier' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'StreetTypeCode', @level2type=N'COLUMN',@level2name=N'CodeSystemId'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'StreetTypeCode', N'COLUMN',N'DateCreated'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Date and Time the record was created' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'StreetTypeCode', @level2type=N'COLUMN',@level2name=N'DateCreated'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'StreetTypeCode', N'COLUMN',N'UserCreated'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'User that created the record' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'StreetTypeCode', @level2type=N'COLUMN',@level2name=N'UserCreated'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'StreetTypeCode', N'COLUMN',N'DateModified'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Date and Time the record was modified' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'StreetTypeCode', @level2type=N'COLUMN',@level2name=N'DateModified'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'StreetTypeCode', N'COLUMN',N'UserModified'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'User that modified the record' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'StreetTypeCode', @level2type=N'COLUMN',@level2name=N'UserModified'
GO
IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_StreetTypeCode_CodeSystem]') AND parent_object_id = OBJECT_ID(N'[hips].[StreetTypeCode]'))
ALTER TABLE [hips].[StreetTypeCode]  WITH CHECK ADD  CONSTRAINT [FK_StreetTypeCode_CodeSystem] FOREIGN KEY([CodeSystemId])
REFERENCES [hips].[CodeSystem] ([CodeSystemId])
GO
IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_StreetTypeCode_CodeSystem]') AND parent_object_id = OBJECT_ID(N'[hips].[StreetTypeCode]'))
ALTER TABLE [hips].[StreetTypeCode] CHECK CONSTRAINT [FK_StreetTypeCode_CodeSystem]
GO
IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_StreetTypeCode_StreetType]') AND parent_object_id = OBJECT_ID(N'[hips].[StreetTypeCode]'))
ALTER TABLE [hips].[StreetTypeCode]  WITH CHECK ADD  CONSTRAINT [FK_StreetTypeCode_StreetType] FOREIGN KEY([StreetTypeId])
REFERENCES [hips].[StreetType] ([StreetTypeId])
GO
IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_StreetTypeCode_StreetType]') AND parent_object_id = OBJECT_ID(N'[hips].[StreetTypeCode]'))
ALTER TABLE [hips].[StreetTypeCode] CHECK CONSTRAINT [FK_StreetTypeCode_StreetType]
GO

SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[hips].[Suffix]') AND type in (N'U'))
BEGIN
CREATE TABLE [hips].[Suffix](
	[SuffixId] [int] IDENTITY(1,1) NOT NULL,
	[Code] [varchar](10) NOT NULL,
	[Description] [varchar](100) NOT NULL,
	[DateCreated] [datetime] NULL,
	[UserCreated] [varchar](256) NULL,
	[DateModified] [datetime] NULL,
	[UserModified] [varchar](256) NULL,
 CONSTRAINT [PK_Suffix] PRIMARY KEY CLUSTERED 
(
	[SuffixId] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
END
GO
SET ANSI_PADDING OFF
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'Suffix', N'COLUMN',N'SuffixId'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Identifies a name suffix' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'Suffix', @level2type=N'COLUMN',@level2name=N'SuffixId'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'Suffix', N'COLUMN',N'Code'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Parts of the name to consider as Suffixes (e.g. JR, SR, JNR, SNR)' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'Suffix', @level2type=N'COLUMN',@level2name=N'Code'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'Suffix', N'COLUMN',N'Description'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Preferred display format for the suffix' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'Suffix', @level2type=N'COLUMN',@level2name=N'Description'
GO

SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[hips].[SystemErrorLog]') AND type in (N'U'))
BEGIN
CREATE TABLE [hips].[SystemErrorLog](
	[SystemErrorLogId] [int] IDENTITY(1,1) NOT NULL,
	[LogMessageId] [int] NOT NULL,
	[Message] [varchar](200) NOT NULL,
	[ExceptionMessage] [varchar](500) NULL,	
	[DateModified] [datetime] NOT NULL,
	[UserModified] [varchar](256) NOT NULL,
	[DateCreated] [datetime] NOT NULL,
	[UserCreated] [varchar](256) NOT NULL,
 CONSTRAINT [PK_SystemErrorLog] PRIMARY KEY CLUSTERED 
(
	[SystemErrorLogId] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
END
GO
IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_SystemErrorLog_LogMessage]') AND parent_object_id = OBJECT_ID(N'[hips].[SystemErrorLog]'))
ALTER TABLE [hips].[SystemErrorLog]  WITH CHECK ADD  CONSTRAINT [FK_SystemErrorLog_LogMessage] FOREIGN KEY([LogMessageId])
REFERENCES [hips].[LogMessage] ([LogMessageId])
GO
IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_SystemErrorLog_LogMessage]') AND parent_object_id = OBJECT_ID(N'[hips].[SystemErrorLog]'))
ALTER TABLE [hips].[SystemErrorLog] CHECK CONSTRAINT [FK_SystemErrorLog_LogMessage]
GO
SET ANSI_PADDING OFF
GO

SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[hips].[Title]') AND type in (N'U'))
BEGIN
CREATE TABLE [hips].[Title](
	[TitleId] [int] IDENTITY(1,1) NOT NULL,
	[Code] [varchar](10) NOT NULL,
	[Description] [varchar](100) NOT NULL,
	[DateCreated] [datetime] NOT NULL,
	[UserCreated] [varchar](256) NOT NULL,
	[DateModified] [datetime] NOT NULL,
	[UserModified] [varchar](256) NOT NULL,
 CONSTRAINT [PK_Title] PRIMARY KEY CLUSTERED 
(
	[TitleId] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
END
GO
SET ANSI_PADDING OFF
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'Title', N'COLUMN',N'TitleId'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Identifies a name title.' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'Title', @level2type=N'COLUMN',@level2name=N'TitleId'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'Title', N'COLUMN',N'Code'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Parts of the name to consider as Titles (e.g. DR, MISS, MR, MRS, MS, PROF)' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'Title', @level2type=N'COLUMN',@level2name=N'Code'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'Title', N'COLUMN',N'Description'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Description from ISAAC' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'Title', @level2type=N'COLUMN',@level2name=N'Description'
GO

SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[hips].[UnitType]') AND type in (N'U'))
BEGIN
CREATE TABLE [hips].[UnitType](
	[UnitTypeId] [int] IDENTITY(1,1) NOT NULL,
	[Code] [char](4) NOT NULL,
	[Description] [varchar](256) NOT NULL,
	[DateCreated] [datetime] NOT NULL,
	[UserCreated] [varchar](256) NOT NULL,
	[DateModified] [datetime] NOT NULL,
	[UserModified] [varchar](256) NOT NULL,
 CONSTRAINT [PK_UnitType] PRIMARY KEY CLUSTERED 
(
	[UnitTypeId] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
END
GO
SET ANSI_PADDING OFF
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'UnitType', N'COLUMN',N'UnitTypeId'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Identifies a UnitType.' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'UnitType', @level2type=N'COLUMN',@level2name=N'UnitTypeId'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'UnitType', N'COLUMN',N'Code'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'ABS SACC (4 digits)' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'UnitType', @level2type=N'COLUMN',@level2name=N'Code'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'UnitType', N'COLUMN',N'Description'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Description from ABS SACC' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'UnitType', @level2type=N'COLUMN',@level2name=N'Description'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'UnitType', N'COLUMN',N'DateCreated'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Date and Time the record was created' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'UnitType', @level2type=N'COLUMN',@level2name=N'DateCreated'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'UnitType', N'COLUMN',N'UserCreated'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'User that created the record' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'UnitType', @level2type=N'COLUMN',@level2name=N'UserCreated'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'UnitType', N'COLUMN',N'DateModified'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Date and Time the record was modified' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'UnitType', @level2type=N'COLUMN',@level2name=N'DateModified'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'UnitType', N'COLUMN',N'UserModified'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'User that modified the record' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'UnitType', @level2type=N'COLUMN',@level2name=N'UserModified'
GO

SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[hips].[UnitTypeCode]') AND type in (N'U'))
BEGIN
CREATE TABLE [hips].[UnitTypeCode](
	[UnitTypeId] [int] NOT NULL,
	[CodeSystemId] [int] NOT NULL,
	[DateCreated] [datetime] NOT NULL,
	[UserCreated] [varchar](256) NOT NULL,
	[DateModified] [datetime] NOT NULL,
	[UserModified] [varchar](256) NOT NULL,
 CONSTRAINT [PK_UnitTypeCode] PRIMARY KEY CLUSTERED 
(
	[UnitTypeId] ASC,
	[CodeSystemId] ASC  
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
END
GO
SET ANSI_PADDING OFF
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'UnitTypeCode', N'COLUMN',N'UnitTypeId'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'UnitType' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'UnitTypeCode', @level2type=N'COLUMN',@level2name=N'UnitTypeId'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'UnitTypeCode', N'COLUMN',N'CodeSystemId'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Type of identifier' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'UnitTypeCode', @level2type=N'COLUMN',@level2name=N'CodeSystemId'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'UnitTypeCode', N'COLUMN',N'DateCreated'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Date and Time the record was created' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'UnitTypeCode', @level2type=N'COLUMN',@level2name=N'DateCreated'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'UnitTypeCode', N'COLUMN',N'UserCreated'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'User that created the record' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'UnitTypeCode', @level2type=N'COLUMN',@level2name=N'UserCreated'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'UnitTypeCode', N'COLUMN',N'DateModified'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Date and Time the record was modified' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'UnitTypeCode', @level2type=N'COLUMN',@level2name=N'DateModified'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'UnitTypeCode', N'COLUMN',N'UserModified'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'User that modified the record' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'UnitTypeCode', @level2type=N'COLUMN',@level2name=N'UserModified'
GO
IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_UnitTypeCode_CodeSystem]') AND parent_object_id = OBJECT_ID(N'[hips].[UnitTypeCode]'))
ALTER TABLE [hips].[UnitTypeCode]  WITH CHECK ADD  CONSTRAINT [FK_UnitTypeCode_CodeSystem] FOREIGN KEY([CodeSystemId])
REFERENCES [hips].[CodeSystem] ([CodeSystemId])
GO
IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_UnitTypeCode_CodeSystem]') AND parent_object_id = OBJECT_ID(N'[hips].[UnitTypeCode]'))
ALTER TABLE [hips].[UnitTypeCode] CHECK CONSTRAINT [FK_UnitTypeCode_CodeSystem]
GO
IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_UnitTypeCode_UnitType]') AND parent_object_id = OBJECT_ID(N'[hips].[UnitTypeCode]'))
ALTER TABLE [hips].[UnitTypeCode]  WITH CHECK ADD  CONSTRAINT [FK_UnitTypeCode_UnitType] FOREIGN KEY([UnitTypeId])
REFERENCES [hips].[UnitType] ([UnitTypeId])
GO
IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_UnitTypeCode_UnitType]') AND parent_object_id = OBJECT_ID(N'[hips].[UnitTypeCode]'))
ALTER TABLE [hips].[UnitTypeCode] CHECK CONSTRAINT [FK_UnitTypeCode_UnitType]
GO

/****** Object:  Table [puma].[PatientMasterOverride]    Script Date: 06/20/2013 10:07:16 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[puma].[PatientMasterOverride]') AND type in (N'U'))
BEGIN
CREATE TABLE [puma].[PatientMasterOverride](
	[PatientMasterId] [int] NOT NULL,
	[MedicareNumber] [varchar](12) NULL,
	[IsMedicareNumberValid] [bit] NULL,
	[MedicareIrn] [varchar](3) NULL,
	[DvaNumber] [varchar](18) NULL,
	[DateOfBirth] [datetime] NULL,
	[DateCreated] [datetime] NOT NULL,
	[UserCreated] [varchar](256) NOT NULL,
	[DateModified] [datetime] NOT NULL,
	[UserModified] [varchar](256) NOT NULL
 CONSTRAINT [PK_PatientMasterOverride_1] PRIMARY KEY CLUSTERED 
(
	[PatientMasterId] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
END
GO

SET ANSI_PADDING OFF
GO

IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[puma].[FK_PatientMasterOverride_PatientMaster]') AND parent_object_id = OBJECT_ID(N'[puma].[PatientMasterOverride]'))
ALTER TABLE [puma].[PatientMasterOverride]  WITH CHECK ADD CONSTRAINT [FK_PatientMasterOverride_PatientMaster] FOREIGN KEY([PatientMasterId])
REFERENCES [hips].[PatientMaster] ([PatientMasterId])
GO
IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[puma].[FK_PatientMasterOverride_PatientMaster]') AND parent_object_id = OBJECT_ID(N'[puma].[PatientMasterOverride]'))
ALTER TABLE [puma].[PatientMasterOverride] CHECK CONSTRAINT [FK_PatientMasterOverride_PatientMaster]
GO

