﻿#region Using Directives

using System;
using System.ServiceModel;
using HIPS.CommonSchemas;
using HIPS.CommonSchemas.PatientIdentifier;
using HIPS.IhiSchemas.Schemas;
using HIPS.ServiceContracts.ServiceInterfaces;

#endregion Using Directives

namespace HIPS.Client.Proxy
{
    /// <summary>
    ///
    /// </summary>
    public class IHIProxy : ClientBase<IIHIService>, IIHIService
    {
        /// <summary>
        /// Initializes a new instance of the <see cref="IHIProxy"/> class.
        /// </summary>
        /// <param name="endpointName">The endpoint configuration name</param>
        public IHIProxy(string endpointName)
            : base(endpointName)
        {
        }

        /// <summary>
        /// Obtains validated IHI information for use in a clinical document.
        /// </summary>
        /// <param name="patientIdentifier">Patient Identifier (Mrn, StatePatientId, ValidatedIhi or PatientMasterId)</param>
        /// <param name="dateOfBirth">Date of Birth</param>
        /// <param name="user">User Details</param>
        /// <returns>Validated IHI Information</returns>
        public ValidatedIhiResponse GetValidatedIhi(PatientIdentifierBase patientIdentifier, DateTime dateOfBirth, UserDetails user)
        {
            return Channel.GetValidatedIhi(patientIdentifier, dateOfBirth, user);
        }

        //public IhiSearchResponse IhiSearchByMrn(string hospitalIdentifier, string codeSystemName, string mrn, DateTime dateOfBirth, UserDetails user)
        //{
        //    return Channel.IhiSearchByMrn(hospitalIdentifier, codeSystemName, mrn, dateOfBirth, user);
        //}
    }
}