﻿#region Using Directives

using System.ServiceModel;
using HIPS.CommonSchemas;
using HIPS.IhiSchemas.Schemas;
using HIPS.ServiceContracts.ServiceInterfaces;

#endregion Using Directives

namespace HIPS.Client.Proxy
{
    /// <summary>
    ///
    /// </summary>
    public class PumaInterfaceProxy : ClientBase<IPumaInterfaceService>, IPumaInterfaceService
    {
        /// <summary>
        /// Default constructor
        /// </summary>
        /// <param name="endpointName">The configured endpoint name</param>
        public PumaInterfaceProxy(string endpointName)
            : base(endpointName)
        {
        }

        public HipsIhiResponse IHISearchByNumber(int hospitalId, IhiSearchCriteria searchDetails, UserDetails user)
        {
            return Channel.IHISearchByNumber(hospitalId, searchDetails, user);
        }

        public HipsIhiResponse IHISearchByNumberAndPCEHRCheck(int hospitalId, IhiSearchCriteria searchDetails, UserDetails user)
        {
            return Channel.IHISearchByNumberAndPCEHRCheck(hospitalId, searchDetails, user);
        }
    }
}