﻿using System;

namespace HIPS.CommonSchemas.Exceptions
{
    /// <summary>
    /// Indicates an error returned by the PCEHR System.
    /// </summary>
    public class PcehrServiceException : Exception
    {
        /// <summary>
        /// Creates an exception indicating an error returned by the PCEHR System.
        /// </summary>
        /// <param name="response">The HIPS response from the HI business logic.</param>
        public PcehrServiceException(HipsResponse response)
            : base(response.HipsErrorMessage)
        {
            this.ResponseCode = response.ResponseCode;
            this.ResponseCodeDescription = response.ResponseCodeDescription;
            this.ResponseCodeDetails = response.ResponseCodeDetails;
        }

        /// <summary>
        /// Gets the PCEHR System response code.
        /// </summary>
        public string ResponseCode { get; internal set; }

        /// <summary>
        /// Gets the PCEHR System response code description.
        /// </summary>
        public string ResponseCodeDescription { get; internal set; }

        /// <summary>
        /// Gets the PCEHR System response code details.
        /// </summary>
        public string ResponseCodeDetails { get; internal set; }
    }
}