﻿using System;
using System.Runtime.Serialization;
using HIPS.CommonSchemas;
using nehta.mcaR50.ProviderSearchForProviderIndividual;

namespace HIPS.HpiiSchemas
{
    /// <summary>
    /// This class is used for the Batch Asynchronous Submitting Response of the HPI-I Queries for identifier and demographic searches
    /// </summary>

    [KnownType(typeof(HpiiBatchAsyncSubmitResponse))]
    [Serializable]
    [DataContract]
    public class HpiiBatchAsyncSubmitResponse
    {
        #region Private Members

        private string batchIdentifier;
        private HipsResponse hipsResponse = new HipsResponse(HipsResponseIndicator.SystemError, null);
        private ServiceMessagesType serviceMessagesType;

        #endregion Private Members

        #region Properties

        /// <summary>
        /// Gets or sets the BatchIdentifier
        /// </summary>
        /// <value>
        /// The batchIdentifier
        /// </value>
        [DataMember]
        public string BatchIdentifier
        {
            get { return batchIdentifier; }
            set { batchIdentifier = value; }
        }

        /// <summary>
        /// Gets or sets the ServiceMessagesType
        /// </summary>
        /// <value>
        /// The serviceMessagesType
        /// </value>
        [DataMember]
        public HipsResponse HipsResponse
        {
            get { return hipsResponse; }
            set { hipsResponse = value; }
        }

        /// <summary>
        /// Gets or sets the ServiceMessagesType
        /// </summary>
        /// <value>
        /// The serviceMessagesType
        /// </value>
        [DataMember]
        public ServiceMessagesType ServiceMessagesType
        {
            get { return serviceMessagesType; }
            set { serviceMessagesType = value; }
        }

        #endregion Properties
    }
}