﻿using System.Data.SqlClient;
using HIPS.Common.PcehrDataStore.DataAccess;
using HIPS.CommonSchemas;
using HIPS.PcehrDataStore.Schemas;

namespace HIPS.PcehrDataStore.DataAccess
{
    /// <summary>
    /// This class allows access to the PcehrAudit table
    /// </summary>
    public class PcehrAuditDl : BaseDl
    {
        #region Constructors

        public PcehrAuditDl(UserDetails user)
            : base(user)
        {
        }

        #endregion Constructors

        #region Methods

        /// <summary>
        /// Inserts the specified PCEHR audit record.
        /// </summary>
        /// <param name="PcehrAudit">The PCEHR audit record.</param>
        /// <returns>Whether the record was inserted</returns>
        public bool Insert(PcehrAudit pcehrAudit)
        {
            using (SqlCommand command = GetSqlCommand("hips.PcehrAuditInsert"))
            {
                return base.Insert<PcehrAudit>(pcehrAudit, command);
            }
        }

        #endregion Methods
    }
}