﻿using System;
using System.Collections.Generic;
using System.Data.SqlClient;
using HIPS.Common.DataStore.DataAccess;
using HIPS.Common.PcehrDataStore.DataAccess;
using HIPS.PcehrDataStore.Schemas;
using HIPS.PcehrDataStore.Schemas.Enumerators;

namespace HIPS.PcehrDataStore.DataAccess
{
    /// <summary>
    /// This class allows access to the Sex table
    /// </summary>
    public class SexDl : BaseDl
    {
        #region Methods

        /// <summary>
        /// Gets the specified Sex id.
        /// </summary>
        /// <param name="SexId">The Sex id.</param>
        /// <returns></returns>
        public Sex Get(int SexId)
        {
            Sex result = new Sex();
            try
            {
                using (SqlCommand command = GetSqlCommand("hips.SexGet"))
                {
                    command.Parameters.Add(new SqlParameter("@SexId", SexId));
                    PopulateBusinessObject<Sex>(command.ExecuteReader(), result);
                    command.Connection.Close();
                }
            }
            catch (Exception ex)
            {
                EventLogger.WriteLog(ConstantsResource.ErrorMessageSexGet, ex, User, LogMessage.HIPS_MESSAGE_031);
            }
            return result;
        }

        /// <summary>
        /// Gets all.
        /// </summary>
        /// <returns></returns>
        public List<Sex> GetAll()
        {
            return GetAll(null);
        }

        /// <summary>
        /// Gets all.
        /// </summary>
        /// <returns></returns>
        public List<Sex> GetAll(DateTime? lastUpdated)
        {
            List<Sex> results = new List<Sex>();
            try
            {
                using (SqlCommand command = GetSqlCommand("hips.SexGet"))
                {
                    if (lastUpdated.HasValue)
                    {
                        command.Parameters.Add(new SqlParameter("@DateModified", lastUpdated));
                    }
                    results = GetPopulatedBusinessList<Sex>(command.ExecuteReader());
                    command.Connection.Close();
                }
            }
            catch (Exception ex)
            {
                EventLogger.WriteLog(ConstantsResource.ErrorMessageSexGet, ex, User, LogMessage.HIPS_MESSAGE_030);
            }
            return results;
        }

        #endregion Methods
    }
}