﻿using System;
using System.Runtime.Serialization;
using HIPS.Base.Schemas;
using BaseEnumerators = HIPS.Base.Schemas.Enumerators;

namespace HIPS.PcehrDataStore.Schemas
{
    /// <summary>
    /// This class represents a downloaded clinical document
    /// </summary>
    [KnownType(typeof(DownloadedDocument))]
    [Serializable]
    [DataContract]
    public class DownloadedDocument : BaseSchema
    {
        #region Private Members

        private int patientMasterId;
        private string sourceSystemDocumentId;
        private byte[] package;
        private DateTime downloadedDate;
        private int clinicalDocumentStatusId;
        private string clinicalDocumentStatusDescription;
        private int? currentDocumentId;

        #endregion Private Members

        #region Properties

        /// <summary>
        /// Gets or sets the downloaded document ID.
        /// </summary>
        /// <value>
        /// The downloaded document ID.
        /// </value>
        [DataMember]
        [DataBaseInfoAttributes(BaseEnumerators.DatabaseColumnType.AutoGeneratedKey)]
        public int? DownloadedDocumentId
        {
            get
            {
                return base.Id;
            }
            set
            {
                base.Id = value;
            }
        }

        /// <summary>
        /// Gets or sets the document type id.
        /// </summary>
        /// <value>
        /// The document type id.
        /// </value>
        [DataMember]
        [DataBaseInfoAttributes(BaseEnumerators.DatabaseColumnType.AutoGeneratedKey)]
        public int? DocumentTypeId
        {
            get
            {
                return base.Id;
            }
            set
            {
                base.Id = value;
            }
        }

        /// <summary>
        /// Gets or sets the patient master id.
        /// </summary>
        /// <value>
        /// The patient master id.
        /// </value>
        [DataMember]
        [DataBaseInfoAttributes(BaseEnumerators.DatabaseColumnType.Data)]
        public int PatientMasterId
        {
            get
            {
                return patientMasterId;
            }
            set
            {
                patientMasterId = value;

#if PUMA_CLIENT
                RaisePropertyChanged(() => PatientMasterId);
#endif
            }
        }

        /// <summary>
        /// Gets or sets the source system document id.
        /// </summary>
        /// <value>
        /// The source system document id.
        /// </value>
        [DataMember]
        [DataBaseInfoAttributes(BaseEnumerators.DatabaseColumnType.Data)]
        public string SourceSystemDocumentId
        {
            get
            {
                return sourceSystemDocumentId;
            }
            set
            {
                sourceSystemDocumentId = value;
#if PUMA_CLIENT
                RaisePropertyChanged(() => SourceSystemDocumentId);
#endif
            }
        }

        /// <summary>
        /// Gets or sets the package (zip file containing the document and its attachments.
        /// </summary>
        /// <value>
        /// The package.
        /// </value>
        [DataMember]
        [DataBaseInfoAttributes(BaseEnumerators.DatabaseColumnType.Data)]
        public byte[] Package
        {
            get
            {
                return package;
            }
            set
            {
                package = value;
#if PUMA_CLIENT
                RaisePropertyChanged(() => Package);
#endif
            }
        }

        /// <summary>
        /// Gets or sets the downloaded date.
        /// </summary>
        /// <value>
        /// The downloaded date.
        /// </value>
        [DataMember]
        [DataBaseInfoAttributes(BaseEnumerators.DatabaseColumnType.Data)]
        public DateTime DownloadedDate
        {
            get
            {
                return downloadedDate;
            }
            set
            {
                downloadedDate = value;
#if PUMA_CLIENT
                RaisePropertyChanged(() => DownloadedDate);
#endif
            }
        }

        /// <summary>
        /// Gets or sets the clinical document status id.
        /// </summary>
        /// <value>
        /// The clinical document status id.
        /// </value>
        [DataMember]
        [DataBaseInfoAttributes(BaseEnumerators.DatabaseColumnType.Data)]
        public int ClinicalDocumentStatusId
        {
            get
            {
                return clinicalDocumentStatusId;
            }
            set
            {
                clinicalDocumentStatusId = value;
#if PUMA_CLIENT
                RaisePropertyChanged(() => ClinicalDocumentStatusId);
#endif
            }
        }

        /// <summary>
        /// Gets or sets the clinical document status description.
        /// </summary>
        /// <value>
        /// The clinical document status description.
        /// </value>
        [DataMember]
        [DataBaseInfoAttributes(BaseEnumerators.DatabaseColumnType.ReadOnlyData)]
        public string ClinicalDocumentStatusDescription
        {
            get
            {
                return clinicalDocumentStatusDescription;
            }
            set
            {
                clinicalDocumentStatusDescription = value;
#if PUMA_CLIENT
                RaisePropertyChanged(() => ClinicalDocumentStatusDescription);
#endif
            }
        }

        /// <summary>
        /// Gets or sets the current document id, where this document has been superseded.
        /// </summary>
        /// <value>
        /// The current document id.
        /// </value>
        [DataMember]
        [DataBaseInfoAttributes(BaseEnumerators.DatabaseColumnType.Data)]
        public int? CurrentDocumentId
        {
            get
            {
                return currentDocumentId;
            }
            set
            {
                currentDocumentId = value;
#if PUMA_CLIENT
                RaisePropertyChanged(() => CurrentDocumentId);
#endif
            }
        }

        #endregion Properties
    }
}