﻿using System;
using HIPS.Base.Schemas;
using HIPS.Base.Schemas.Enumerators;

namespace HIPS.PcehrDataStore.Schemas
{
    /// <summary>
    /// Represents the data returned from the database for a patient in hospital.
    /// </summary>
    public class EpisodePatientExtendedDetails
    {
        /// <summary>
        /// The admission date of the patient.
        /// </summary>
        [DataBaseInfoAttributes(DatabaseColumnType.ReadOnlyData)]
        public DateTime AdmissionDate { get; set; }

        /// <summary>
        /// The admission reason of the patient.
        /// </summary>
        [DataBaseInfoAttributes(DatabaseColumnType.ReadOnlyData)]
        public string AdmissionReason { get; set; }

        /// <summary>
        /// The current Bed of the patient.
        /// </summary>
        [DataBaseInfoAttributes(DatabaseColumnType.ReadOnlyData)]
        public string Bed { get; set; }

        /// <summary>
        /// Whether the patient has withdrawn consent for the most recent matching episode.
        /// </summary>
        [DataBaseInfoAttributes(DatabaseColumnType.ReadOnlyData)]
        public bool? ConsentWithdrawn { get; set; }

        /// <summary>
        /// The patients's current sex identifier.
        /// </summary>
        [DataBaseInfoAttributes(DatabaseColumnType.ReadOnlyData)]
        public int CurrentSexId { get; set; }

        /// <summary>
        /// The patients's Date of Birth.
        /// </summary>
        [DataBaseInfoAttributes(DatabaseColumnType.ReadOnlyData)]
        public DateTime DateOfBirth { get; set; }

        /// <summary>
        /// The discharge date of the patient.
        /// </summary>
        [DataBaseInfoAttributes(DatabaseColumnType.ReadOnlyData)]
        public DateTime? DischargeDate { get; set; }

        /// <summary>
        /// The patients's DVA Number.
        /// </summary>
        [DataBaseInfoAttributes(DatabaseColumnType.ReadOnlyData)]
        public string DvaNumber { get; set; }

        /// <summary>
        /// The Episode
        /// </summary>
        public int EpisodeId { get; set; }

        /// <summary>
        /// The patients's family name.
        /// </summary>
        [DataBaseInfoAttributes(DatabaseColumnType.ReadOnlyData)]
        public string FamilyName { get; set; }

        /// <summary>
        /// The patient's given names.
        /// </summary>
        [DataBaseInfoAttributes(DatabaseColumnType.ReadOnlyData)]
        public string GivenNames { get; set; }

        /// <summary>
        /// The hospital code of the hospital in which the patient is or was admitted.
        /// </summary>
        [DataBaseInfoAttributes(DatabaseColumnType.ReadOnlyData)]
        public string HospitalCode { get; set; }

        /// <summary>
        /// The primary key of the hospital in which the patient is or was admitted.
        /// </summary>
        [DataBaseInfoAttributes(DatabaseColumnType.ReadOnlyData)]
        public int HospitalId { get; set; }

        /// <summary>
        /// The name of the hospital in which the patient is or was admitted.
        /// </summary>
        [DataBaseInfoAttributes(DatabaseColumnType.ReadOnlyData)]
        public string HospitalName { get; set; }

        /// <summary>
        /// The patients's Medicare IRN.
        /// </summary>
        [DataBaseInfoAttributes(DatabaseColumnType.ReadOnlyData)]
        public string MedicareIrn { get; set; }

        /// <summary>
        /// The patients's Medicare Number.
        /// </summary>
        [DataBaseInfoAttributes(DatabaseColumnType.ReadOnlyData)]
        public string MedicareNumber { get; set; }

        /// <summary>
        /// The patient's MRN at the hospital where the patient was admitted.
        /// </summary>
        [DataBaseInfoAttributes(DatabaseColumnType.ReadOnlyData)]
        public string Mrn { get; set; }

        /// <summary>
        /// The family name of the patient's responsible provider.
        /// </summary>
        [DataBaseInfoAttributes(DatabaseColumnType.ReadOnlyData)]
        public string ResponsibleProviderFamilyName { get; set; }

        /// <summary>
        /// The given names of the patient's responsible provider.
        /// </summary>
        [DataBaseInfoAttributes(DatabaseColumnType.ReadOnlyData)]
        public string ResponsibleProviderGivenNames { get; set; }

        /// <summary>
        /// The identifier of the patient's responsible provider.
        /// </summary>
        [DataBaseInfoAttributes(DatabaseColumnType.ReadOnlyData)]
        public string ResponsibleProviderIdentifier { get; set; }

        /// <summary>
        /// The suffix of the patient's responsible provider (such as 'Jr' or 'Sr')
        /// </summary>
        [DataBaseInfoAttributes(DatabaseColumnType.ReadOnlyData)]
        public string ResponsibleProviderSuffix { get; set; }

        /// <summary>
        /// The title of the patient's responsible provider (such as 'Dr', 'Ms' or 'Mr').
        /// </summary>
        [DataBaseInfoAttributes(DatabaseColumnType.ReadOnlyData)]
        public string ResponsibleProviderTitle { get; set; }

        /// <summary>
        /// The current Room of the patient.
        /// </summary>
        [DataBaseInfoAttributes(DatabaseColumnType.ReadOnlyData)]
        public string Room { get; set; }

        /// <summary>
        /// The source system episode id (visit number) for the patient
        /// </summary>
        [DataBaseInfoAttributes(DatabaseColumnType.ReadOnlyData)]
        public string SourceSystemEpisodeId { get; set; }

        /// <summary>
        /// The patient's name suffixes (like "Jr")
        /// </summary>
        [DataBaseInfoAttributes(DatabaseColumnType.ReadOnlyData)]
        public string Suffix { get; set; }

        /// <summary>
        /// The patients's titles (like "Dr", "Ms" or "Mr")
        /// </summary>
        [DataBaseInfoAttributes(DatabaseColumnType.ReadOnlyData)]
        public string Title { get; set; }

        /// <summary>
        /// The current Ward of the patient.
        /// </summary>
        [DataBaseInfoAttributes(DatabaseColumnType.ReadOnlyData)]
        public string Ward { get; set; }

        /// <summary>
        /// Withdrawal consent Audit Information
        /// </summary>
        [DataBaseInfoAttributes(DatabaseColumnType.ReadOnlyData)]
        public byte[] WithdrawalAuditInformation { get; set; }
    }
}