﻿using HIPS.Base.Schemas;
using HIPS.Base.Schemas.Enumerators;

namespace HIPS.PcehrDataStore.Schemas
{
    /// <summary>
    /// Represents the data returned from the database for a single local clinical document from the local document store
    /// </summary>

    public class LocalClinicalDocument
    {
        /// <summary>
        /// Gets or sets the Document
        /// </summary>
        /// <value>
        /// The document
        /// </value>
        public byte[] Document { get; set; }

        /// <summary>
        /// LocalClinicalDocumentMetaData
        /// </summary>
        [DataBaseInfoAttributes(DatabaseColumnType.ReadOnlyData)]
        public LocalClinicalDocumentMetaData LocalClinicalDocumentMetaData { get; set; }

        /// <summary>
        /// Document Package
        /// </summary>
        [DataBaseInfoAttributes(DatabaseColumnType.ReadOnlyData)]
        public byte[] Package { get; set; }
    }
}