﻿using System.Collections.Generic;
using System.ServiceModel;
using HIPS.CommonSchemas.Hi;

namespace HIPS.Reference.ServiceContracts
{
    /// <summary>
    /// Service interface for the Healthcare Identifier Reference Service.
    /// </summary>
    [WCFExtras.Wsdl.Documentation.XmlComments]
    [ServiceContract(Namespace = "http://schemas.HIPS/Services/2012/01", Name = "IHiReferenceService")]
    public interface IHiReferenceService
    {
        /// <summary>
        /// Gets the Country List.
        /// </summary>
        /// <returns></returns>
        [OperationContract]
        List<HiCountry> GetHiCountries();

        /// <summary>
        /// Gets the LevelType List.
        /// </summary>
        /// <returns></returns>
        [OperationContract]
        List<HiLevelType> GetHiLevelTypes();

        /// <summary>
        /// Gets the PostalDeliveryType List.
        /// </summary>
        /// <returns></returns>
        [OperationContract]
        List<HiPostalDeliveryType> GetHiPostalDeliveryTypes();

        /// <summary>
        /// Gets the Sex List.
        /// </summary>
        /// <returns></returns>
        [OperationContract]
        List<HiSex> GetHiSexes();

        /// <summary>
        /// Gets the State List.
        /// </summary>
        /// <returns></returns>
        [OperationContract]
        List<HiState> GetHiStates();

        /// <summary>
        /// Gets the StreetSuffixTypes List.
        /// </summary>
        /// <returns></returns>
        [OperationContract]
        List<HiStreetSuffixType> GetHiStreetSuffixTypes();

        /// <summary>
        /// Gets the StreetType List.
        /// </summary>
        /// <returns></returns>
        [OperationContract]
        List<HiStreetType> GetHiStreetTypes();

        /// <summary>
        /// Gets the UnitType List.
        /// </summary>
        /// <returns></returns>
        [OperationContract]
        List<HiUnitType> GetHiUnitTypes();
    }
}