﻿namespace HIPS.ServiceContracts.Common
{
    /// <summary>
    /// Contains constants used throughout service contracts.
    /// </summary>
    public class Constants
    {
        /// <summary>
        /// Service namespaces.
        /// </summary>
        public class ServiceNamespace
        {
            /// <summary>
            /// HIPS Assisted Registration service namespace, version 1.
            /// </summary>
            public const string ASSISTED_REGISTRATION_V1 = "http://nehta.hips/2014/03/assistedRegistration";

            /// <summary>
            /// HIPS CDA service namespace, version 1.
            /// </summary>
            public const string CDA_V1 = "http://nehta.hips/2014/03/cda";

            /// <summary>
            /// HIPS common service namespace, version 1.
            /// </summary>
            public const string COMMON_V1 = "http://nehta.hips/2014/03";

            /// <summary>
            /// HIPS Consent service namespace, version 1.
            /// </summary>
            public const string CONSENT_V1 = "http://nehta.hips/2014/03/consent";

            /// <summary>
            /// HIPS Database Loader service namespace, version 1.
            /// </summary>
            public const string DATABASE_LOADER_V1 = "http://nehta.hips/2014/03/databaseLoader";

            /// <summary>
            /// HIPS IHI service namespace, version 1.
            /// </summary>
            public const string IHI_V1 = "http://nehta.hips/2014/03/ihi";

            /// <summary>
            /// HIPS Patient service namespace, version 1.
            /// </summary>
            public const string PATIENT_V1 = "http://nehta.hips/2012/01/patient";

            /// <summary>
            /// HIPS Patient service namespace, version 2.
            /// </summary>
            public const string PATIENT_V2 = "http://nehta.hips/2014/03/patient";

            /// <summary>
            /// HIPS PCEHR service namespace, version 2.
            /// </summary>
            public const string PCEHR_V2 = "http://nehta.hips/2014/03/pcehr";
        
            /// <summary>
            /// HIPS HPI-I service namespace, version 2.
            /// </summary>
            public const string HPII_V2 = "http://nehta.hips/2014/03/hpii";
        }

        /// <summary>
        /// The range of supported dates for DateTimeRangeValidator attributes.
        /// </summary>
        public class SupportedDates
        {
            /// <summary>
            /// The latest supported date and time. Must be in ISO 8601 format.
            /// </summary>
            public const string MAXIMUM = "9999-12-31T23:59:59";

            /// <summary>
            /// The earliest supported date and time. Must be in ISO 8601 format.
            /// </summary>
            public const string MINIMUM = "1753-01-01T00:00:00";
        }
    }
}