﻿using System.ServiceModel;
using HIPS.ServiceContracts.Common.Fault;
using HIPS.ServiceContracts.Hpii.Message;

namespace HIPS.ServiceContracts.Hpii
{
    /// <summary>
    /// Web service interface for the HPI-I service version 2.
    /// </summary>
    [WCFExtras.Wsdl.Documentation.XmlComments]
    [ServiceContract(Namespace = HIPS.ServiceContracts.Common.Constants.ServiceNamespace.HPII_V2)]
    public interface IHpiiServiceV2
    {
        /// <summary>
        /// This operation retrieves the results of a batch of HPI-I searches from the HI Service.
        /// </summary>
        /// <param name="request">HpiiBatchRetrieveRequest request parameters.</param>
        /// <returns>Response including the results of the batch.</returns>
        [OperationContract]
        [FaultContract(typeof(InvalidRequestFault))]
        [FaultContract(typeof(ServiceOperationFault))]
        [FaultContract(typeof(InvalidUserFault))]
        [FaultContract(typeof(HiServiceFault))]
        [FaultContract(typeof(ItemNotFoundFault))]
        HpiiBatchRetrieveResponse HpiiBatchRetrieve(HpiiBatchRetrieveRequest request);

        /// <summary>
        /// This operation submits a batch of HPI-I searches to the HI Service.
        /// </summary>
        /// <param name="request">HpiiBatchSubmitRequest request parameters.</param>
        /// <returns>Response including the batch identifier.</returns>
        [OperationContract]
        [FaultContract(typeof(InvalidRequestFault))]
        [FaultContract(typeof(ServiceOperationFault))]
        [FaultContract(typeof(InvalidUserFault))]
        [FaultContract(typeof(HiServiceFault))]
        [FaultContract(typeof(ItemNotFoundFault))]
        HpiiBatchSubmitResponse HpiiBatchSubmit(HpiiBatchSubmitRequest request);

        /// <summary>
        /// This operation submits an HPI-I demographic search to the HI Service.
        /// </summary>
        /// <param name="request">HpiiDemographicSearchRequest request parameters.</param>
        /// <returns>Response including the search results.</returns>
        [OperationContract]
        [FaultContract(typeof(InvalidRequestFault))]
        [FaultContract(typeof(ServiceOperationFault))]
        [FaultContract(typeof(InvalidUserFault))]
        [FaultContract(typeof(HiServiceFault))]
        [FaultContract(typeof(ItemNotFoundFault))]
        HpiiDemographicSearchResponse HpiiDemographicSearch(HpiiDemographicSearchRequest request);

        /// <summary>
        /// This operation submits an HPI-I identifier search to the HI Service.
        /// </summary>
        /// <param name="request">HpiiIdentifierSearchRequest request parameters.</param>
        /// <returns>Response including the search results.</returns>
        [OperationContract]
        [FaultContract(typeof(InvalidRequestFault))]
        [FaultContract(typeof(ServiceOperationFault))]
        [FaultContract(typeof(InvalidUserFault))]
        [FaultContract(typeof(HiServiceFault))]
        [FaultContract(typeof(ItemNotFoundFault))]
        HpiiIdentifierSearchResponse HpiiIdentifierSearch(HpiiIdentifierSearchRequest request);
    }
}