﻿using System.Configuration;
using System.Data.SqlClient;
using HIPS.Common.PcehrDataStore.DataAccess;
using HIPS.CommonSchemas;

namespace Test.Helpers
{
    public class ProviderTestHelpersBase : BaseDl
    {
        #region Private Members

        private SqlCommand testCommand;

        #endregion Private Members

        #region Properties

        /// <summary>
        /// Gets the test SQL command object that uses a different connection string the base command object.
        /// </summary>
        public SqlCommand TestCommand
        {
            get
            {
                if (testCommand == null)
                {
                    testCommand = new SqlCommand();
                    SqlConnection connection = new SqlConnection(ConfigurationManager.ConnectionStrings["TestPcehrDataStoreConnectionString"].ToString());
                    testCommand.Connection = connection;
                }
                if (testCommand.Connection.State != System.Data.ConnectionState.Open)
                {
                    testCommand.Connection.Open();
                }
                testCommand.Parameters.Clear();
                return testCommand;
            }
        }

        #endregion Properties

        #region PatientMasterDL generic Test data

        public UserDetails GetTestUser()
        {
            UserDetails user = new UserDetails();
            user.Role = UserRole.InteractiveUser;
            user.Login = "TestLogin";
            user.Domain = "TestDomain";
            user.Name = "TestName";
            return user;
        }

        public UserDetails GetTestAuthorisedEmployee()
        {
            UserDetails user = new UserDetails();
            user.Role = UserRole.AuthorisedEmployee;
            //user.Login = "TestLogin";
            //user.Domain = "TestDomain";
            //user.Name = "TestName";
            return user;
        }

        #endregion PatientMasterDL generic Test data
    }
}