﻿using System;
using Microsoft.VisualStudio.TestTools.UnitTesting;
using Test.CommonCcaNoc.Helpers;
using HIPS.CommonSchemas;
using Test.Helpers;
using HIPS.HpiiSchemas;
using nehta.mcaR50.ProviderSearchForProviderIndividual;

namespace Test.MedicareCCA.CCA.UC_131
{
    [TestClass]
    public class HI_CCA_131_008028 : CcaTest
    {
        /// <summary>
        /// Use of Healthcare Identifiers in Health Information Systems
        /// Conformance Test Specification
        /// Version 3.0 — February 2014	
        /// 
        /// Perform each operation below and verify that:
        /// a. Verify that the software has the ability to record an audit
        ///     trail of HIs disclosed by HI Service regardless of type and the
        ///     audit trails are retrievable.
        /// b. Verify that audit trail records the healthcare identifier.
        /// c. Verify that audit trail records associated local provider record
        ///     identifier(s) *See Note*
        /// d. Verify that audit trail records identifying information of the
        ///     operator or responsible officer that initiated access to the HI
        ///     Service.
        /// e. Verify that audit trail records HPI-I of the operator if 
        ///     applicable. *See Note*
        /// f. Verify that audit trail records the healthcare identifier 
        ///     (HPI-O) of the healthcare provider organisation that initiated
        ///     the request to the HI Service.
        /// g. Verify that audit trail records the CSP identifier of the
        ///     contracted service provider (if applicable)
        /// h. Verify that audit trail records the HI Service operation (web 
        ///     service name) against the healthcare identifier.
        /// i. Verify that audit trail records system date and time (time in 
        ///     hours and minutes unless the system is capable of more precision).
        /// j. Verify that audit trail records the HI Service messageID as 
        ///     documented by the [TECH.SIS.HI.01].
        /// k. Verify that audit trail records the version of the HI Service
        ///     web service.
        /// 
        /// Operations:
        /// Perform an operation to retrieve/validate the details of a Healthcare Provider in the HI Service
        /// 
        /// * Note *
        /// The availability of the identifier type is dependent on the nature of each interaction with the HI Service. 
        /// </summary>
        [TestMethod]
        [TestCategory("HI_CCA_131")]
        public void HI_CCA_131_008028_1()
        {
            UserDetails user = new UserDetails
            {
                HpiI = "8003615833334118",
                Name = "Anna Jones",
                Role = UserRole.ProviderIndividual
            };
            provider = CcaProviders.GetProvider("NOC ID 1");

            HpiiIdentifierQuery query = new HpiiIdentifierQuery();
            query.HpioNumber = provider.TestProviderHpioNumber;
            query.HpiiNumber = provider.TestProviderHpiiNumber;
            query.FamilyName = provider.TestProviderFamilyName;
            query.Sex = (SexType?)provider.TestProviderSex;

            HpiiQueryResponse hpiiResponse = ProxyHelper.HpiiProxy.HpiiValidation(query, user);
            LogAssert.ExpectResponse(HipsResponseIndicator.OK, hpiiResponse.HipsResponse, DialogueResource.HipsServiceHpiiValidation);

            var audit = provider.GetLastHpiiLookupAudit();
            LogAssert.IsNotBlank(audit.HpiiNumber, "HpiiNumber");
            LogAssert.IsNotBlank(audit.OperatorHpiI, "OperatorHpiI");
            LogAssert.IsNotBlank(audit.Operator, "Operator");
            LogAssert.IsNotBlank(audit.HpiO, "HpiO");
            LogAssert.IsNotBlank(audit.HiWebServiceName, "HiWebServiceName");
            LogAssert.IsNotBlank(audit.HiWebServiceVersion, "HiWebServiceVersion");
            LogAssert.IsNotBlank(audit.DateCreated.ToString(), "DateCreated");
            LogAssert.IsNotBlank(audit.ServiceMessageRequestID, "ServiceMessageRequestID");
            LogAssert.IsNotBlank(audit.ServiceMessageResponseID, "ServiceMessageResponseID");
        }
    }
}
