﻿using System.Linq;
using System.Windows.Forms;
using HIPS.CommonSchemas;
using HIPS.CommonSchemas.PatientIdentifier;
using HIPS.PcehrSchemas;
using Microsoft.VisualStudio.TestTools.UnitTesting;
using Test.CommonCcaNoc.Helpers;

namespace Test.PcehrCcaNoc.ClinicalInformationSystem.UC_CIS_204
{
    /// <summary>
    /// Conformance Test Specification: Clinical Information Systems
    ///                                 Connecting to the PCEHR System
    ///                                 Version 1.6 — 27 September 2012
    /// Use Case #:	    UC.CIS.204
    /// Use Case Name:	Download a Clinical Document
    /// Test Case ID:   PCEHR_CIS_018634
    /// Objective:
    /// To check that the clinical information system validates the hash tags
    /// of a clinical document downloaded from the PCEHR System and indicates
    /// if the downloaded clinical document has been modified.
    /// </summary>
    [TestClass]
    public class PCEHR_CIS_018634 : CcaTest
    {
        /// <summary>
        /// Perform an operation to retrieve a CDA package where the clinical
        /// document within the package has been changed to ensure that its
        /// hash value will not match the hash value in the package signature:
        /// a. Verify that the software indicates to the user that the CDA
        ///    package hash value comparison has found the CDA package value is
        ///    invalid.
        /// </summary>
        [TestMethod]
        [TestCategory("CIS_CCA_204")]
        public void CIS_204_018634_A()
        {
            // We need to download the document from the appropriate IHI
            patient = CcaPatient.GetPatient(ihiValid: true, validatedWithinPeriod: true, hasUnresolvedAlerts: false, testDataId: "CCA ID IHI_85");

            // Ask the user to enable the workaround in DownloadDocument to replace the downloaded document with the invalid one.
            MessageBox.Show(DialogueResource.CIS_204_018634_A_Q1, DialogueResource.CIS_204_018634_A_Title, MessageBoxButtons.OK);

            GainPcehrAccessResponse accessResponse = ProxyHelper.PcehrProxy.GainAccessEmergency(patient.TargetPatientIdentifier, patient.GetTestUser());
            LogAssert.ExpectResponse(HipsResponseIndicator.OK, accessResponse.HipsResponse, DialogueResource.HipsServiceGainAccessEmergency);

            DocumentListResponse<PatientIdentifierBase> listResponse = ProxyHelper.PcehrProxy.GetDocumentListActive(patient.TargetPatientIdentifier, patient.GetTestUser());
            LogAssert.ExpectResponse(HipsResponseIndicator.OK, listResponse.HipsResponse, DialogueResource.HipsServiceGetDocumentListActive);

            // It doesn't matter which of the documents we download, because it will be replaced
            // string oid = CdaDocument.ConvertToOid("8b426872-f605-4fb0-95ce-918586066901");
            // DocumentMetaDataItem item = listResponse.DocumentList.FirstOrDefault(a => a.DocumentUniqueId == oid);
            // Assert.IsNotNull(item, "The invalid document was not found in the PCEHR");
            DocumentMetaDataItem item = listResponse.DocumentList.First();

            DocumentRequest request = new DocumentRequest();
            request.DocumentUniqueId = item.DocumentUniqueId;
            request.RepositoryUniqueId = item.RepositoryUniqueId;
            DocumentResponse response = ProxyHelper.PcehrProxy.RetrieveDocument(patient.TargetPatientIdentifier, patient.GetTestUser(), request);
            LogAssert.ExpectResponse(HipsResponseIndicator.InvalidDocument, response.HipsResponse, DialogueResource.HipsServiceRetrieveDocument);
            LogAssert.AreEqual("Error verifying document - Manifest digest value mismatch", response.HipsResponse.HipsErrorMessage, DialogueResource.HipsErrorMessage);

            MessageBox.Show(DialogueResource.CIS_204_018634_A_Q2, DialogueResource.CIS_204_018634_A_Title, MessageBoxButtons.OK);
        }
    }
}