﻿using System;
using System.Text;
using System.Collections.Generic;
using System.Linq;
using Microsoft.VisualStudio.TestTools.UnitTesting;
using Test.CommonCcaNoc.Helpers;
using HIPS.PcehrSchemas;
using HIPS.CommonSchemas;
using HIPS.CommonSchemas.PatientIdentifier;
using HIPS.PcehrDataStore.DataAccess;
using HIPS.PcehrDataStore.Schemas;
using HIPS.PcehrDataStore.Schemas.Enumerators;
using System.Xml;
using System.IO;
using HIPS.Client.Proxy;
using System.ServiceModel.Description;
using System.ServiceModel.Dispatcher;
using System.Text.RegularExpressions;
using System.ServiceModel.Channels;

namespace Test.PcehrCcaNoc.ClinicalInformationSystem.UC_CIS_501
{
    /// <summary>
    /// Conformance Test Specification: Clinical Information Systems Connecting to the PCEHR System
    ///                                 Version 1.6 — 7 March 2013
    /// Use Case #:	    UC.CIS.501
    /// Use Case Name:	Assisted Registration of an adult
    /// Test Case ID:   PCEHR_CIS_020835
    /// Objective:
    /// To assist a consumer with registering for an eHealth record. 
    /// </summary>
    [TestClass]
    public class PCEHR_CIS_020835 : CcaTest
    {
        /// <summary>
        /// "If the clinical information system does not use the indigenous status from the local health record to prepopulate the indigenous status 
        /// while entering the registration details, then:
        //  Prepare registration details and complete all necessary fields, without recording the indigenous status for the consumer:
        //             a. Verify the CIS does not default to a specific indigenous status value, but requires the user to set a status manually for the consumer. "
        /// </summary>
        [TestMethod]
        [TestCategory("Assisted Registration CIS_CCA_501")]
        public void CIS_501_020835()
        {
            patient = CcaPatient.GetPatient(ihiValid: true, validatedWithinPeriod: true, hasUnresolvedAlerts: false, testDataId: "AR ID 06");

            // Create document consent list
            List<RegistrationDocumentConsent> documentConsentList = new List<RegistrationDocumentConsent>() { 
                new RegistrationDocumentConsent(RegistrationDocumentConsentType.ACIR, RegistrationDocumentConsentStatus.ConsentNotGiven),
                new RegistrationDocumentConsent(RegistrationDocumentConsentType.AODR, RegistrationDocumentConsentStatus.ConsentNotGiven),
                new RegistrationDocumentConsent(RegistrationDocumentConsentType.MBS, RegistrationDocumentConsentStatus.ConsentGiven),
                new RegistrationDocumentConsent(RegistrationDocumentConsentType.MBSPastAssimilation, RegistrationDocumentConsentStatus.ConsentNotGiven),
                new RegistrationDocumentConsent(RegistrationDocumentConsentType.PBS, RegistrationDocumentConsentStatus.ConsentNotGiven),
                new RegistrationDocumentConsent(RegistrationDocumentConsentType.PBSPastAssimilation, RegistrationDocumentConsentStatus.ConsentNotGiven),
            };

            //change the behaviours of the request to remove the Indigenous Status - this will be passed by WCF and set the enum to 0
            AssistedRegistrationProxy proxy = new AssistedRegistrationProxy(string.Format("{0}_AssistedRegistrationService", ProxyHelper.EnvironmentUnderTest));
            InspectorBehavior newBehavior = new InspectorBehavior(XmlAction.Remove, xmlMatch: "<indigenousStatus>NeitherAboriginalAndTorresStraitIslander</indigenousStatus>");
            proxy.Endpoint.Behaviors.Add(newBehavior);

            // Create correspondence channel
            RegistrationCorrespondenceChannel channel = new RegistrationCorrespondenceChannel();
            channel.Channel = IvcCorrespondenceChannel.response;

            PcehrRegistrationResponse registrationResponse = proxy.RegisterPatient(patient.TargetPatientIdentifier,
                EvidenceOfIdentityType.IdentityVerificationMethod1,
                IndigenousStatus.NeitherAboriginalAndTorresStraitIslander,
                documentConsentList,
                channel,
                true,
                patient.GetTestUser());

            LogAssert.AreEqual(HipsResponseIndicator.ValidationError, registrationResponse.HipsResponse.Status, DialogueResource.HipsServiceUnverifiedIhiRegisterPatient);
            LogAssert.AreEqual("The Indigenous Status must be provided", registrationResponse.HipsResponse.HipsErrorMessage, "Incorrect validation");
        }
            
        }

        ///// <summary>
        ///// Implementation of a behaviour that instantiates a MessageInspector.
        ///// </summary>
        //internal class InspectorBehavior : IEndpointBehavior
        //{
        //    private XmlAction action;
        //    private string xmlMatch;
        //    private string xmlText;

        //    public InspectorBehavior(XmlAction action, string xmlMatch = null, string xmlText = null)
        //    {
        //        this.action = action;
        //        this.xmlMatch = xmlMatch;
        //        this.xmlText = xmlText;
        //    }

        //    public void AddBindingParameters(ServiceEndpoint endpoint, System.ServiceModel.Channels.BindingParameterCollection bindingParameters)
        //    {
        //    }

        //    public void ApplyClientBehavior(ServiceEndpoint endpoint, System.ServiceModel.Dispatcher.ClientRuntime clientRuntime)
        //    {
        //        clientRuntime.MessageInspectors.Add(new MessageInspector(action, xmlMatch, xmlText));
        //    }

        //    public void ApplyDispatchBehavior(ServiceEndpoint endpoint, System.ServiceModel.Dispatcher.EndpointDispatcher endpointDispatcher)
        //    {
        //    }

        //    public void Validate(ServiceEndpoint endpoint)
        //    {
        //    }
        //}

        //public enum XmlAction
        //{
        //    Remove = 1,
        //    Replace = 2,
        //    Add = 3
        //}

        //internal class MessageInspector : IClientMessageInspector
        //{
        //    private XmlAction action;
        //    private string xmlMatch;
        //    private string xmlText;

        //    public MessageInspector(XmlAction action, string xmlMatch = null, string xmlText = null)
        //    {
        //        this.action = action;
        //        this.xmlMatch = xmlMatch;
        //        this.xmlText = xmlText;
        //    }

        //    public object BeforeSendRequest(ref System.ServiceModel.Channels.Message request, System.ServiceModel.IClientChannel channel)
        //    {
        //        string bigXml = ConvertMessageToString(request);

        //        switch (action)
        //        {
        //            case XmlAction.Add:
        //                //not yet implemented - use XPATH here
        //                break;
        //            case XmlAction.Remove:
        //                //remove the xml item 
        //                bigXml = Regex.Replace(bigXml, xmlMatch, "");
        //                break;
        //            case XmlAction.Replace:
        //                //remove the xml item and replace
        //                bigXml = Regex.Replace(bigXml, xmlMatch, xmlText);
        //                break;
        //            default:
        //                break;
        //        }


        //        byte[] xmlArray = Encoding.UTF8.GetBytes(bigXml);
        //        XmlDictionaryReaderQuotas xdq = new XmlDictionaryReaderQuotas();

        //        var reader = XmlDictionaryReader.CreateTextReader(xmlArray, xdq);
        //        request = Message.CreateMessage(reader, int.MaxValue, request.Version);

        //        //msgBuffer.Close();

        //        return null;
        //    }
        //    public void AfterReceiveReply(ref System.ServiceModel.Channels.Message reply, object correlationState)
        //    {

        //    }

        //     /// <summary>
        ///// Convert the message to a string.
        ///// </summary>
        ///// <param name="msg">Message to convert.</param>
        ///// <returns>Message as a string.</returns>
        //private static string ConvertMessageToString(System.ServiceModel.Channels.Message msg)
        //{
        //    var ms = new MemoryStream();
        //    var xw = XmlTextWriter.Create(ms, new XmlWriterSettings()
        //    {
        //        Indent = false,
        //        OmitXmlDeclaration = true
        //    });
        //    msg.WriteMessage(xw);
        //    xw.Close();
        //    ms.Position = 0;

        //    var sr = new StreamReader(ms);
        //    var convertedString = sr.ReadToEnd();

        //    sr.Close();
        //    ms.Close();

        //    return convertedString;
        //}
    //}
}
