﻿using System;
using System.Windows.Forms;

using HIPS.CommonSchemas.PatientIdentifier;
using HIPS.IhiSchemas.Schemas;
using HIPS.PcehrSchemas;
using HIPS.PcehrDataStore.Schemas.Enumerators;

namespace HIPS.DemoHarness
{
    public partial class DemoHarnessForm
    {
        private void GetValidatedIhiButton_Click(object sender, EventArgs e)
        {
            this.Cursor = Cursors.WaitCursor;
            CheckForPcehrServiceMessagesTextBox.Visible = false;
            CheckForPcehrServiceMessagesTextBox.Text = "";
            var client = GetHIServiceClient();
            try
            {
                string hospitalCode = GetSelectedPatientHospitalCode();
                string hospitalCodeSystem = GetHospitalCodeSystem();
                string mrn = GetSelectedPatientMrn();
                DateTime dateOfBirth = GetSelectedPatientDateOfBirth();
                ValidatedIhiResponse response = client.GetValidatedIhi(new Mrn(mrn, hospitalCode, hospitalCodeSystem), dateOfBirth, GetUser());
                IhiLookupReturnStatusTextBox.Text = response.HipsResponse.ToString();
                ShowResponse(CheckForPcehrServiceMessagesTextBox, response.HipsResponse);
                if (response.ValidatedIhi != null)
                {
                    GivenNamesTextBox.Text = response.ValidatedIhi.GivenName;
                    FamilyNameTextBox.Text = response.ValidatedIhi.FamilyName;
                    SexTextBox.Text = response.ValidatedIhi.Sex.ToString();
                    IhiTextBox.Text = response.ValidatedIhi.Ihi;
                    IhiStatusTextBox.Text = response.ValidatedIhi.IhiStatus.ToString();
                    IhiRecordStatusTextBox.Text = response.ValidatedIhi.IhiRecordStatus.ToString();
                    LastValidatedDateTimeTextBox.Text = string.Format("{0:dd/MM/yyyy HH:mm}", response.ValidatedIhi.IhiLastValidated);
                }
                else
                {
                    GivenNamesTextBox.Text = string.Empty;
                    FamilyNameTextBox.Text = string.Empty;
                    SexTextBox.Text = string.Empty;
                    IhiTextBox.Text = string.Empty;
                    IhiStatusTextBox.Text = string.Empty;
                    IhiRecordStatusTextBox.Text = string.Empty;
                    LastValidatedDateTimeTextBox.Text = string.Empty;
                }
            }
            catch (Exception ex)
            {
                ShowException(ex, CheckForPcehrServiceMessagesTextBox);
            }
            finally
            {
                try
                {
                    client.Close();
                }
                catch (Exception)
                {
                    // Ignore exception while closing client
                }
            }
            this.Cursor = Cursors.Default;
        }

        private void CheckPcehrStatusButton_Click(object sender, EventArgs e)
        {
            this.Cursor = Cursors.WaitCursor;
            CheckForPcehrServiceMessagesTextBox.Visible = false;
            CheckForPcehrServiceMessagesTextBox.Text = string.Empty;
            var client = GetPcehrServiceClient();
            try
            {
                string hospitalCode = GetSelectedPatientHospitalCode();
                string codingSystem = GetHospitalCodeSystem();
                string mrn = GetSelectedPatientMrn();
                DateTime dateOfBirth = GetSelectedPatientDateOfBirth();

                DoesPcehrExistResponse response = client.IsPcehrAdvertised(new Mrn(mrn, hospitalCode, GetHospitalCodeSystem()), dateOfBirth, GetUser());
                PcehrExistsReturnStatusTextBox.Text = response.HipsResponse.Status.ToString();
                ShowResponse(CheckForPcehrServiceMessagesTextBox, response.HipsResponse);
                if (response.PcehrExists.HasValue)
                {
                    AdvertisedStatusTextBox.Text = response.PcehrExists.Value ? "Yes, an advertised PCEHR exists." : "No PCEHR exists, or the owner has chosen not to advertise its existence.";
                }
                else
                {
                    AdvertisedStatusTextBox.Text = "Unknown";
                }
                switch (response.AccessCodeRequired)
                {
                    case AccessCodeRequired.Unknown:
                        AccessStatusTextBox.Text = "Unknown";
                        break;
                    case AccessCodeRequired.AccessGranted:
                        AccessStatusTextBox.Text = "Your organisation has already gained access to this PCEHR.";
                        break;
                    case AccessCodeRequired.WithCode:
                        AccessStatusTextBox.Text = "Access to this PCEHR is restricted. You can gain access with the code or assert emergency access.";
                        break;
                    case AccessCodeRequired.WithoutCode:
                        AccessStatusTextBox.Text = "Access to this PCEHR is not restricted. You can gain access without a code.";
                        break;
                }
            }
            catch (Exception ex)
            {
                ShowException(ex, CheckForPcehrServiceMessagesTextBox);
            }
            finally
            {
                try
                {
                    client.Close();
                }
                catch (Exception)
                {
                    // Ignore exception while closing client
                }
            }
            this.Cursor = Cursors.Default;
        }

        private void tab3PatientComboBox_SelectedIndexChanged(object sender, EventArgs e)
        {
            string hospitalCode = GetSelectedPatientHospitalCode();
            string codingSystem = GetHospitalCodeSystem();
            string mrn = GetSelectedPatientMrn();
            ClearResults();
            tab3HospitalCodeReadOnlyTextBox.Text = GetSelectedPatientHospitalCode();
            tab3MrnReadOnlyTextBox.Text = GetSelectedPatientMrn();
            tab3DateOfBirthReadOnlyTextBox4.Text = string.Format("{0:dd/MM/yyyy}", SelectedPatient.DateOfBirth);
            tab3HospitalCodeSystemReadOnlyTextBox.Text = GetHospitalCodeSystem();
            //this.Refresh();
        }
    }
}
