﻿using System;
using System.Configuration;
using System.IO;
using System.Linq;
using System.ServiceModel;
using System.Text;
using System.Windows.Forms;

namespace HIPS.DemoHarness
{
    public partial class DemoHarnessForm
    {
        private void PcehrViewWebBrowser_DocumentCompleted(object sender, WebBrowserDocumentCompletedEventArgs e)
        {
            PcehrViewLoadingpictureBox.Visible = false;
            PcehrViewWebBrowser.Visible = true;
        }

        private void PcehrViewPatientComboBox_SelectedIndexChanged(object sender, EventArgs e)
        {
            PcehrViewWebBrowser.Visible = false;
            if (PcehrViewTabLoaded && SelectedPatient != null)
            {
                string hospitalCode = GetSelectedPatientHospitalCode();
                string mrn = GetSelectedPatientMrn();
                string baseUrl = ConfigurationManager.AppSettings["HIPS_UI_URL"];
                if (!baseUrl.EndsWith("/"))
                {
                    baseUrl = baseUrl + "/";
                }
                string url = string.Format("{0}EmbeddedPcehrView/Hospitals/{1}/Patients/{2}/PatientSummary", baseUrl, hospitalCode, mrn);
                PcehrViewWebBrowser.Url = new Uri(url);
                PcehrViewLoadingpictureBox.Visible = true;
            }
        }
    }
}
