﻿using AutoMapper;
using ServiceSchemas = HIPS.ServiceContracts.Common.DTO;

namespace HIPS.AppServer.ServiceHost.Mapping.Profiles
{
    /// <summary>
    /// AutoMapper mapping profile for the User entity.
    /// </summary>
    internal class PatientIdentifierProfile : Profile
    {
        #region Methods

        /// <summary>
        /// Configures the maps available as part of this mapping profile.
        /// </summary>
        protected override void Configure()
        {
            // DTO --> Common:
            this.CreateMap<ServiceSchemas.PatientIdentifier.Mrn, CommonSchemas.PatientIdentifier.PatientIdentifierBase>()
                .As<CommonSchemas.PatientIdentifier.Mrn>();
            this.CreateMap<ServiceSchemas.PatientIdentifier.PatientMasterId, CommonSchemas.PatientIdentifier.PatientIdentifierBase>()
                .As<CommonSchemas.PatientIdentifier.PatientMasterId>();
            this.CreateMap<ServiceSchemas.PatientIdentifier.StatePatientId, CommonSchemas.PatientIdentifier.PatientIdentifierBase>()
                .As<CommonSchemas.PatientIdentifier.StatePatientId>();
            this.CreateMap<ServiceSchemas.PatientIdentifier.ValidatedIhi, CommonSchemas.PatientIdentifier.PatientIdentifierBase>()
                .As<CommonSchemas.PatientIdentifier.ValidatedIhi>();
            this.CreateMap<ServiceSchemas.PatientIdentifier.RegisteredEnterprisePatient, CommonSchemas.PatientIdentifier.PatientIdentifierBase>()
                .As<CommonSchemas.PatientIdentifier.RegisteredEnterprisePatient>();

            this.CreateMap<ServiceSchemas.PatientIdentifier.Mrn, CommonSchemas.PatientIdentifier.Mrn>();
            this.CreateMap<ServiceSchemas.PatientIdentifier.PatientMasterId, CommonSchemas.PatientIdentifier.PatientMasterId>();
            this.CreateMap<ServiceSchemas.PatientIdentifier.StatePatientId, CommonSchemas.PatientIdentifier.StatePatientId>();

            this.CreateMap<ServiceSchemas.PatientIdentifier.ValidatedIhi, CommonSchemas.PatientIdentifier.ValidatedIhi>()
                .ForMember(dest => dest.GivenName, opt => opt.ResolveUsing(src => src.GivenNames))
                 ;

            this.CreateMap<ServiceSchemas.PatientIdentifier.RegisteredEnterprisePatient, CommonSchemas.PatientIdentifier.RegisteredEnterprisePatient>();
            this.CreateMap<ServiceSchemas.HospitalIdentifier, CommonSchemas.HospitalIdentifier>(); // For Hospital Identifier
            this.CreateMap<HIPS.ServiceContracts.Common.ForceRefreshOption, CommonSchemas.ForceRefreshOption>(); // For forceRefreshOption
            // Common --> DTO:

            this.CreateMap<CommonSchemas.PatientIdentifier.Mrn, ServiceSchemas.PatientIdentifier.PatientIdentifierBase>()
                .As<ServiceSchemas.PatientIdentifier.Mrn>();
            this.CreateMap<CommonSchemas.PatientIdentifier.PatientMasterId, ServiceSchemas.PatientIdentifier.PatientIdentifierBase>()
                .As<ServiceSchemas.PatientIdentifier.PatientMasterId>();
            this.CreateMap<CommonSchemas.PatientIdentifier.StatePatientId, ServiceSchemas.PatientIdentifier.PatientIdentifierBase>()
                .As<ServiceSchemas.PatientIdentifier.StatePatientId>();
            this.CreateMap<CommonSchemas.PatientIdentifier.ValidatedIhi, ServiceSchemas.PatientIdentifier.PatientIdentifierBase>()
                .As<ServiceSchemas.PatientIdentifier.ValidatedIhi>();
            this.CreateMap<CommonSchemas.PatientIdentifier.RegisteredEnterprisePatient, ServiceSchemas.PatientIdentifier.PatientIdentifierBase>()
                .As<ServiceSchemas.PatientIdentifier.RegisteredEnterprisePatient>();

            this.CreateMap<CommonSchemas.PatientIdentifier.Mrn, ServiceSchemas.PatientIdentifier.Mrn>();
            this.CreateMap<CommonSchemas.PatientIdentifier.PatientMasterId, ServiceSchemas.PatientIdentifier.PatientMasterId>();
            this.CreateMap<CommonSchemas.PatientIdentifier.StatePatientId, ServiceSchemas.PatientIdentifier.StatePatientId>();
            this.CreateMap<CommonSchemas.PatientIdentifier.ValidatedIhi, ServiceSchemas.PatientIdentifier.ValidatedIhi>()
                 .ForMember(dest => dest.GivenNames, opt => opt.ResolveUsing(src => src.GivenName))
                 ;

            this.CreateMap<CommonSchemas.PatientIdentifier.RegisteredEnterprisePatient, ServiceSchemas.PatientIdentifier.RegisteredEnterprisePatient>();
            this.CreateMap<CommonSchemas.HospitalIdentifier, ServiceSchemas.HospitalIdentifier>(); // For Hospital Identifier
            this.CreateMap<CommonSchemas.ForceRefreshOption, HIPS.ServiceContracts.Common.ForceRefreshOption>(); // For forceRefreshOption
        }

        #endregion Methods
    }
}