﻿using System.ServiceModel;

using HIPS.AppServer.ServiceHost.Mapping;
using HIPS.ServiceContracts.Common.Fault;

using EntLibVal = Microsoft.Practices.EnterpriseLibrary.Validation;

namespace HIPS.AppServer.ServiceHost
{
    /// <summary>
    /// The base service to inherit from.
    /// </summary>
    public class BaseService
    {
        /// <summary>
        /// Validates the provided target object. Throws FaultException(Of InvalidRequestFault) if invalid.
        /// </summary>
        /// <param name="target">The target object to be validated.</param>
        /// <param name="ruleset">The name of the ruleset to be applied. Defaults to empty (default).</param>
        protected void ValidateRequest(object target, string ruleset = "")
        {
            var validator = new EntLibVal.Validators.ObjectValidator(EntLibVal.ValidationFactory.DefaultCompositeValidatorFactory, ruleset);
            var results = validator.Validate(target);

            if (!results.IsValid)
            {
                throw ObjectMapper.Map<FaultException<InvalidRequestFault>>(results);
            }
        }
    }
}