﻿using System;
using System.Runtime.Serialization;
using HIPS.Base.Schemas.Enumerators;

namespace HIPS.Base.Schemas
{
    /// <summary>
    /// Base schema for reference data entities containing a Code and Description attribute that are exposed via web services.
    /// </summary>
    [Serializable]
    [DataContract]
    [KnownType(typeof(BaseExposedCode))]
    public class BaseExposedCode
    {
        /// <summary>
        /// Initialises a new instance of the <see cref="BaseExposedCode"/> class.
        /// </summary>
        public BaseExposedCode()
        {
        }

        #region Private Members

        private string code;
        private string description;
        private int? id;

        #endregion Private Members

        /// <summary>
        /// Gets or sets the Code
        /// </summary>
        /// <value>
        /// The code
        /// </value>
        [DataBaseInfoAttributes(DatabaseColumnType.ReadOnlyData)]
        [DataMember]
        public string Code
        {
            get { return code; }
            set { code = value; }
        }

        /// <summary>
        /// Gets or sets the Description
        /// </summary>
        /// <value>
        /// The description
        /// </value>
        [DataBaseInfoAttributes(DatabaseColumnType.ReadOnlyData)]
        [DataMember]
        public string Description
        {
            get { return description; }
            set { description = value; }
        }

        /// <summary>
        /// Gets or sets the Id
        /// </summary>
        /// <value>
        /// The Id
        /// </value>
        [DataBaseInfoAttributes(DatabaseColumnType.ReadOnlyData)]
        [DataMember]
        public int? Id
        {
            get { return id; }
            set { id = value; }
        }
    }
}