using System;
using HIPS.Base.Schemas.Enumerators;

namespace HIPS.Base.Schemas
{
    /// <summary>
    /// Attribute definition: defines the type of column a given schema property maps to.
    /// </summary>
    [AttributeUsage
    (AttributeTargets.Property, Inherited = true, AllowMultiple = false)]
    public sealed class DataBaseInfoAttributes : Attribute
    {
        #region Private Members

        private DatabaseColumnType columnType;

        #endregion Private Members

        #region Constructors

        /// <summary>
        /// Initializes a new instance of the <see cref="DataBaseInfoAttributes"/> class.
        /// </summary>
        /// <param name="ColumnType">Type of the column.</param>
        public DataBaseInfoAttributes(DatabaseColumnType ColumnType)
        {
            columnType = ColumnType;
        }

        #endregion Constructors

        #region Properies

        /// <summary>
        /// Gets the type of the column.
        /// </summary>
        /// <value>
        /// The type of the column.
        /// </value>
        public DatabaseColumnType ColumnType
        {
            get
            {
                return columnType;
            }
        }

        #endregion Properies
    }
}