﻿using System.ServiceModel;

using HIPS.CommonSchemas;
using HIPS.ServiceContracts.ServiceInterfaces;

namespace HIPS.Client.Proxy
{
    /// <summary>
    /// This pre-built client class can be referenced by a .net client application in lieu of generating client classes from the WSDL.
    /// </summary>
    public class DatabaseLoaderProxy : ClientBase<IDatabaseLoaderService>, IDatabaseLoaderService
    {
        /// <summary>
        /// Initialises a new instance of the <see cref="DatabaseLoaderProxy" /> class.
        /// </summary>
        /// <param name="endpointName">Configured endpoint name.</param>
        public DatabaseLoaderProxy(string endpointName)
            : base(endpointName)
        {
        }

        /// <summary>
        /// Sends patient administration HL7 message to HIPS.
        /// </summary>
        /// <param name="messageForm">HL7 message content.</param>
        /// <param name="user">Responsible user identity.</param>
        /// <returns>HL7 acknowledgement.</returns>
        public string NotifyPasEvent(string messageForm, UserDetails user)
        {
            return Channel.NotifyPasEvent(messageForm, user);
        }

        /// <summary>
        /// Sends pathology HL7 message to HIPS.
        /// </summary>
        /// <param name="messageForm">HL7 message content.</param>
        /// <param name="user">Responsible user identity.</param>
        /// <returns>HL7 acknowledgement.</returns>
        public string NotifyPathEvent(string messageForm, UserDetails user)
        {
            return Channel.NotifyPathEvent(messageForm, user);
        }
    }
}