﻿using System;

using AutoMapper;
using ModelSchemas = HIPS.CommonSchemas;
using NehtaSchemas = Nehta.VendorLibrary.CDA;

namespace HIPS.CommonBusinessLogic.Mapping.Profiles
{
    /// <summary>
    /// AutoMapper mapping profile for types that are common in CDA documents.
    /// </summary>
    internal class CdaProfile : Profile
    {
        #region Methods

        /// <summary>
        /// Returns the name of the mapping profile.
        /// </summary>
        public override string ProfileName
        {
            get { return this.GetType().Name; }
        }

        /// <summary>
        /// Configures the maps available as part of this mapping profile.
        /// </summary>
        protected override void Configure()
        {
            // Model --> NEHTA

            this.CreateMap<ModelSchemas.Cda.EntityIdentifier, NehtaSchemas.SCSModel.Common.Identifier>()
                .ForMember(dest => dest.AssigningAuthorityName, opt => opt.MapFrom(src => src.AssigningAuthorityName))
                .ForMember(dest => dest.AssigningGeographicArea, opt => opt.MapFrom(src => src.AssigningGeographicArea))
                .ForMember(dest => dest.Code, opt => opt.MapFrom(src => src.Code))
                .ForMember(dest => dest.Extension, opt => opt.MapFrom(src => src.Extension))
                .ForMember(dest => dest.Root, opt => opt.MapFrom(src => src.Root));

            this.CreateMap<ModelSchemas.Cda.CdaCode, NehtaSchemas.SCSModel.ICodableText>()
                .ConstructUsing((ResolutionContext ctx) => NehtaSchemas.Common.BaseCDAModel.CreateCodableText(null))
                .ForMember(dest => dest.Code, opt => opt.MapFrom(src => src.Code))
                .ForMember(dest => dest.CodeSystemCode, opt => opt.MapFrom(src => src.CodeSystem))
                .ForMember(dest => dest.CodeSystemName, opt => opt.MapFrom(src => src.CodeSystemName))
                .ForMember(dest => dest.DisplayName, opt => opt.MapFrom(src => src.DisplayName));

            this.CreateMap<ModelSchemas.Cda.SourceDocumentStatus, NehtaSchemas.Generator.Enums.DocumentStatus>();

            this.CreateMap<DateTime, NehtaSchemas.Common.ISO8601DateTime>()
                .ConstructUsing((DateTime src) => new NehtaSchemas.Common.ISO8601DateTime(src));

            this.CreateMap<ModelSchemas.Cda.CdaHeaderMetadata, NehtaSchemas.SCSModel.Common.CdaInterval>()
                .ForMember(dest => dest.Low, opt => opt.MapFrom(src => src.AdmissionDateTime))
                .ForMember(dest => dest.High, opt => opt.MapFrom(src => src.DischargeDateTime))
                .ForMember(dest => dest.Type, opt => opt.UseValue(CDA.Generator.Common.Common.Time.Enum.IntervalType.LowHigh));

            this.CreateMap<string, Nehta.HL7.CDA.StrucDocText>()
                .ForMember(dest => dest.paragraph, opt => opt.MapFrom(src => new string[] { src }));

            this.CreateMap<string, Nehta.HL7.CDA.StrucDocParagraph>()
                .ForMember(dest => dest.Text, opt => opt.MapFrom(src => new string[] { src }));
        }

        #endregion Methods
    }
}