﻿namespace HIPS.CommonSchemas.Cda
{
    /// <summary>
    /// Address DTO. This object represents a physical address, which may be a
    /// street address or a postal address, and may be an Australian address or
    /// an international address.
    /// </summary>
    public class Address
    {
        /// <summary>
        /// Gets or sets the first line of the unstructured address.
        /// </summary>
        public string AddressLine1 { get; set; }

        /// <summary>
        /// Gets or sets the second line of the unstructured address, if there is more
        /// than one line. This should not include the line that has the suburb, state,
        /// postcode or country, as those must be provided in separate elements.
        /// </summary>
        public string AddressLine2 { get; set; }

        /// <summary>
        /// Gets or sets the address purpose. The valid codes are defined in
        /// AS 5017-2006 in the table "Health Care Client Identifier Address Purpose".
        /// </summary>
        public AddressPurpose AddressPurpose { get; set; }

        /// <summary>
        /// Gets or sets the Australian state. The valid codes are defined in AS 5017-2006
        /// in the table "Australian State/Territory Identifier - Postal".
        /// This is mandatory for an Australian address, and must not be provided for an
        /// international address.
        /// </summary>
        public AustralianState AustralianState { get; set; }

        /// <summary>
        /// Gets or sets the country name. This is mandatory.
        /// </summary>
        public string CountryName { get; set; }

        /// <summary>
        /// Gets or sets the international state code. This is optional for an international
        /// address, and must not be provided for an Australian address.
        /// </summary>
        public string InternationalStateCode { get; set; }

        /// <summary>
        /// Gets or sets the suburb, town or locality.
        /// </summary>
        public string PlaceName { get; set; }

        /// <summary>
        /// Gets or sets the postcode. This is mandatory for an Australian address, and
        /// optional for an international address.
        /// </summary>
        public string Postcode { get; set; }
    }
}