﻿using System.Runtime.Serialization;

namespace HIPS.CommonSchemas.PatientIdentifier
{
    /// <summary>
    /// This Patient Identifier is used for MRN Values
    /// </summary>

    [DataContract]
    public class Mrn : PatientIdentifierBase
    {
        #region Private Members

        private string mrn;

        #endregion Private Members

        #region Properties

        /// <summary>
        /// Gets or sets the mrn
        /// </summary>
        /// <value>
        /// Value
        /// </value>
        [DataMember]
        public string Value
        {
            get
            {
                return mrn;
            }
            set
            {
                mrn = value;
            }
        }

        #endregion Properties

        #region Methods

        /// <summary>
        /// Specific constructor for the MRN identifier.
        /// </summary>
        /// <param name="mrn">The MRN</param>
        /// <param name="hospitalCode">The hospital code</param>
        /// <param name="hospitalCodeSystem">The hospital code system</param>
        public Mrn(string mrn, string hospitalCode, string hospitalCodeSystem)
            : base(hospitalCode, hospitalCodeSystem)
        {
            this.mrn = mrn;
        }

        /// <summary>
        /// Initialises a new instance of the <see cref="Mrn" /> class. This basic constructor is used by AutoMapper.
        /// </summary>
        public Mrn()
        {
        }

        /// <summary>
        /// Represents the Mrn patient identifier as a string for logging and debugging purposes.
        /// </summary>
        /// <returns>A string representation of the object.</returns>
        public override string ToString()
        {
            return string.Format("MRN: {0}", mrn);
        }

        #endregion Methods
    }
}