﻿using System;

namespace HIPS.HibIntegration.Loader
{
    /// <summary>
    /// This exception is thrown when the IHI lookup fails for a data quality
    /// reason. The application support team do not need to see the message,
    /// so an "INFO" message is written to the log.
    ///
    /// The HL7 message broker should skip to the next message. Therefore a
    /// successful "AA" HL7 acknowledgement will be returned.
    /// </summary>
    public class IhiInfoException : Exception
    {
        public IhiInfoException(string textMessage)
            : base(textMessage)
        {
        }
    }
}