﻿using System;
using System.Runtime.Serialization;
using HIPS.CommonSchemas;

namespace HIPS.PatientSchemas
{
    /// <summary>
    /// Represents an disclosure details for a patient in hospital.
    /// </summary>
    [KnownType(typeof(PatientDisclosureDetailsResponse))]
    [Serializable]
    [DataContract]
    public class PatientDisclosureDetailsResponse
    {
        #region Private Members

        private HipsResponse hipsResponse = new HipsResponse(HipsResponseIndicator.SystemError, null);

        #endregion Private Members

        /// <summary>
        /// Gets or sets details about the admitted patient.
        /// </summary>
        [DataMember]
        public AdmittedPatient AdmittedPatient { get; set; }

        /// <summary>
        /// Gets or sets audit information from the most recent change to the
        /// disclosure status for the patient.
        /// </summary>
        [DataMember]
        public byte[] DisclosureAuditInformation { get; set; }

        /// <summary>
        /// Gets or sets the HipsResponse.
        /// Common Response Object.
        /// </summary>
        [DataMember]
        public HipsResponse HipsResponse
        {
            get { return hipsResponse; }
            set { hipsResponse = value; }
        }
    }
}