﻿using System;
using System.Runtime.Serialization;

namespace HIPS.PatientSchemas
{
    /// <summary>
    /// Represents an episode for a patient in hospital.
    /// </summary>
    [KnownType(typeof(PatientEpisode))]
    [Serializable]
    [DataContract]
    public class PatientEpisode
    {
        /// <summary>
        /// The admission date of the patient.
        /// </summary>
        [DataMember]
        public DateTime AdmissionDate { get; set; }

        /// <summary>
        /// The admission reason of the patient
        /// </summary>
        [DataMember]
        public string AdmissionReason { get; set; }

        /// <summary>
        /// Whether or not the consent has been withdrawn
        /// </summary>
        [DataMember]
        public bool? ConsentWithdrawn { get; set; }

        /// <summary>
        /// The discharge date of the patient.
        /// </summary>
        [DataMember]
        public DateTime? DischargeDate { get; set; }

        /// <summary>
        /// The patient's MRN at the hospital where the patient was admitted.
        /// </summary>
        [DataMember]
        public string Mrn { get; set; }

        /// <summary>
        /// The family name of the patient's responsible provider.
        /// </summary>
        [DataMember]
        public string ResponsibleProviderFamilyName { get; set; }

        /// <summary>
        /// The given names of the patient's responsible provider.
        /// </summary>
        [DataMember]
        public string ResponsibleProviderGivenNames { get; set; }

        /// <summary>
        /// The suffix of the patient's responsible provider (such as 'Jr' or 'Sr')
        /// </summary>
        [DataMember]
        public string ResponsibleProviderSuffix { get; set; }

        /// <summary>
        /// The title of the patient's responsible provider (such as 'Dr', 'Ms' or 'Mr').
        /// </summary>
        [DataMember]
        public string ResponsibleProviderTitle { get; set; }

        /// <summary>
        /// The source system episode id or visit number, specific to the hospital
        /// </summary>
        [DataMember]
        public string SourceSystemEpisodeId { get; set; }
    }
}