﻿using System.Data.SqlClient;
using HIPS.Common.PcehrDataStore.DataAccess;
using HIPS.CommonSchemas;
using HIPS.PcehrDataStore.Schemas;

namespace HIPS.PcehrDataStore.DataAccess
{
    /// <summary>
    /// This class allows access to the CdaDocumentNumber table
    /// </summary>
    public class CdaDocumentNumberDl : BaseDl
    {
        #region Constructors

        public CdaDocumentNumberDl(UserDetails user)
            : base(user)
        {
        }

        #endregion Constructors

        #region Methods

        /// <summary>
        /// Inserts the specified item.
        /// </summary>
        /// <param name="item">The item.</param>
        /// <returns></returns>
        public bool Insert(CdaDocumentNumber item, SqlTransaction transaction)
        {
            using (SqlCommand command = GetSqlCommand("hips.CdaDocumentNumberInsert", transaction))
            {
                return base.Insert<CdaDocumentNumber>(item, command);
            }
        }

        #endregion Methods
    }
}